#include "itfqt_common.h"

#include <itfqtlib.h>
using namespace _imax_imgtec_qt_framework;

#include "property_page.h"
#include "props_page_playback.h"
#include "ui_props_page_playback.h"

props_page_playback::props_page_playback(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::props_page_playback)
{
    ui->setupUi(this);
    
    _propPage = value_prop_page_playback;
}

props_page_playback::~props_page_playback()
{
    delete ui;
}

void props_page_playback::Init( ITQF_DepthEnv *pEnv )
{
   Store( pEnv );

   // set current value
   SetData( );

   return;
}

//
// set current data
//
void props_page_playback::SetData( void )
{   
   ITQF_DepthEnv *pEnv = GetDepthEnv( );
   bool bValue;
   int iValue;
   double dValue;
   QString strValue;
   QColor colValue;

   // *** set current data ***

   // target frame rate

   dValue = pEnv->_WontonTargetFramesRate.dGet( ); 
   strValue.sprintf( "%.2f", dValue );
   ui->wonton_target_frame_rate_edit->setText( strValue ); 

   // sampling frame number to measure frame rate

   iValue = pEnv->_WontonSampleFrameNumbers.iGet( );
   strValue.sprintf( "%d", iValue );
   ui->wonton_sampling_frames_edit->setText( strValue ); 

   // sleep milliseconds after each frame, manually set to fixed value

   iValue = pEnv->_WontonFixedSleepTime.iGet( );  
   strValue.sprintf( "%d", iValue );
   ui->wonton_fixed_sleep_time_edit->setText( strValue ); 

   // use fixed sleep time? instead of statically optimized sleep time?

   bValue = pEnv->_WontonUseFixedSleepTime.GetBool( );
   ui->wonton_use_fixed_sleep_time_check->setCheckState( bValue ? Qt::Checked : Qt::Unchecked );

   // tolerance for difference between real frame rate and target 
   
   dValue = pEnv->_WontonFrameRateTolerance.dGet( );  
   strValue.sprintf( "%.2f", dValue );
   ui->wonton_frame_rate_tolerance_edit->setText( strValue ); 

   // *** 2 ***

   // show wiper/box as line

   bValue = pEnv->_PlaybackDrawWiperLine.GetBool( );
   ui->DrawWipeBoxDrawCheck->setCheckState( bValue ? Qt::Checked : Qt::Unchecked );

   // wiper/box color

   SetWiperLineColor( );

   // box(scope) radius, pixels on screen
   iValue = pEnv->_PlaybackBoxRadius.iGet( );  
   strValue.sprintf( "%d", iValue );
   ui->PlaybackBoxRadiusEdit->setText( strValue ); 

   // size of box on chess borad interface, pixels on image
   iValue = pEnv->_PlaybackChessBoxSize.iGet( );  
   strValue.sprintf( "%d", iValue );
   ui->PlaybackChessBoxSizeEdit->setText( strValue ); 

   // draw boundaries on chess borad interface, pixels on image
   
   bValue = pEnv->_PlaybackChessDrawLines.GetBool( );
   ui->PlaybackChessDrawLines->setCheckState( bValue ? Qt::Checked : Qt::Unchecked );

   // *** 3 ***

   // number of pixels at the edge, top/bottom
   iValue = pEnv->_PlaybackEdgePixelsTop.iGet( );   
   strValue.sprintf( "%d", iValue );
   ui->PlaybackEdgePixelsTopEdit->setText( strValue );  

   // number of pixels at the edge, left/right
   iValue = pEnv->_PlaybackEdgePixelsLeft.iGet( );   
   strValue.sprintf( "%d", iValue );
   ui->PlaybackEdgePixelsLeftEdit->setText( strValue );  
   
   // nudge amount in pixels
   dValue = pEnv->_PlaybackNudgeAmount.dGet( );
   strValue.sprintf( "%.2f", dValue );
   ui->PlaybackNudgeAmountEdit->setText( strValue ); 

   // --- Done ---
   return;
}
   
bool props_page_playback::Check( void )
{  
   bool bRetCode = false;
   ITQF_DepthEnv *pEnv = GetDepthEnv( );
   bool bOK;
   bool bValue;
   int iValue;
   double dValue;
   QString strValue;
   Qt::CheckState cs;
   
   // *** set current data ***

   // target frame rate

   strValue = ui->wonton_target_frame_rate_edit->text( );
   dValue = strValue.toDouble( &bOK );
   if( !bOK ) goto DMR_EXIT;
   pEnv->_WontonTargetFramesRate.Set( dValue );  

   // number of frame to get statistics

   strValue = ui->wonton_sampling_frames_edit->text( );
   iValue = strValue.toInt( &bOK );
   if( !bOK ) goto DMR_EXIT;
   pEnv->_WontonSampleFrameNumbers.Set( iValue );  

   // sleep milliseconds after each frame, manually set to fixed value

   strValue = ui->wonton_fixed_sleep_time_edit->text( );
   iValue = strValue.toInt( &bOK );
   if( !bOK ) goto DMR_EXIT;
   pEnv->_WontonFixedSleepTime.Set( iValue );  

   // use fixed sleep time? instead of statically optimized sleep time?

   cs = ui->wonton_use_fixed_sleep_time_check->checkState( );
   bValue = ( Qt::Checked == cs ) ? true : false;
   pEnv->_WontonUseFixedSleepTime.Set( bValue );

   // tolerance for difference between real frame rate and target 

   strValue = ui->wonton_frame_rate_tolerance_edit->text( );
   dValue = strValue.toDouble( &bOK );
   if( !bOK ) goto DMR_EXIT;
   pEnv->_WontonFrameRateTolerance.Set( dValue );  

   // *** 2 ***

   // show wiper/box as line

   cs = ui->DrawWipeBoxDrawCheck->checkState( );
   bValue = ( Qt::Checked == cs ) ? true : false;
   pEnv->_PlaybackDrawWiperLine.Set( bValue );

   // wiper/box color

   // already set by button

   // box(scope) radius, pixels on screen
   
   strValue = ui->PlaybackBoxRadiusEdit->text( );
   iValue = strValue.toInt( &bOK );
   if( !bOK ) goto DMR_EXIT;
   pEnv->_PlaybackBoxRadius.Set( iValue );  

   // size of box on chess board interface, pixels on image
   
   strValue = ui->PlaybackChessBoxSizeEdit->text( );
   iValue = strValue.toInt( &bOK );
   if( !bOK ) goto DMR_EXIT;
   pEnv->_PlaybackChessBoxSize.Set( iValue );  

   // draw boundaries on chess borad interface, pixels on image
   
   cs = ui->PlaybackChessDrawLines->checkState( );
   bValue = ( Qt::Checked == cs ) ? true : false;
   pEnv->_PlaybackChessDrawLines.Set( bValue );

   // *** 3 ***

   // number of pixels at the edge, top/bottom
   
   strValue = ui->PlaybackEdgePixelsTopEdit->text( );
   iValue = strValue.toInt( &bOK );
   if( !bOK ) goto DMR_EXIT;
   pEnv->_PlaybackEdgePixelsTop.Set( iValue );  

   // number of pixels at the edge, left/right
   
   strValue = ui->PlaybackEdgePixelsLeftEdit->text( );
   iValue = strValue.toInt( &bOK );
   if( !bOK ) goto DMR_EXIT;
   pEnv->_PlaybackEdgePixelsLeft.Set( iValue );  

   // nudge amount in pixels   
   
   strValue = ui->PlaybackNudgeAmountEdit->text( );
   iValue = strValue.toInt( &bOK );
   if( !bOK ) goto DMR_EXIT;
   pEnv->_PlaybackNudgeAmount.Set( iValue );  

   // --- Done ---
   bRetCode = true;
DMR_EXIT:
   return bRetCode;
}

void props_page_playback::SetWiperLineColor( void )
{
   ITQF_DepthEnv *pEnv = GetDepthEnv( );
   QColor colValue = pEnv->_PlaybackWiperLineColor.colGet( );
   
   ui->WiperBoxColorLabel->setText( colValue.name());
   ui->WiperBoxColorLabel->setPalette( QPalette( colValue ) );
   ui->WiperBoxColorLabel->setAutoFillBackground( true );

   return;
}

void props_page_playback::on_WiperBoxColorButton_clicked()
{
   ITQF_DepthEnv *pEnv = GetDepthEnv( );
   int iRet;
   QColorDialog dlg;
   QColor colValue = pEnv->_PlaybackWiperLineColor.colGet( );
   
   dlg.setCurrentColor( colValue );

   iRet = dlg.exec( );
   if( QDialog::Accepted != iRet ) {
      goto DMR_EXIT;
   }

   colValue = dlg.currentColor( );
   pEnv->_PlaybackWiperLineColor.Set( colValue );

   SetWiperLineColor( );

DMR_EXIT:
   return;
}
