#pragma once

#include <QtCore>
#include <QtGui>
#include <QApplication>

#include <itfqtlib.h>
using namespace _imax_imgtec_qt_framework;

#include "property_page.h"
#include "ui_props_page_system.h"

#include <QWidget>

namespace Ui {
    class props_page_system;
}

class props_page_system : public QWidget, public property_page
{
    Q_OBJECT

public:
    explicit props_page_system(QWidget *parent = 0);
    ~props_page_system();

private:

private:
    Ui::props_page_system *ui;
    
private:
   void SetMonitorPosition( void ); 
   void Set3dtvFormat( void ); 

public:
   virtual void SetData( void );
   virtual bool Check( void );
   virtual void Init( ITQF_DepthEnv *pEnv );

private slots:
    void on_system_sampler_batch_path_button_clicked();
    void on_system_fullscreen_side_left_radio_clicked(bool checked);
    void on_system_fullscreen_side_right_radio_clicked(bool checked);
    void on_system_3dtv_side_by_side_radio_clicked(bool checked);
    void on_system_3dtv_top_bottom_radio_clicked(bool checked);
    void on_system_3dtv_dlp_radio_clicked(bool checked);
    void on_system_3dtv_opengl_quadbuffer_radio_clicked(bool checked);
};
