#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "scope_panes.h"
#include "scope_common.h"

//
// wiper-stype line, two textures
//
void RefreshWiper_WON(  unsigned int uiLeftTexture,
                      unsigned int uiRightTexture,
                      bool bVertical, // [i] true for vertical wiper
                      int nWiperX, // [i] wiper position on screen
                      int nWiperY, // [i] wiper position on screen
                      const pixq_ScreenPara *pScreen )
{
   unsigned int uiImgTexture[2];
   int nScreenWidth, nScreenHeight;
   double dScreenWiperX, dScreenWiperY, dOrthoX[2], dOrthoY[2];
   double dTexWiperX, dTexWiperY, dTexWidth, dTexHeight;
   double dTexCooX[2], dTexCooY[2];
   double dScreenPosX[2], dScreenPosY[2];

   pixq_PanePara *pFlip = pScreen->GetSingleFlip( ); 

   // --- get texture ID ---

   uiImgTexture[0] = uiLeftTexture;
   uiImgTexture[1] = uiRightTexture;

   // *** wiper poosition in viewport/texture ***

   pFlip->ViewportToPixelCoo( nWiperX, nWiperY, &dTexWiperX, &dTexWiperY );
   pFlip->ViewportToScreenCoo( nWiperX, nWiperY, &dScreenWiperX, &dScreenWiperY );

	dOrthoX[0] = pFlip->GetOrthoX( 0 );
   dOrthoX[1] = pFlip->GetOrthoX( 1 ); 
   dOrthoY[0] = pFlip->GetOrthoY( 0 );
   dOrthoY[1] = pFlip->GetOrthoY( 1 );
   
   dTexCooX[0] = pFlip->GetTexCooX( 0 );
   dTexCooX[1] = pFlip->GetTexCooX( 1 );
   dTexCooY[0] = pFlip->GetTexCooY( 0 );
   dTexCooY[1] = pFlip->GetTexCooY( 1 );

   dScreenPosX[0] = pFlip->GetScreenPosX( 0 );
   dScreenPosX[1] = pFlip->GetScreenPosX( 1 );
   dScreenPosY[0] = pFlip->GetScreenPosY( 0 );
   dScreenPosY[1] = pFlip->GetScreenPosY( 1 );

   nScreenWidth = pFlip->GetScreenWidth( );
   nScreenHeight = pFlip->GetScreenHeight( );
   glViewport( 0, 0, nScreenWidth, nScreenHeight );

   //glFlush( );
   glDrawBuffer( GL_BACK ); 
   glClearColor( 0.0f, 0.0f, 0.0f, 0.0f );  // non-black bkgr, less ghosting
   glClear( GL_COLOR_BUFFER_BIT);// | GL_DEPTH_BUFFER_BIT );

   glDisable( GL_DEPTH_TEST ); 
   glDisable( GL_DEPTH );
   glEnable( GL_TEXTURE_RECTANGLE_ARB );

   //glColor4f( 1.0f, 1.0f, 1.0f, 1.0f );

   // display

   glMatrixMode( GL_PROJECTION );
   glLoadIdentity( );
	glOrtho( dOrthoX[0], dOrthoX[1], dOrthoY[0], dOrthoY[1], -1.0, 1.0 );
   
   glMatrixMode( GL_MODELVIEW );
   glLoadIdentity( );
   
   // --- wiper position on the texture original image ---
   // --- display original image ---
   
   glEnable( GL_TEXTURE_RECTANGLE_ARB );

   if( bVertical ) {   

      // *** vertical wiper ***
      dTexWidth = pScreen->GetImageWidth( );

      if( 0.0 <= dTexWiperX && dTexWiperX <= dTexWidth ) {
         // --- display the first image ---
         
         glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture[0] );         
         glBegin( GL_QUADS );
            glTexCoord2d( dTexCooX[0], dTexCooY[1] );
            glVertex3d( dScreenPosX[0], dScreenPosY[1], 0 );
            glTexCoord2d( dTexCooX[0], dTexCooY[0] );
            glVertex3d( dScreenPosX[0], dScreenPosY[0], 0 );
            glTexCoord2d( dTexWiperX, dTexCooY[0] );
            glVertex3d( dScreenWiperX, dScreenPosY[0], 0 );
            glTexCoord2d( dTexWiperX, dTexCooY[1] );
            glVertex3d( dScreenWiperX, dScreenPosY[1], 0 );
         glEnd( );  
      
         glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture[1] );         
         glBegin( GL_QUADS );
            glTexCoord2d( dTexWiperX, dTexCooY[1] );
            glVertex3d( dScreenWiperX, dScreenPosY[1], 0 );
            glTexCoord2d( dTexWiperX, dTexCooY[0] );
            glVertex3d( dScreenWiperX, dScreenPosY[0], 0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[0] );
            glVertex3d( dScreenPosX[1], dScreenPosY[0], 0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[1] );
            glVertex3d( dScreenPosX[1], dScreenPosY[1], 0 );
         glEnd( );

      } else if( 0.0 > dTexWiperX ) { 
         
         // wiper left of the whole image, just show the second
         glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture[1] );         
         glBegin( GL_QUADS );
            glTexCoord2d( dTexCooX[0], dTexCooY[1] );
            glVertex3d( dScreenPosX[0], dScreenPosY[1], 0 );
            glTexCoord2d( dTexCooX[0], dTexCooY[0] );
            glVertex3d( dScreenPosX[0], dScreenPosY[0], 0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[0] );
            glVertex3d( dScreenPosX[1], dScreenPosY[0], 0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[1] );
            glVertex3d( dScreenPosX[1], dScreenPosY[1], 0 );
         glEnd( );

      } else {
         
         // wiper right of the whole image, just show the first
         glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture[0] );         
         glBegin( GL_QUADS );
            glTexCoord2d( dTexCooX[0], dTexCooY[1] );
            glVertex3d( dScreenPosX[0], dScreenPosY[1], 0 );
            glTexCoord2d( dTexCooX[0], dTexCooY[0] );
            glVertex3d( dScreenPosX[0], dScreenPosY[0], 0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[0] );
            glVertex3d( dScreenPosX[1], dScreenPosY[0], 0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[1] );
            glVertex3d( dScreenPosX[1], dScreenPosY[1], 0 );
         glEnd( );

      }

   } else {

      // *** horizontal wiper ***
      dTexHeight = pScreen->GetImageHeight( );
      
      if( 0.0 <= dTexWiperY && dTexWiperY <= dTexHeight ) {
      
         // --- display the first image ---
         
         glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture[0] );
         glBegin( GL_QUADS );
            glTexCoord2d( dTexCooX[0], dTexCooY[1] );
            glVertex3d( dScreenPosX[0], dScreenPosY[1], 0.0 );
            glTexCoord2d( dTexCooX[0], dTexWiperY );
            glVertex3d( dScreenPosX[0], dScreenWiperY, 0.0 );
            glTexCoord2d( dTexCooX[1], dTexWiperY );
            glVertex3d( dScreenPosX[1], dScreenWiperY, 0.0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[1] );
            glVertex3d( dScreenPosX[1], dScreenPosY[1], 0.0 );
         glEnd( );  
      
         // --- display the second image ---

         glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture[1] );
         glBegin( GL_QUADS );
            glTexCoord2d( dTexCooX[0], dTexWiperY );
            glVertex3d( dScreenPosX[0], dScreenWiperY, 0.0 );
            glTexCoord2d( dTexCooX[0], dTexCooY[0] );
            glVertex3d( dScreenPosX[0], dScreenPosY[0], 0.0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[0] );
            glVertex3d( dScreenPosX[1], dScreenPosY[0], 0.0 );
            glTexCoord2d( dTexCooX[1], dTexWiperY );
            glVertex3d( dScreenPosX[1], dScreenWiperY, 0.0 );
         glEnd( );

      } else if( 0.0 > dTexWiperY ) {
         
         // --- display the first image ---

         glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture[0] );
         glBegin( GL_QUADS );
            glTexCoord2d( dTexCooX[0], dTexCooY[1] );
            glVertex3d( dScreenPosX[0], dScreenPosY[1], 0.0 );
            glTexCoord2d( dTexCooX[0], dTexCooY[0] );
            glVertex3d( dScreenPosX[0], dScreenPosY[0], 0.0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[0] );
            glVertex3d( dScreenPosX[1], dScreenPosY[0], 0.0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[1] );
            glVertex3d( dScreenPosX[1], dScreenPosY[1], 0.0 );
         glEnd( );  

      } else {

         // --- display the second image ---

         glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture[1] );
         glBegin( GL_QUADS );
            glTexCoord2d( dTexCooX[0], dTexCooY[1] );
            glVertex3d( dScreenPosX[0], dScreenPosY[1], 0.0 );
            glTexCoord2d( dTexCooX[0], dTexCooY[0] );
            glVertex3d( dScreenPosX[0], dScreenPosY[0], 0.0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[0] );
            glVertex3d( dScreenPosX[1], dScreenPosY[0], 0.0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[1] );
            glVertex3d( dScreenPosX[1], dScreenPosY[1], 0.0 );
         glEnd( );

      }
   }

   // --- draw wiper line ---

   glDisable( GL_TEXTURE_RECTANGLE_ARB ); 
   glDisable( GL_LIGHTING ); 
   glDisable( GL_LIGHT0 );
   glDisable( GL_DEPTH_TEST );
   glLineWidth( 1.0 );   
   glColor3f( 1.0f, 1.0f, 0.0f );

   glBegin( GL_LINES );
   if( bVertical ) {            
      glVertex3d( dScreenWiperX, dOrthoY[0], 0.1 ); 
      glVertex3d( dScreenWiperX, dOrthoY[1], 0.1 );  
   } else {
      glVertex3d( dOrthoX[0], dScreenWiperY, 0.1 );  
      glVertex3d( dOrthoX[1], dScreenWiperY, 0.1 );  
   }
   glEnd( );

   // --- Done ---
   return;
}


static void DrawScope_WON( double *dScreenBndX,
                          double*dScreenBndY )
{
   // --- draw box line ---

   glDisable( GL_TEXTURE_RECTANGLE_ARB );   
   glDisable( GL_LIGHTING ); 
   glDisable( GL_LIGHT0 );
   glDisable( GL_DEPTH_TEST );
   glLineWidth( 1.0 );   
   glColor3f( 1.0f, 1.0f, 0.0f );

   glBegin( GL_LINE_STRIP );        
      glVertex3d( dScreenBndX[0], dScreenBndY[0], 1.0 ); 
      glVertex3d( dScreenBndX[1], dScreenBndY[1], 1.0 );  
      glVertex3d( dScreenBndX[2], dScreenBndY[2], 1.0 );  
      glVertex3d( dScreenBndX[3], dScreenBndY[3], 1.0 );  
      glVertex3d( dScreenBndX[0], dScreenBndY[0], 1.0 ); 
   glEnd( );

   return;
}


//
// wiper-stype line, two textures
//
void RefreshScope_WON(  unsigned int uiLeftTexture,
                       unsigned int uiRightTexture,
                       bool bInputInBox, // [i] true for vertical wiper
                       int nBoxX, // [i] box center position on screen
                       int nBoxY, // [i] box center position on screen
                       int nBoxRaiuds, // [i] box radius on screen
                        const pixq_ScreenPara *pScreen )
{
   unsigned int uiImgTexture[2];
   int k, nScreenWidth, nScreenHeight;
   int iScreenBoxX0, iScreenBoxX1, iScreenBoxY0, iScreenBoxY1;
   double dScreenBoxX[4], dScreenBoxY[4], dOrthoX[2], dOrthoY[2];
   double dScreenBndX[4], dScreenBndY[4];
   double dTexBoxX[4], dTexBoxY[4], dTexCooX[2], dTexCooY[2];
   double dScreenPosX[2], dScreenPosY[2];
   double dTexWidth, dTexHeight, dTexBoxX0, dTexBoxX1, dTexBoxY0, dTexBoxY1;
   double dScreenBoxX0, dScreenBoxX1, dScreenBoxY0, dScreenBoxY1;
   double dScreenBndX0, dScreenBndY0, dScreenBndX1, dScreenBndY1;

   pixq_PanePara *pFlip = pScreen->GetSingleFlip( ); 

   // *** wiper poosition in viewport/texture ***

   iScreenBoxX0 = nBoxX - nBoxRaiuds;
   iScreenBoxX1 = nBoxX + nBoxRaiuds;

   iScreenBoxY0 = nBoxY + nBoxRaiuds;
   iScreenBoxY1 = nBoxY - nBoxRaiuds;

   // area to display

   pFlip->ViewportToPixelCoo( iScreenBoxX0, iScreenBoxY0, &dTexBoxX0, &dTexBoxY0 );
   pFlip->ViewportToPixelCoo( iScreenBoxX1, iScreenBoxY1, &dTexBoxX1, &dTexBoxY1 );
   
   pFlip->ViewportToScreenCoo( iScreenBoxX0, iScreenBoxY0, &dScreenBoxX0, &dScreenBoxY0 );
   pFlip->ViewportToScreenCoo( iScreenBoxX1, iScreenBoxY1, &dScreenBoxX1, &dScreenBoxY1 );

   dScreenBndX0 = dScreenBoxX0; 
   dScreenBndY0 = dScreenBoxY0; 
   dScreenBndX1 = dScreenBoxX1; 
   dScreenBndY1 = dScreenBoxY1; 

   dScreenBndX[0] = dScreenBndX0;
   dScreenBndX[1] = dScreenBndX1;
   dScreenBndX[2] = dScreenBndX1;
   dScreenBndX[3] = dScreenBndX0;
                 
   dScreenBndY[0] = dScreenBndY0;
   dScreenBndY[1] = dScreenBndY0;
   dScreenBndY[2] = dScreenBndY1;
   dScreenBndY[3] = dScreenBndY1;

   dTexWidth = pScreen->GetImageWidth( );
   dTexHeight = pScreen->GetImageHeight( );

   // modify according to the box position
   // check the box position

   if( 0.0 > dTexBoxX0 ) {
      dTexBoxX0 = 0.0;
      dScreenBoxX0 = pFlip->TexToScreenXCoo( dTexBoxX0 );
   }

   if( dTexBoxX1 > dTexWidth ) {
      dTexBoxX1 = dTexWidth;
      dScreenBoxX1 = pFlip->TexToScreenXCoo( dTexBoxX1 );
   }

   if( 0.0 > dTexBoxY1 ) {
      dTexBoxY1 = 0.0;
      dScreenBoxY1 = pFlip->TexToScreenYCoo( dTexBoxY1 );
   }

   if( dTexBoxY0 > dTexHeight ) {
      dTexBoxY0 = dTexHeight;
      dScreenBoxY0 = pFlip->TexToScreenYCoo( dTexBoxY0 );
   }

   // set four corners

   dTexBoxX[0] = dTexBoxX0;
   dTexBoxX[1] = dTexBoxX1;
   dTexBoxX[2] = dTexBoxX1;
   dTexBoxX[3] = dTexBoxX0;

   dTexBoxY[0] = dTexBoxY0;
   dTexBoxY[1] = dTexBoxY0;
   dTexBoxY[2] = dTexBoxY1;
   dTexBoxY[3] = dTexBoxY1;

   dScreenBoxX[0] = dScreenBoxX0;
   dScreenBoxX[1] = dScreenBoxX1;
   dScreenBoxX[2] = dScreenBoxX1;
   dScreenBoxX[3] = dScreenBoxX0;
                 
   dScreenBoxY[0] = dScreenBoxY0;
   dScreenBoxY[1] = dScreenBoxY0;
   dScreenBoxY[2] = dScreenBoxY1;
   dScreenBoxY[3] = dScreenBoxY1;
   
	dOrthoX[0] = pFlip->GetOrthoX( 0 );
   dOrthoX[1] = pFlip->GetOrthoX( 1 ); 
   dOrthoY[0] = pFlip->GetOrthoY( 0 );
   dOrthoY[1] = pFlip->GetOrthoY( 1 );
   
   dTexCooX[0] = pFlip->GetTexCooX( 0 );
   dTexCooX[1] = pFlip->GetTexCooX( 1 );
   dTexCooY[0] = pFlip->GetTexCooY( 0 );
   dTexCooY[1] = pFlip->GetTexCooY( 1 );

   dScreenPosX[0] = pFlip->GetScreenPosX( 0 );
   dScreenPosX[1] = pFlip->GetScreenPosX( 1 );
   dScreenPosY[0] = pFlip->GetScreenPosY( 0 );
   dScreenPosY[1] = pFlip->GetScreenPosY( 1 );

   nScreenWidth = pFlip->GetScreenWidth( );
   nScreenHeight = pFlip->GetScreenHeight( );
   glViewport( 0, 0, nScreenWidth, nScreenHeight );

   //glFlush( );
   glDrawBuffer( GL_BACK ); 
   glClearColor( 0.0f, 0.0f, 0.0f, 0.0f );  // non-black bkgr, less ghosting
   glClear( GL_COLOR_BUFFER_BIT);// | GL_DEPTH_BUFFER_BIT );

   glDisable( GL_DEPTH_TEST ); 
   glDisable( GL_DEPTH );
   glEnable( GL_TEXTURE_RECTANGLE_ARB );

   //glColor4f( 1.0f, 1.0f, 1.0f, 1.0f );

   // display

   glMatrixMode( GL_PROJECTION );
   glLoadIdentity( );
	glOrtho( dOrthoX[0], dOrthoX[1], dOrthoY[0], dOrthoY[1], -1.0, 1.0 );
   
   glMatrixMode( GL_MODELVIEW );
   glLoadIdentity( );
   
   // --- wiper position on the texture original image ---
   // --- display original image ---
   glEnable( GL_TEXTURE_RECTANGLE_ARB );

   if( bInputInBox ) {
      uiImgTexture[0] = uiRightTexture;
      uiImgTexture[1] = uiLeftTexture;
   } else {
      uiImgTexture[0] = uiLeftTexture;
      uiImgTexture[1] = uiRightTexture;
   }

   // --- display the whole image ---
   
   glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture[0] );         
   glBegin( GL_QUADS );
      glTexCoord2d( dTexCooX[0], dTexCooY[0] );
      glVertex3d( dScreenPosX[0], dScreenPosY[0], 0.0 );
      //
      glTexCoord2d( dTexCooX[1], dTexCooY[0] );
      glVertex3d( dScreenPosX[1], dScreenPosY[0], 0.0 );
      //
      glTexCoord2d( dTexCooX[1], dTexCooY[1] );
      glVertex3d( dScreenPosX[1], dScreenPosY[1], 0.0 );
      //
      glTexCoord2d( dTexCooX[0], dTexCooY[1] );
      glVertex3d( dScreenPosX[0], dScreenPosY[1], 0.0 );
   glEnd( );  

   if( 0.0 > dTexBoxX1 || dTexBoxX0 > dTexWidth  ) {
      DrawScope_WON( dScreenBndX, dScreenBndY ); 
      goto PIX_EXIT;
   }

   if( 0.0 > dTexBoxY1 || dTexBoxY0 > dTexHeight  ) {
      DrawScope_WON( dScreenBndX, dScreenBndY ); 
      goto PIX_EXIT;
   }

   // --- display the image inside box  ---

   glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture[1] );         
   glBegin( GL_QUADS );
      for( k = 0 ; k < 4 ; k++ ) {
         glTexCoord2d( dTexBoxX[k], dTexBoxY[k] );
         glVertex3d( dScreenBoxX[k], dScreenBoxY[k], 0.0 );
      }
   glEnd( );

   // --- draw box line ---

   DrawScope_WON( dScreenBndX, dScreenBndY ); 

   // --- Done ---
PIX_EXIT:
   return;
}


//
// display single(first or second texture) on the pane
//
void RefreshTexture_WON( unsigned int uiImgTexture,
                        const pixq_FlipPara *pFlip )
{
   int nScreenWidth, nScreenHeight;
   double dOrthoX[2], dOrthoY[2], dTexCooX[2], dTexCooY[2];
   double dScreenPosX[2], dScreenPosY[2];

	dOrthoX[0] = pFlip->GetOrthoX( 0 );
   dOrthoX[1] = pFlip->GetOrthoX( 1 ); 
   dOrthoY[0] = pFlip->GetOrthoY( 0 );
   dOrthoY[1] = pFlip->GetOrthoY( 1 );
   
   dTexCooX[0] = pFlip->GetTexCooX( 0 );
   dTexCooX[1] = pFlip->GetTexCooX( 1 );
   dTexCooY[0] = pFlip->GetTexCooY( 0 );
   dTexCooY[1] = pFlip->GetTexCooY( 1 );

   dScreenPosX[0] = pFlip->GetScreenPosX( 0 );
   dScreenPosX[1] = pFlip->GetScreenPosX( 1 );
   dScreenPosY[0] = pFlip->GetScreenPosY( 0 );
   dScreenPosY[1] = pFlip->GetScreenPosY( 1 );

   nScreenWidth = pFlip->GetScreenWidth( );
   nScreenHeight = pFlip->GetScreenHeight( );
   glViewport( 0, 0, nScreenWidth, nScreenHeight );

   //glFlush( );
   glDrawBuffer( GL_BACK ); 
   glClearColor( 0.0f, 0.0f, 0.0f, 0.0f );  // non-black bkgr, less ghosting
   glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

   glMatrixMode( GL_PROJECTION );
   glLoadIdentity( );
	glOrtho( dOrthoX[0], dOrthoX[1], dOrthoY[0], dOrthoY[1], -1.0, 1.0 );

   glMatrixMode( GL_MODELVIEW );
   glLoadIdentity( );
   
   // --- get dimension ---

   glDisable( GL_DEPTH_TEST ); 
   glDisable( GL_DEPTH );
   glEnable( GL_TEXTURE_RECTANGLE_ARB );

   glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture ); 
   
   //glColor4f( 1.0f, 1.0f, 1.0f, 1.0f );
 
   glBegin( GL_QUADS );
      glTexCoord2d( dTexCooX[0], dTexCooY[1] );
      glVertex3d( dScreenPosX[0], dScreenPosY[1], 0 );

      glTexCoord2d( dTexCooX[0], dTexCooY[0] );
      glVertex3d( dScreenPosX[0], dScreenPosY[0], 0 );

      glTexCoord2d( dTexCooX[1], dTexCooY[0] );
      glVertex3d( dScreenPosX[1], dScreenPosY[0], 0 );

      glTexCoord2d( dTexCooX[1], dTexCooY[1] );
      glVertex3d( dScreenPosX[1], dScreenPosY[1], 0 );
   glEnd( );  
   
   return;
}

void RefreshTexture_WON( unsigned int uiImgTexture,
                        short sPaneType,
                        short sPaneShowMode,                       
                        const pixq_ScreenPara *pScreen )
{
   int nScreenWidth, nScreenHeight;
   double dOrthoX[2], dOrthoY[2], dTexCooX[2], dTexCooY[2];
   double dScreenPosX[2], dScreenPosY[2];

   pixq_PanePara *pFlip = (pixq_PanePara*)NULL;
   
   pScreen->GetSingleFlip( ); 

   switch( sPaneShowMode ) {
   case pixq_ScreenPara::ScopePaneShowFirst: 
   case pixq_ScreenPara::ScopePaneShowSecond:
      pFlip = pScreen->GetSingleFlip( );
      break;

   case pixq_ScreenPara::ScopePaneShowHorizontalSplit:
      switch( sPaneType ) {
      case ScopePane::ScopePaneSplitLeft:  
         pFlip = pScreen->GetLeftFlip( );
         break;    
      case ScopePane::ScopePaneSplitRight:
         pFlip = pScreen->GetRightFlip( );
         break;
      default:
         goto PIX_EXIT;
         break;
      }
      break;

   case pixq_ScreenPara::ScopePaneShowVerticalSplit:
      switch( sPaneType ) {
      case ScopePane::ScopePaneSplitLeft:  
         pFlip = pScreen->GetUpperFlip( );
         break;    
      case ScopePane::ScopePaneSplitRight:
         pFlip = pScreen->GetLowerFlip( );
         break;
      default:
         goto PIX_EXIT;
         break;
      }
      break;

   default:
      goto PIX_EXIT;
      break;
   }

	dOrthoX[0] = pFlip->GetOrthoX( 0 );
   dOrthoX[1] = pFlip->GetOrthoX( 1 ); 
   dOrthoY[0] = pFlip->GetOrthoY( 0 );
   dOrthoY[1] = pFlip->GetOrthoY( 1 );
   
   dTexCooX[0] = pFlip->GetTexCooX( 0 );
   dTexCooX[1] = pFlip->GetTexCooX( 1 );
   dTexCooY[0] = pFlip->GetTexCooY( 0 );
   dTexCooY[1] = pFlip->GetTexCooY( 1 );

   dScreenPosX[0] = pFlip->GetScreenPosX( 0 );
   dScreenPosX[1] = pFlip->GetScreenPosX( 1 );
   dScreenPosY[0] = pFlip->GetScreenPosY( 0 );
   dScreenPosY[1] = pFlip->GetScreenPosY( 1 );

   nScreenWidth = pFlip->GetScreenWidth( );
   nScreenHeight = pFlip->GetScreenHeight( );
   glViewport( 0, 0, nScreenWidth, nScreenHeight );

   //glFlush( );
   glDrawBuffer( GL_BACK ); 
   glClearColor( 0.0f, 0.0f, 0.0f, 0.0f );  // non-black bkgr, less ghosting
   glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

   glMatrixMode( GL_PROJECTION );
   glLoadIdentity( );
	glOrtho( dOrthoX[0], dOrthoX[1], dOrthoY[0], dOrthoY[1], -1.0, 1.0 );

   glMatrixMode( GL_MODELVIEW );
   glLoadIdentity( );
   
   // --- get dimension ---

   glDisable( GL_DEPTH_TEST ); 
   glDisable( GL_DEPTH );
   glEnable( GL_TEXTURE_RECTANGLE_ARB );

   glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture ); 
   
   //glColor4f( 1.0f, 1.0f, 1.0f, 1.0f );
 
   glBegin( GL_QUADS );
      glTexCoord2d( dTexCooX[0], dTexCooY[1] );
      glVertex3d( dScreenPosX[0], dScreenPosY[1], 0 );

      glTexCoord2d( dTexCooX[0], dTexCooY[0] );
      glVertex3d( dScreenPosX[0], dScreenPosY[0], 0 );

      glTexCoord2d( dTexCooX[1], dTexCooY[0] );
      glVertex3d( dScreenPosX[1], dScreenPosY[0], 0 );

      glTexCoord2d( dTexCooX[1], dTexCooY[1] );
      glVertex3d( dScreenPosX[1], dScreenPosY[1], 0 );
   glEnd( );  
   
PIX_EXIT:
   return;
}


