#pragma once

#include <QtCore>
#include <QtGui>
#include <QWidget>

class scope_window;

class scope_dock : public QDockWidget
{
   Q_OBJECT
 
public:
   enum {
      ScopeDockNone = 0,
      ScopeDockIndex,
      ScopeDockChart,
      ScopeDockProps,
      ScopeDockMonitor,
   } ScopeDockType;

public:
   scope_dock ( const QString & title, QWidget * parent = 0 );
   scope_dock ( QWidget * parent = 0 );
   ~scope_dock();

private:

protected:

public:
   void SetMainWindow( scope_window *pMain ) { _pMainWindow = pMain; }
   scope_window *GetMainWindow( void ) { return _pMainWindow; }

private slots:

private:
   // pointer to the main window
   scope_window *_pMainWindow;
   
   // dock type, one of ScopeDockType
   short _sType;

   // this set to true for the first time when the dock is actually visiable
   bool _bInit;

protected:   
   void resizeEvent( QResizeEvent* );
   void moveEvent( QMoveEvent *eve );
   void showEvent( QShowEvent *eve );
   
public:
   void SetType( short sType ) { _sType = sType; }
   short sGetType( void ) { return _sType; }

   void SetInit( bool bInit ) { _bInit = bInit; }
   bool GetInit( void ) { return _bInit; }

};
