#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "scope_common.h"
#include "scope_panes.h"
#include "scope_monitor.h"
#include "scope_window.h"

ScopePane::ScopePane(QWidget *parent)
    : QGLWidget(parent)
{
   _sPaneType = ScopePaneUnknown;
   _pMainWindow = (scope_window*)NULL;   

   _bMouseDragging = false;
   _PaneTexture.Init( );
   _bWiperVertical = true;
   
   return;
}

ScopePane::~ScopePane()
{
   return;
}

void ScopePane::showEvent( QShowEvent * /*eve*/ )
{
   RefreshSingle( );

   return;
}

void ScopePane::initializeGL( void )
{
   glEnable( GL_LIGHTING );
   glEnable( GL_LIGHT0 );
   glEnable( GL_DEPTH_TEST );
   glEnable( GL_NORMALIZE );

   glClearColor( 0.0f, 0.0f, 0.0f, 1.0f ); 

   return;
}

void ScopePane::paintGL( void )
{
   RefreshSingle( );

   return;
}

void ScopePane::resizeEvent( QResizeEvent * /*eve*/ )
{
   scope_window *pMain = (scope_window*)GetMainWindow( );

   if( !pMain->ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   // set viewport

   ChangeScreenSize( );

PIX_EXIT:
   return;
}

void ScopePane::keyPressEvent( QKeyEvent *eve )
{
   scope_window *pMain = (scope_window*)GetMainWindow( );
   
   if( !pMain->ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   int iKey = eve->key( );

   if( pMain->ProcessKeyEvent( _sPaneType, iKey ) ) {
      goto PIX_EXIT;
   }

   QGLWidget::keyPressEvent( eve );

PIX_EXIT:
   return;
}

void ScopePane::wheelEvent( QWheelEvent *eve )
{
   scope_window *pMain = (scope_window*)GetMainWindow( );
   int iDelta;

   if( !pMain->ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   switch( _sPaneType ) {
   case ScopePaneSplitLeft: 
   case ScopePaneSplitRight:
      break;

   case ScopePaneIndex: 
      goto PIX_EXIT;
      break;
   }

   iDelta = eve->delta( );
   if( pMain->ProcessWheelEvent( _sPaneType, iDelta ) ) {
      goto PIX_EXIT;
   }

PIX_EXIT:
   return;
}

//
// mouse button pressed
//
void ScopePane::mousePressEvent( QMouseEvent *eve )
{
   scope_window *pMain = (scope_window*)GetMainWindow( );
   short sLeftMouseMode = pMain->sGetLeftMouseMode( );

   QSize rect = size( );

   if( !pMain->ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   switch( eve->button( ) ) {
   //
   // Left Click
   //
   case Qt::LeftButton:   
      switch( _sPaneType ) {
      case ScopePaneSplitLeft: 
      case ScopePaneSplitRight: 
         // right pane -> switch viewing method according to the mode         
         switch( sLeftMouseMode ) {
         case scope_window::MouseLeftClickNone:
         default:
            // two sequence -> switch between them
            SwitchPaneMode( );
            break;
         }
         break;          

      case ScopePaneIndex: 
         RefreshSingle( );
         break;
      }
      break;

   //
   // Right Click
   //
   case Qt::RightButton:      
      _bMouseDragging = true;
      _MousePoint = eve->pos();
      RefreshSingle( );
      break;
   }

   //QGLWidget::mousePressEvent( eve );

PIX_EXIT:
   return;
}

//
// mouse button released
//
void ScopePane::mouseReleaseEvent( QMouseEvent *eve )
{
   scope_window *pMain = (scope_window*)GetMainWindow( );

   if( !pMain->ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   // right button

   if( Qt::RightButton == eve->button( ) ) {
      _bMouseDragging = false;
      goto PIX_EXIT;
   }

   //QGLWidget::mouseReleaseEvent( eve );

PIX_EXIT:
   return;
}

void ScopePane::mouseMoveEvent( QMouseEvent *eve )
{
   scope_window *pMain = (scope_window*)GetMainWindow( );
   short sPaneShowMode = pMain->GetPaneShowMode( );
   QSize rect = size( );

   int iMouseX = eve->x();
   int iMouseY = rect.height( ) - eve->y();

   if( !pMain->ValidPaneDisplayMode( ) ) {
      QGLWidget::mouseMoveEvent( eve );
      goto PIX_EXIT;
   }

   // right button pressed down
   // --- drag the image ---

   if( Qt::RightButton == eve->button( ) ) {
      // right mouse button is being pressed
       setCursor( Qt::DragMoveCursor );
      // setCursor( Qt::MoveCursor );
      _bMouseDragging = true;
   }
   
   // --- display coordinate ---

   pMain->GetColor( _sPaneType, iMouseX, iMouseY );
   
   // --- drag the image ---

   if( _bMouseDragging ) {
      int iX = eve->x() - _MousePoint.x( );
      int iY = eve->y() - _MousePoint.y( );
      pMain->ProcessScrollEvent( _sPaneType, iX, iY );
   }

   _MousePoint.setX( eve->x() );
   _MousePoint.setY( eve->y() );

   // *** if wiper mode, move wiper ***

   switch( _sPaneType ) {
   case ScopePaneSplitLeft:  
      switch( sPaneShowMode ) {
      case pixq_ScreenPara::ScopePaneShowWiper:  
         _nWiperX = iMouseX; 
         _nWiperY = iMouseY;    
         RefreshSingle( );
         break;
      
      case pixq_ScreenPara::ScopePaneShowInBox:  
      case pixq_ScreenPara::ScopePaneShowOutBox:  
         _nBoxCenterX = iMouseX;
         _nBoxCenterY = iMouseY;    
         RefreshSingle( );
         break;

      default: 
         break;
      }
      break;
   }

PIX_EXIT:
   return;
}

void ScopePane::closeEvent( QCloseEvent * /*eve*/ )
{
   DeInit( );
}
