#pragma once

#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

class scope_window;
class ScopeMonitor;

class ScopePane : public QGLWidget
{
   Q_OBJECT
  
public:
   enum {
      ScopePaneUnknown = 0,
      ScopePaneSplitLeft, 
      ScopePaneSplitRight, 
      ScopePaneIndex,
   } ScopePaneType;

public:
   ScopePane(QWidget *parent = 0);
   ~ScopePane();

protected:   
   void showEvent( QShowEvent *eve );

private:
   // what kind of pane is this? one of ScopePaneType
   short _sPaneType;

   // pointer to the main window
   scope_window *_pMainWindow;
         
   // wiper position on texture coordinate
   int _nWiperX; 
   int _nWiperY; 

   QPoint _MousePoint;
   	      
   // true if mouse is dragging
   bool _bMouseDragging;

   // check if this is Opengl 2.0 or higher
   bool _bOpenGL2;
   
   // --- OpenGL texture for image ---

   pixq_PaneTexture _PaneTexture;

   // line width to draw tag/wiper line
   float _fMinLineWidth;
   float _fMaxLineWidth;
   float _fSelectedLineWidth;

   // true if wiper direction is vertical, false for horizontal wiper
   bool _bWiperVertical;

   // box radius on viewport unit
   int _nBoxRadius; 

   // box center on viewport
   int _nBoxCenterX; 
   int _nBoxCenterY; 

   // displa image color mode, one of PixTOPOImageDisplayColor
   short _sDisplayColor;
 
public:
   // draw chapters
   void RefreshClear( void ) ;

   // --- OpenGL finctions ---
   void RefreshTexture( void );
   void RefreshWiperDouble( void );

   void Init( short sSide );
   void DeInit( void );
   void RefreshSingle( void );
   void DrawIndexArea( void );

   void SetModeCursor( void );

   void ResetPane( void );
   
   void SetCurrentViewport( void );
   void ChangeScreenSize(void);

   void SetMainWindow( scope_window *pMain ) { _pMainWindow = pMain; }
   scope_window *GetMainWindow( void ) { return _pMainWindow; }

   void SetWiperVertical( bool bMode ) { _bWiperVertical = bMode; } 

   void InitWiperPos( void );

   short GetDisplayColor( void ) { return _sDisplayColor; }
   void SetDisplayColor( short sDisplayColor ) { _sDisplayColor = sDisplayColor; }


   void SwitchPaneMode( void );

   bool GetWiperVertical( void ) { return _bWiperVertical; }


   void ShiftBoxRadius( int iShift ) { _nBoxRadius = iShift + _nBoxRadius; }
      
   void RefreshBoxDouble( void );
   void InitTexture( void );

   unsigned int GetColorModeTexture( void ); 
   unsigned int GetColorModeTexture( int iImage ); 
   void SetColorModeTexture( int iImage, bool bSet ); 
   
   bool InitializeOpenGL( void );
   
   bool CreateImageTexture( pixq_Matrix<unsigned short> *usRed, 
                           pixq_Matrix<unsigned short> *usGrn, 
                           pixq_Matrix<unsigned short> *usBlu, int iImage );
      
protected:
   void closeEvent(QCloseEvent *eve);

   void initializeGL( void );
   void paintGL( void );

   void keyPressEvent( QKeyEvent *eve );
   void mousePressEvent( QMouseEvent *eve );
   void mouseReleaseEvent( QMouseEvent *eve );
   void mouseMoveEvent( QMouseEvent *eve );
   void wheelEvent ( QWheelEvent *eve  ); 
   void resizeEvent( QResizeEvent* );
   
};
