#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "scope_common.h"
#include "scope_panes.h"
#include "scope_monitor.h"
#include "scope_window.h"

bool ScopePane::InitializeOpenGL( void ) 
{  
   bool bRetCode = false; 
   int nTexSize, nWidth, nHeight;
   float fLineRange[2];
   QSize rect;

   // --- get dimension ---
   
   rect = size( );
   nWidth = (int)rect.width( );
   nHeight = (int)rect.height( ); 		
				
	// *** DO NOT Enable GL_DEPTH here as it causes ***
   // unknown error while intializing the OpenGL extension ***

   //glEnable( GL_DEPTH );
	glEnable( GL_TEXTURE_RECTANGLE_ARB );
	glClearColor( 0.0f, 0.0f, 0.0f, 1.0f );

	glViewport( 0, 0, nWidth, nHeight );		
												
	glMatrixMode( GL_PROJECTION );		
	glLoadIdentity( );				

	glMatrixMode( GL_MODELVIEW );		
	glLoadIdentity( );

   // --- Check if OpenGL version 2.0 or higher? ---

   _bOpenGL2 = OpenGlHigherThanTwo_ITF( );   

   // ---check maximum texture size ---

   glGetIntegerv( GL_MAX_TEXTURE_SIZE, &nTexSize );

   // set line symbl size
   glGetFloatv( GL_LINE_WIDTH_RANGE, fLineRange );
   _fMinLineWidth = fLineRange[0];
   _fMaxLineWidth = fLineRange[1];   
   _fSelectedLineWidth = min( _fMaxLineWidth, _fMinLineWidth * 4.0f );

   glClearColor( 0.0f, 0.0f, 0.0f, 0.0f ); 
   glClear( GL_COLOR_BUFFER_BIT ); 
	glFlush( );

   // --- Done ---
   bRetCode = true;
//PIX_EXIT:
   return bRetCode;
}

void ScopePane::RefreshSingle(void )
{			   
   scope_window *pMain = (scope_window*)GetMainWindow( );
   short sPaneShowMode = pMain->GetPaneShowMode( );

   makeCurrent( );	

   if( !pMain->ValidPaneDisplayMode( ) ) {
      RefreshClear( );
      goto PIX_EXIT;
   }

   if( pMain->GetImageLoading( ) ) {
      RefreshClear( );
      goto PIX_EXIT;
   }

   switch( _sPaneType ) {
   case ScopePaneSplitLeft:      
   case ScopePaneSplitRight:
      //
      // draw according to the pane show mode
      //
      switch( sPaneShowMode ) {
      case pixq_ScreenPara::ScopePaneShowFirst: 
      case pixq_ScreenPara::ScopePaneShowSecond:
      case pixq_ScreenPara::ScopePaneShowHorizontalSplit:
      case pixq_ScreenPara::ScopePaneShowVerticalSplit:
         RefreshTexture( );
         break;
   
      case pixq_ScreenPara::ScopePaneShowWiper: 
         RefreshWiperDouble( );
         break;
   
      case pixq_ScreenPara::ScopePaneShowInBox:
      case pixq_ScreenPara::ScopePaneShowOutBox:  
         RefreshBoxDouble( );
         break;
   
      case pixq_ScreenPara::ScopePaneShowNone: 
      default:
         RefreshClear( );
         break;
      }
      break;

   case ScopePaneIndex:
      //
      // index
      // draw the first image when images are loaded
      //
      RefreshTexture( );
      break;

   default:
      goto PIX_EXIT;
      break;
   }

   // draw other information

   switch( _sPaneType ) {
   case ScopePaneSplitLeft:      
   case ScopePaneSplitRight:  
      break;

   case ScopePaneIndex:
      DrawIndexArea( );   
      break;

   default:
      break;
   }

   // --- done ---
PIX_EXIT:
   swapBuffers( );
   return;
}

//
// scope-stype view, two textures
//
void ScopePane::RefreshBoxDouble( void )
{
   unsigned int uiImgTexture[2];
   scope_window *pMain = (scope_window*)GetMainWindow( );
   short sPaneShowMode = pMain->GetPaneShowMode( );
   const pixq_ScreenPara *pScreen = pMain->GetScreenPara( );
   bool bInputInBox; 

   // check mode

   switch( sPaneShowMode ) {
   case pixq_ScreenPara::ScopePaneShowInBox:
      bInputInBox = true;
      break;

   case pixq_ScreenPara::ScopePaneShowOutBox: 
      bInputInBox = false;
      break;

   default:
      goto PIX_EXIT;
      break;
   }

   uiImgTexture[0] = GetColorModeTexture( 0 ); 
   uiImgTexture[1] = GetColorModeTexture( 1 ); 

   RefreshScope_WON( uiImgTexture[0], uiImgTexture[1], bInputInBox, 
      _nBoxCenterX, _nBoxCenterY, _nBoxRadius, pScreen );

   // --- Done ---
PIX_EXIT:
   return;
}

//
// set /reset the flag to indicate that the texture is already created
//
void ScopePane::SetColorModeTexture( int iImage, // [i] source or derived image
                                    bool bSet ) // [i] set to true(loaded) or false
{
   short sDisplayColor = _sDisplayColor;

   switch( sDisplayColor ) {
   case PixImageDisplayColorRgb:
      _PaneTexture.SetRgbTexture( iImage, bSet );
      break;

	case PixImageDisplayColorRed: 
      _PaneTexture.SetRedTexture( iImage, bSet );
      break;

	case PixImageDisplayColorGreen:
      _PaneTexture.SetGreenTexture( iImage, bSet );
      break;

   case PixImageDisplayColorBlue:
      _PaneTexture.SetBlueTexture( iImage, bSet );
      break;

   case PixImageDisplayColorPseudoRed:
      _PaneTexture.SetRedPseudoTexture( iImage, bSet );
      break;

   case PixImageDisplayColorPseudoGreen:
      _PaneTexture.SetGreenPseudoTexture( iImage, bSet );
      break;

   case PixImageDisplayColorPseudoBlue:
      _PaneTexture.SetBluePseudoTexture( iImage, bSet );
      break;
   }

   return;
}

unsigned int ScopePane::GetColorModeTexture( void )
{
   unsigned int uiImgTexture;
   scope_window *pMain = (scope_window*)GetMainWindow( );
   short sPaneShowMode = pMain->GetPaneShowMode( );

   switch( _sPaneType ) {

   case ScopePaneSplitLeft:
      switch( sPaneShowMode ) {
      case pixq_ScreenPara::ScopePaneShowFirst:
      case pixq_ScreenPara::ScopePaneShowHorizontalSplit:
      case pixq_ScreenPara::ScopePaneShowVerticalSplit:
         uiImgTexture = GetColorModeTexture( 0 ); 
         break;

      case pixq_ScreenPara::ScopePaneShowSecond:
      default:
         uiImgTexture = GetColorModeTexture( 1 ); 
         break;
      }
      break;

   case ScopePaneSplitRight:
      uiImgTexture = GetColorModeTexture( 1 ); 
      break;

   case ScopePaneIndex:  
      uiImgTexture = GetColorModeTexture( 0 ); 
      goto PIX_EXIT;
      break;

   default:
      break;
   }

PIX_EXIT:
   return uiImgTexture;
}

//
// get the textue id according to the display color mode
//
unsigned int ScopePane::GetColorModeTexture( int iImage ) // [i] source or derived image
{
   unsigned int uiTexture;
   short sDisplayColor = _sDisplayColor;

   switch( sDisplayColor ) {
   case PixImageDisplayColorRgb:
      uiTexture = _PaneTexture.GetRgbTexture( iImage );
      break;

	case PixImageDisplayColorRed: 
      uiTexture = _PaneTexture.GetRedTexture( iImage );
      break;

	case PixImageDisplayColorGreen:
      uiTexture = _PaneTexture.GetGrnTexture( iImage );
      break;

   case PixImageDisplayColorBlue:
      uiTexture = _PaneTexture.GetBluTexture( iImage );
      break;

   case PixImageDisplayColorPseudoRed:
      uiTexture = _PaneTexture.GetRedPseudoTexture( iImage );
      break;

   case PixImageDisplayColorPseudoGreen:
      uiTexture = _PaneTexture.GetGrnPseudoTexture( iImage );
      break;

   case PixImageDisplayColorPseudoBlue:
      uiTexture = _PaneTexture.GetBluPseudoTexture( iImage );
      break;
   }

   return uiTexture;
}



void ScopePane::DrawIndexArea( void )
{
   scope_window *pMain = (scope_window*)GetMainWindow( );
   short sPaneShowMode = pMain->GetPaneShowMode( );
   const pixq_ScreenPara *pScreen = pMain->GetScreenPara( );
   const pixq_FlipPara *pFlip = pMain->GetIndexPara( ); 
 
   //
   // need to fix this for vertical/horizontal split!
   //

   const pixq_PanePara *pIndexFlip; 
#ifdef _DEBUG
   const pixq_PanePara *pCenterFlip; 
#endif

   double dScreenX0, dScreenX1, dScreenY0, dScreenY1;
   double dTexX0, dTexX1, dTexY0, dTexY1;

   switch( sPaneShowMode ) {
   case pixq_ScreenPara::ScopePaneShowFirst: 
   case pixq_ScreenPara::ScopePaneShowSecond:
   case pixq_ScreenPara::ScopePaneShowWiper: 
   case pixq_ScreenPara::ScopePaneShowInBox:
   case pixq_ScreenPara::ScopePaneShowOutBox: 
      pIndexFlip = pScreen->GetSingleFlip( );
      break;
   
   case pixq_ScreenPara::ScopePaneShowHorizontalSplit:
      pIndexFlip = pScreen->GetLeftFlip( );
      break;

   case pixq_ScreenPara::ScopePaneShowVerticalSplit:
      pIndexFlip = pScreen->GetUpperFlip( );
      break;
   
   case pixq_ScreenPara::ScopePaneShowNone: 
   default:
      goto PIX_EXIT;
      break;
   }

   // *** draw source area on index ***

   glDisable( GL_TEXTURE_RECTANGLE_ARB );
   glDisable( GL_LIGHTING ); // to show lines in color
   glDisable( GL_LIGHT0 );
   glEnable( GL_DEPTH_TEST );

   glLineWidth( _fMinLineWidth );  
   glColor3f( 1.0f, 1.0f, 0.0f );

   dTexX0 = pIndexFlip->GetTexCooX( 0 );
   dTexX1 = pIndexFlip->GetTexCooX( 1 );
   dTexY0 = pIndexFlip->GetTexCooY( 0 );
   dTexY1 = pIndexFlip->GetTexCooY( 1 );
   
   pFlip->TexToScreenCoo( dTexX0, dTexY0, &dScreenX0, &dScreenY0 );
   pFlip->TexToScreenCoo( dTexX1, dTexY1, &dScreenX1, &dScreenY1 );
   glBegin( GL_LINE_STRIP );
      glVertex3d( dScreenX0, dScreenY0, 0.1 );
      glVertex3d( dScreenX1, dScreenY0, 0.1 );
      glVertex3d( dScreenX1, dScreenY1, 0.1 );
      glVertex3d( dScreenX0, dScreenY1, 0.1 );
      glVertex3d( dScreenX0, dScreenY0, 0.1 );
   glEnd( );    
   
   // single flip
   
#ifdef _DEBUG
   pCenterFlip = pScreen->GetSingleFlip( ); 
   glLineWidth( 2.0f * _fMinLineWidth );  
   glColor3f( 0.0f, 0.0f, 1.0f );
   
   dTexX0 = pCenterFlip->GetTexCooX( 0 );
   dTexX1 = pCenterFlip->GetTexCooX( 1 );
   dTexY0 = pCenterFlip->GetTexCooY( 0 );
   dTexY1 = pCenterFlip->GetTexCooY( 1 );
   
   pFlip->TexToScreenCoo( dTexX0, dTexY0, &dScreenX0, &dScreenY0 );
   pFlip->TexToScreenCoo( dTexX1, dTexY1, &dScreenX1, &dScreenY1 );
   glBegin( GL_LINE_STRIP );
      glVertex3d( dScreenX0, dScreenY0, 0.1 );
      glVertex3d( dScreenX1, dScreenY0, 0.1 );
      glVertex3d( dScreenX1, dScreenY1, 0.1 );
      glVertex3d( dScreenX0, dScreenY1, 0.1 );
      glVertex3d( dScreenX0, dScreenY0, 0.1 );
   glEnd( );    
#endif

   // --- done ---
PIX_EXIT:
   return;
}


//
// dispklay single(first or second texture) on the pane
//
void ScopePane::RefreshTexture( void )
{
   scope_window *pMain = (scope_window*)GetMainWindow( );
   short sPaneShowMode = pMain->GetPaneShowMode( );
   const pixq_ScreenPara *pScreen = pMain->GetScreenPara( );
   const pixq_FlipPara *pFlip = pMain->GetIndexPara( ); 

	unsigned int uiImgTexture; 
   
   if( !pMain->ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   uiImgTexture = GetColorModeTexture( );   
   switch( _sPaneType ) {
   case ScopePaneSplitLeft:      
   case ScopePaneSplitRight:
      RefreshTexture_WON( uiImgTexture, _sPaneType, sPaneShowMode, pScreen );
      break;

   case ScopePaneIndex:
      RefreshTexture_WON( uiImgTexture, pFlip );
      break;

   default:
      break;
   }

   // --- DONE ---
PIX_EXIT:

   return;
}

//
// wiper-stype line, two textures
//
void ScopePane::RefreshWiperDouble( void )
{
   unsigned int uiImgTexture[2];		   
   scope_window *pMain = (scope_window*)GetMainWindow( );
   short sPaneShowMode = pMain->GetPaneShowMode( );
   const pixq_ScreenPara *pScreen = pMain->GetScreenPara( );
   
   if( !pMain->ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   switch( sPaneShowMode ) {
   case pixq_ScreenPara::ScopePaneShowWiper: 
      break;

   default:
      goto PIX_EXIT;
      break;
   }

   // 

   uiImgTexture[0] = GetColorModeTexture( 0 ); 
   uiImgTexture[1] = GetColorModeTexture( 1 ); 

   RefreshWiper_WON( uiImgTexture[0], uiImgTexture[1], _bWiperVertical,
      _nWiperX, _nWiperY, pScreen );

   // --- Done ---
PIX_EXIT:
   return;
}

void ScopePane::RefreshClear( void ) 
{
   float fRedValue, fGrnValue, fBluValue;

   glDisable( GL_CULL_FACE );
   glDisable( GL_LIGHTING );
   glDisable( GL_LIGHT0 );

   glDisable( GL_DEPTH_TEST ); 
   glDisable( GL_DEPTH );
   glDisable( GL_TEXTURE_RECTANGLE_ARB );

   glMatrixMode( GL_PROJECTION );
   glLoadIdentity( );

   glMatrixMode( GL_MODELVIEW );
   glLoadIdentity( );

   // clear the screen

   switch( _sPaneType ) {
   case ScopePaneSplitLeft: 
   case ScopePaneSplitRight: 
      fRedValue = 0.480f;
      fGrnValue = 0.480f;
      fBluValue = 0.480f;
      glColor4f( fRedValue, fGrnValue, fBluValue, 1.0f );
      glClearColor( fRedValue, fGrnValue, fBluValue, 1.0f );
      break;
      
   case ScopePaneIndex:
      fRedValue = 0.280f;
      fGrnValue = 0.280f;
      fBluValue = 0.280f;
      glColor4f( fRedValue, fGrnValue, fBluValue, 1.0f );
      glClearColor( fRedValue, fGrnValue, fBluValue, 1.0f );
      break;
      
   default:
      fRedValue = 0.80f;
      fGrnValue = 0.80f;
      fBluValue = 0.80f;
      glColor4f( fRedValue, fGrnValue, fBluValue, 1.0f );
      glClearColor( fRedValue, fGrnValue, fBluValue, 1.0f );
      break;
   }
   
   glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
	glFlush( ); 
			
   return;
}
