#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "scope_common.h"
#include "scope_panes.h"
#include "scope_monitor.h"
#include "scope_window.h"

void ScopePane::Init( short sSide )
{
   _sPaneType = sSide;

   setBackgroundRole( QPalette::Base );
   setSizePolicy( QSizePolicy::Ignored, QSizePolicy::Ignored );

   setMinimumSize( 50, 50 );

   setFocusPolicy( Qt::StrongFocus );
   setMouseTracking( true );

   _PaneTexture.Init( );

   _bMouseDragging = false;

   ResetPane( );

   //
   // pane parameters
   //

   InitializeOpenGL( );

   return;
}

void ScopePane::DeInit( void )
{   
   ResetPane( );
}

void ScopePane::ResetPane( void )
{   
   makeCurrent( );

   _PaneTexture.Delete( ); 

   _sDisplayColor = PixImageDisplayColorRgb;

   // --- DOne ---
   return;
}

//
// initialize wiper positon to the center of the pane
//
void ScopePane::InitWiperPos( void )
{
   QSize rect = size( );

   _bWiperVertical = true;
   _nWiperX = rect.width( ) / 2; 
   _nWiperY = rect.height( ) / 2;

   // box radius on viewport unit
   _nBoxRadius = 100; 
   _nBoxCenterX = rect.width( ) / 2; 
   _nBoxCenterY = rect.height( ) / 2;

   return;
}

void ScopePane::SetCurrentViewport( void )
{
   QSize rect = size( );
   
   glClearColor( 0.0, 0.0, 0.0, 1.0 );
	//glViewport( rect.left, rect.top, rect.right, rect.bottom );
	glViewport( 0, 0, rect.width( ), rect.height( ) );

   return;
}

void ScopePane::ChangeScreenSize(void)
{
   scope_window *pMain = (scope_window*)GetMainWindow( );
   pixq_ScreenPara *pScreen = pMain->GetScreenPara( );
   pixq_FlipPara *pIndex = pMain->GetIndexPara( );  
   QSize rect = size( );

   if( !pMain->ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   if( pScreen->IsLocked( ) ) {
      goto PIX_EXIT;
   }

   // --- initialize texture copy parameters ---
   // --- initialize view point parameters ---   
  
   SetCurrentViewport( );
   
   // --- set current screen size ---

	switch( _sPaneType ) {
   case ScopePane::ScopePaneSplitLeft: 
   case ScopePane::ScopePaneSplitRight: 
      pScreen->ResizeWindow( rect );
      break;

   case ScopePane::ScopePaneIndex:
      pIndex->ResizeWindow( rect );
		break;

   case ScopePane::ScopePaneUnknown:
   default:
      goto PIX_EXIT;
      break;
   }

   RefreshSingle( );

PIX_EXIT:
   return;
}


//
// create opengl texture from rgb matrix
//
// notes:
// 
bool ScopePane::CreateImageTexture( pixq_Matrix<unsigned short> *usRed, // [i] image data in matrix
                                    pixq_Matrix<unsigned short> *usGrn, // [i] image data in matrix
                                    pixq_Matrix<unsigned short> *usBlu, // [i] image data in matrix
                                    int iImage ) // [i] 0 or 1
{
	bool bRetCode = false;
   bool bTexBuffer;
   scope_window *pMain = (scope_window*)GetMainWindow( );
   pixq_TextureBuffer *pTexBuffer = pMain->GetTextureBuffer( ); 
   pixq_Properties *pEnv = pMain->GetEnv( ); 

   int iTexPara, iTexFilter;
   short sDisplayColor;
   unsigned int uiTexture;

   int nWidth = usRed->GetWidth( );
   int nHeight = usRed->GetHeight( );
   int nColors = 4; 
   short sType = pixq_TextureBuffer::BufferVariableUnsignedShortType;

#ifdef _DEBUG
unsigned short usMin[3], usMax[3], usMean[3];
#endif // _DEBUG

   // get the current mag filter

   iTexFilter = pEnv->_ImageTextureFilter.iGet( );
   if( pixq_Properties::TextureFilterNearest == iTexFilter ) {
      iTexPara = GL_NEAREST;
   } else {
      iTexPara = GL_LINEAR;
   }

   // --- flop texture ---	

   makeCurrent( ); 

	glEnable( GL_TEXTURE_RECTANGLE_ARB );
   

   // bind the texture

   uiTexture = GetColorModeTexture( iImage );
   glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiTexture );      
   
   // !!! THIS HAS TO BE DONE AFTER glBindTexture !!!
	glTexParameteri( GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_S, GL_CLAMP );
	glTexParameteri( GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_T, GL_CLAMP );
	glTexParameteri( GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MAG_FILTER, iTexPara );
	glTexParameteri( GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MIN_FILTER, iTexPara );
	glTexEnvi( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL );

   // allocate/check working buffer to create texture

   bTexBuffer = pTexBuffer->CheckAlloc( nWidth, nHeight, nColors, sType );
   
   // opengl 2.X -> create texture with any size!
   
   sDisplayColor = _sDisplayColor;

#ifdef _DEBUG
usRed->Statistics( &usMin[0], &usMax[0], &usMean[0], true );
usGrn->Statistics( &usMin[1], &usMax[1], &usMean[1], true );
usBlu->Statistics( &usMin[2], &usMax[2], &usMean[2], true );
#endif // _DEBUG

   if( !CreateFreeTexture_ITF( usRed, usGrn, usBlu, pTexBuffer, sDisplayColor ) ) {
      SetColorModeTexture( iImage, false ); 
      goto PIX_EXIT; 
   }
  
   // set the texture flag

   SetColorModeTexture( iImage, true ); 

   // --- Done ---
   bRetCode = true;
PIX_EXIT:   
   return bRetCode;
}

void ScopePane::InitTexture( void )
{  
   _PaneTexture.InitTexture( ); 
   
   return;
}

void ScopePane::SetModeCursor( void )
{
   // TODO: Add your message handler code here and/or call default

   scope_window *pMain = (scope_window*)GetMainWindow( );
   short sLeftMode = pMain->sGetLeftMouseMode( );

   if( _bMouseDragging ) {
      setCursor( Qt::ClosedHandCursor );
      goto PIX_EXIT;
   }

   switch( sLeftMode ) {
   case scope_window::MouseLeftClickNone: 
   default:
      setCursor( Qt::ArrowCursor );
      break;
   }

PIX_EXIT:
   //QApplication::processEvents( );
   return;
}

//
// mouse button pressed
//
void ScopePane::SwitchPaneMode( void )
{
   scope_window *pMain = (scope_window*)GetMainWindow( );
   short sPaneShowMode = pMain->GetPaneShowMode( );
   bool bConsumed = false;

   // switch viewing method according to the mode

   switch( sPaneShowMode ) {
   
   case pixq_ScreenPara::ScopePaneShowFirst:  
      // toggle first/second image
      pMain->SetPanesShowMode( (short)pixq_ScreenPara::ScopePaneShowSecond );
      bConsumed = true;
      break;

   case pixq_ScreenPara::ScopePaneShowSecond: 
      // toggle first/second image
      pMain->SetPanesShowMode( (short)pixq_ScreenPara::ScopePaneShowFirst ); 
      bConsumed = true;
      break;

   case pixq_ScreenPara::ScopePaneShowWiper: 
      _bWiperVertical = !_bWiperVertical;
      RefreshSingle( );
      bConsumed = true;
      break;

   case pixq_ScreenPara::ScopePaneShowInBox:
      pMain->SetPanesShowMode( pixq_ScreenPara::ScopePaneShowOutBox );       
      bConsumed = true;
      break;

   case pixq_ScreenPara::ScopePaneShowOutBox:  
      pMain->SetPanesShowMode( pixq_ScreenPara::ScopePaneShowInBox );
      bConsumed = true;
      break;

   case pixq_ScreenPara::ScopePaneShowHorizontalSplit:
      //pMain->SetPanesShowMode( pixq_ScreenPara::ScopePaneShowVerticalSplit );      
      //bConsumed = true;
      break;

   case pixq_ScreenPara::ScopePaneShowVerticalSplit:
      //pMain->SetPanesShowMode( pixq_ScreenPara::ScopePaneShowHorizontalSplit );
      //bConsumed = true;
      break;

   default:
      break;
   }

//PIX_EXIT:
   return;
}
