#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "scope_common.h"
#include "scope_panes.h"
#include "scope_window.h"
#include "scope_monitor.h"
#include "ui_scope_window.h"

QString scope_window::_strOrganisation = "PixTOPO";
QString scope_window::_strApplication = "QtScope";

scope_window::scope_window(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::scope_window)
{
   int k;

    ui->setupUi(this);

   _bInitialized = false;
   SetImageLoading( false );

   // init all widgets

   _ImageSplitter = (ImageSplitter*)NULL;

   for( k = 0 ; k < 2 ; k++ ) {
      _Image_Pane[k] = (ScopePane*)NULL; 
   }
   
   _Index_Pane = (ScopePane*)NULL; 
   _Chart_Pane = (ChartPane*)NULL;

   // init all data

   for( k = 0 ; k < 2 ; k++ ) {
      _pImgTexture[k]  = (pixq_DepthTexture*)NULL;
   }

   _pDepthEnv = (pixq_Properties*)NULL;
   _MainTexBuffer = (pixq_TextureBuffer*)NULL;
   _pImageDataSet = (pixq_ImageDualSet*)NULL;

	_pScreenPara = (pixq_ScreenPara*)NULL;
   _IndexPara = (pixq_FlipPara*)NULL; 

   // create window

   CreateMain( );

#ifdef _DEBUG
   ui->action_file_select_two_sequences->setVisible( true );
#else
   ui->action_file_select_two_sequences->setVisible( false );
#endif

   // create status bar

   for( k = 0 ; k < 4 ; k++ ) {
      _statusLabel[k] = new QLabel( "Scope", this );
      _statusLabel[k]->setFrameStyle( QFrame::Sunken );
   }
   _statusProgress = new QProgressBar( this );
   _statusProgress->setFormat( "%v" );

   statusBar()->addPermanentWidget( _statusLabel[0], 3 );
   statusBar()->addPermanentWidget( _statusLabel[1], 3 );
   statusBar()->addPermanentWidget( _statusLabel[2], 3 );
   statusBar()->addPermanentWidget( _statusLabel[3], 1 );
   statusBar()->addPermanentWidget( _statusProgress, 2 );

   // *** initialize all data ***

   InitData( );

   _Image_Pane[0]->Init( ScopePane::ScopePaneSplitLeft ); 
   _Image_Pane[1]->Init( ScopePane::ScopePaneSplitRight ); 
   _Index_Pane->Init( ScopePane::ScopePaneIndex );
   _Chart_Pane->Init( ); 

   // report about opengl version

   OpenGlHigherThanTwo( );

   //   

   return;
}

scope_window::~scope_window()
{
   delete ui;
}

void scope_window::closeEvent( QCloseEvent * /*eve*/ )
{
   StoreWindowPosition( );

   return;
}

void scope_window::resizeEvent( QResizeEvent * /*eve*/ )
{
   if( !_bInitialized ) {
      goto PIX_EXIT;
   }

 // fixScopePanes(  );

PIX_EXIT:
   return;
}

void scope_window::paintEvent( QPaintEvent * /*eve*/ )
{
   if( !_bInitialized ) {
      goto PIX_EXIT;
   }

   RefreshPanes( );

PIX_EXIT:
   return;
}

void scope_window::showEvent( QShowEvent * /*eve*/ )
{
   if( _bInitialized ) {
      goto PIX_EXIT;
   }

   RestoreWindowPosition( );
   
   SetPanesShowMode( pixq_ScreenPara::ScopePaneShowNone );
   RefreshPanes( );
   
   _bInitialized = true;

PIX_EXIT:
   return;
}

//
// *** Menu - File ***
//

void scope_window::on_action_file_select_image_pair_triggered()
{
   if( !SelectImagePair( ) ) {
      goto PIX_EXIT;
   }

PIX_EXIT:
   return;
}

void scope_window::on_action_file_select_two_sequences_triggered()
{
   if( !SelectDualSequence( ) ) {
      goto PIX_EXIT;
   }

PIX_EXIT:
   return;
}

void scope_window::on_action_file_properties_triggered()
{
   if( !SetProperties( ) ) {
      goto PIX_EXIT;
   }

PIX_EXIT:
    return;
}


void scope_window::on_action_file_list_supported_formats_triggered()
{
   //
   // list of supported image formats
   //

   int i, nFormats;
   QStringList strFormats;
   QString strMessage;
   ScopeMonitor *pMonitor = (ScopeMonitor*)GetMonitorPane( );

   ListSupportedFormat_ITF( &strFormats );
   
   nFormats = (int)strFormats.size();
   for( i = 0 ; i < nFormats ; i++ ) {
      strMessage.sprintf( "%03d/%03d: ", i+1, nFormats );
      strMessage = strMessage + strFormats.at( i );
      pMonitor->DisplayMessage( strMessage );
   }

   return;
}

void scope_window::on_action_file_exit_triggered()
{
   close( );
}


////////////////////////////////////////////////////////////////////////
// *** Menu - Data ***
////////////////////////////////////////////////////////////////////////

void scope_window::on_action_data_statistics_triggered()
{
   if( !GetStatistics( ) ) {  
      goto PIX_EXIT;
   }

PIX_EXIT:
   return;
}

void scope_window::on_action_data_hide_histogram_triggered()
{
   _Dock_Chart->hide( );
}

void scope_window::on_action_data_show_histogram_triggered()
{
   _Dock_Chart->show( );
}

//
// *** Menu - View ***
//

void scope_window::on_action_view_first_image_triggered()
{
   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   SetPanesShowMode( pixq_ScreenPara::ScopePaneShowFirst ); 

PIX_EXIT:
   return;
}

void scope_window::on_action_view_second_image_triggered()
{
   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   SetPanesShowMode( pixq_ScreenPara::ScopePaneShowSecond );

PIX_EXIT:
   return;
}

void scope_window::on_action_view_wiper_triggered()
{
   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   SetPanesShowMode( pixq_ScreenPara::ScopePaneShowWiper );

PIX_EXIT:
   return;
}

void scope_window::on_action_view_input_in_scope_triggered()
{
   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   SetPanesShowMode( pixq_ScreenPara::ScopePaneShowInBox );

PIX_EXIT:
   return;
}

void scope_window::on_action_view_output_in_scope_triggered()
{
   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   SetPanesShowMode( pixq_ScreenPara::ScopePaneShowOutBox ); 

PIX_EXIT:
   return;
}


void scope_window::on_action_view_split_vertically_triggered()
{
   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   SetPanesShowMode( pixq_ScreenPara::ScopePaneShowVerticalSplit );


PIX_EXIT:
   return;
}

void scope_window::on_action_view_split_horizontally_triggered()
{
   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   SetPanesShowMode( pixq_ScreenPara::ScopePaneShowHorizontalSplit );

PIX_EXIT:
   return;
}


void scope_window::on_action_view_rgb_triggered()
{
   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   SetDisplayColor( PixImageDisplayColorRgb );

   if( !CreateLoadedTexture( ) ) {
      goto PIX_EXIT;
   }

   RefreshPanes( );
   SetMenuState( );

PIX_EXIT:
   return;
}

void scope_window::on_action_view_red_channel_triggered()
{
   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   SetDisplayColor( PixImageDisplayColorRed );

   if( !CreateLoadedTexture( ) ) {
      goto PIX_EXIT;
   }

   RefreshPanes( );
   SetMenuState( );

PIX_EXIT:
   return;
}

void scope_window::on_action_view_green_channel_triggered()
{
   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   SetDisplayColor( PixImageDisplayColorGreen );

   if( !CreateLoadedTexture( ) ) {
      goto PIX_EXIT;
   }

   RefreshPanes( );
   SetMenuState( );

PIX_EXIT:
   return;
}

void scope_window::on_action_view_blue_channel_triggered()
{
   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   SetDisplayColor( PixImageDisplayColorBlue );

   if( !CreateLoadedTexture( ) ) {
      goto PIX_EXIT;
   }

   RefreshPanes( );
   SetMenuState( );

PIX_EXIT:
   return;
}

//
// *** Menu - Zoom ***
//

void scope_window::on_action_zoom_real_size_triggered()
{
   short sPane = ScopePane::ScopePaneSplitLeft; 
   int iKey = Qt::Key_Home;

   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   ProcessKeyEvent( sPane, iKey );

PIX_EXIT:
   return;
}

void scope_window::on_action_zoom_recneter_triggered()
{
   short sPane = ScopePane::ScopePaneSplitLeft; 
   int iKey = Qt::Key_5;

   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   ProcessKeyEvent( sPane, iKey );

PIX_EXIT:
   return;
}

void scope_window::on_action_zoom_zoom_up_triggered()
{
   short sPane = ScopePane::ScopePaneSplitLeft; 
   int iKey = Qt::Key_Plus;

   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   ProcessKeyEvent( sPane, iKey );

PIX_EXIT:
   return;
}

void scope_window::on_action_zoom_zoom_down_triggered()
{
   short sPane = ScopePane::ScopePaneSplitLeft; 
   int iKey = Qt::Key_Minus;

   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   ProcessKeyEvent( sPane, iKey );

PIX_EXIT:
   return;
}

void scope_window::on_action_zoom_scroll_up_triggered()
{
   short sPane = ScopePane::ScopePaneSplitLeft; 
   int iKey = Qt::Key_8;

   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   ProcessKeyEvent( sPane, iKey );

PIX_EXIT:
   return;
}

void scope_window::on_action_zoom_scroll_down_triggered()
{
   short sPane = ScopePane::ScopePaneSplitLeft; 
   int iKey = Qt::Key_2;

   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   ProcessKeyEvent( sPane, iKey );

PIX_EXIT:
   return;
}

void scope_window::on_action_zoom_scroll_left_triggered()
{
   short sPane = ScopePane::ScopePaneSplitLeft; 
   int iKey = Qt::Key_4;

   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   ProcessKeyEvent( sPane, iKey );

PIX_EXIT:
   return;
}

void scope_window::on_action_zoom_scroll_right_triggered()
{
   short sPane = ScopePane::ScopePaneSplitLeft; 
   int iKey = Qt::Key_6;

   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   ProcessKeyEvent( sPane, iKey );

PIX_EXIT:
   return;
}


//
// *** Menu - Frame ***
//

void scope_window::on_action_frame_next_triggered()
{
   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   ShiftFrame( 1 );
   
PIX_EXIT:
   return;
}

void scope_window::on_action_frame_reload_triggered()
{
   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }
   
   if( !ReloadFrame( ) ) {
      goto PIX_EXIT;
   }

PIX_EXIT:
   return;
}

//
// *** Menu - Help ***
//

void scope_window::on_action_help_about_triggered()
{
   pixq_Version ver = Version( );
   ShowPixAbout_PC( &ver );

   return;
}
