#pragma once

#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

namespace Ui {
   class scope_window;
}

class ScopePane;
class ChartPane;

class ImageCtrl;
class ScopeMonitor;
class ImageSplitter;
class ScopeSplitter;

class image_side_label;
class scope_dock;

class scope_window : public QMainWindow
{
   Q_OBJECT

public:
   // left mouse working mode
   enum {
      // do nothing
      MouseLeftClickNone = 0, 
   } MouseLeftClickWorkMode;


   // *** DO NOT CHANGE THESE NUMBERS ***
   // Menu Action Stratus Mode
   // This is encedded to QAction Items
   enum {
      // always enabled
      MouseActionItemEnabled = 0, 
      // enabled only when double sequences ares loaded
      MouseActionItemDouble = 2, 
      // always disnabled
      MouseActionItemDisabled = 4, 
   } MouseActionSelectionMode;

public:
    explicit scope_window(QWidget *parent = 0);
    ~scope_window();

private:
    Ui::scope_window *ui;

public:
   void AddMenuAction( QAction *pAction, int iSelectMode );

   void CreateMain( void );
   
   void CreateActions( void );
   void CreateToolBars( void );

   void SetImageSplitterWidth( void );

public slots:
    void ImageSplitterMoved( int pos, int index  );

private:
   //
   // *** GUI ***
   //

   ImageSplitter *_ImageSplitter;

   // opengl screen

   ScopePane *_Image_Pane[2];  

   // status bar
   QLabel *_statusLabel[4];
   QProgressBar  *_statusProgress;
   
   // actions list

   QList<QAction*> _list_menu_actions;

   // index image

   ScopePane *_Index_Pane; 
   ChartPane *_Chart_Pane;
   ScopeMonitor *_Scope_Monitor;

   // parameters and data in 3D depth simulator
    
   scope_dock *_Dock_Index; 
   scope_dock *_Dock_Chart;
   scope_dock *_Dock_Monitor;
      
   // setting
   static QString _strOrganisation;
   static QString _strApplication;

   //
   // *** program ***
   //

   // main windows created?
   bool _bInitialized;

   // left mouse click work mode, one of MouseLeftClickWorkMode;
   short _sLeftMouseMode;

   // how image(s) are displayed on the second(right) pane
   // one of ScopePaneShowMode
   short _sPaneShowMode;

   //
   // files selection
   //

   pixq_ImageDualSet *_pImageDataSet;

   //
   // data
   //
   
   // buffer to transfer matrix data to opengl texture
   pixq_TextureBuffer *_MainTexBuffer;

   // --- OpenGL texture for left and right image ---
   pixq_DepthTexture *_pImgTexture[2];

   // --- geometric parameters of page flipping ---
   
   pixq_ScreenPara *_pScreenPara;
   pixq_FlipPara *_IndexPara; // index panes 

   // --- environment ---
   pixq_Properties *_pDepthEnv;
   
   // *** image statistics data ***
   pixq_FrameImageStat _ImageStat;

   // input image matrix
   pixq_Matrix<unsigned short> _ImageInMtx[2][3];

   // image is currently being loaded
   // set to true, while the image is being loaded/processed 
   // to avoid mouse event on the image pane!
   bool _bImageLoading;

private slots:
   //
   // *** file menu ***
   //

   void on_action_file_select_image_pair_triggered();
   void on_action_file_select_two_sequences_triggered();
   void on_action_file_properties_triggered();
   void on_action_file_list_supported_formats_triggered();

   void on_action_file_exit_triggered();

   //
   // *** Data menu ***
   //

   void on_action_data_statistics_triggered();
   void on_action_data_hide_histogram_triggered();
   void on_action_data_show_histogram_triggered();

   //
   // *** View menu ***
   //

   void on_action_view_first_image_triggered();
   void on_action_view_second_image_triggered();
   void on_action_view_wiper_triggered();
   void on_action_view_input_in_scope_triggered();
   void on_action_view_output_in_scope_triggered();
   void on_action_view_split_vertically_triggered();
   void on_action_view_split_horizontally_triggered();

   void on_action_view_rgb_triggered();
   void on_action_view_red_channel_triggered();
   void on_action_view_green_channel_triggered();
   void on_action_view_blue_channel_triggered();

   //
   // *** Menu - Zoom ***
   //
   
   void on_action_zoom_real_size_triggered();
   void on_action_zoom_recneter_triggered();
   void on_action_zoom_zoom_up_triggered();
   void on_action_zoom_zoom_down_triggered();
   void on_action_zoom_scroll_up_triggered();
   void on_action_zoom_scroll_down_triggered();
   void on_action_zoom_scroll_left_triggered();
   void on_action_zoom_scroll_right_triggered();

   //
   // *** Frame menu ***
   //

   void on_action_frame_next_triggered();
   void on_action_frame_reload_triggered();

   //
   // *** Help menu ***
   //

   void on_action_help_about_triggered();

protected:
   void closeEvent( QCloseEvent *eve );
   void paintEvent ( QPaintEvent *eve ); 
   void showEvent( QShowEvent *eve );
   void resizeEvent( QResizeEvent *eve );

public:
   QString strGetOrganisation( void ) const { return _strOrganisation; }
   QString strGetApplication( void ) const { return _strApplication; }

   void RefreshClear( void );
   void OpenGlHigherThanTwo( void );

   void InitData( void );
   void DeInitData( void );

   void ResetMain( void );

   // how image(s) are displayed on the second(right) pane

   short GetPaneShowMode( void ) { return _sPaneShowMode; }  
   void SetPanesShowMode( short sSecondPaneMode );

   scope_dock *GetDockChart( void ) const { return _Dock_Chart; } 

   // image load mode
      
   void SetFrameStatusBar( void );

   //
   // utility functions
   //
   void RestoreWindowPosition( void );
   void StoreWindowPosition( void );
   void fixScopePanes( int nPanes );

   bool SelectImagePair( void );
   bool SelectDualSequence( void );

   bool SetProperties( void );

   // select new frame, load the image and apply the current image conversion
   bool SelectFrame( void );

   // load double images and copy it to each pane
   bool CreateDoubleBitmap( void );

   // get image file name according to the mode and side
   bool GetSideFile( int iSide, QString *strFile );

   // load image into three(rgb) unsigned short matrices

   bool LoadFrame( const QString strFile,
      pixq_Matrix<unsigned short> *usRed,
      pixq_Matrix<unsigned short> *usGrn,
      pixq_Matrix<unsigned short> *usBlu );

   // create image texture for given pane from given image matrix(0/1/2)
   bool CreateImageTexture( ScopePane *pPane, int iIMage );

   // create texture on the right pane from the derived image matrices
   bool CreateLoadedTexture( void );

   void DisplayMessage( const char *szFormat, ... );
   void DisplayMessage( const QString strMessage );
   void DisplayMessage( const string strMessage );

   // get output image file for the current frame
   bool GetCorrelation( void );
   bool GetStatistics( void );

public:
   void SetImageLoading( bool bLoading ) { _bImageLoading = bLoading; }
   bool GetImageLoading( void ) { return _bImageLoading; }

public:
   void StoreEnv( void );
   void SetMenuState( void );
   void GetColor( int iSide, int iMouseX, int iMouseY );
   bool ValidPaneDisplayMode( void );
 
   ScopeMonitor *GetMonitorPane( void ) { return _Scope_Monitor; }

   bool GetImageFile( int iSide, int iFrame, QString *strFile );

   // get texture ID for the side/frame
   unsigned int GetTexture( int iSide, int iFrame );

   bool ShiftFrame( int iShift );
   bool ReloadFrame( void );

   void SetDisplayColor( short sDisplayColor );
   short GetDisplayColor( void );
   
   void RefreshPanes( void );

   void SetPanesCursor( QCursor cur );

   // handle key input on pane
   bool ProcessKeyEvent( short sPane, int iKey );
   
   bool ProcessWheelEvent( short sPane, int iDelta );
   bool ProcessScrollEvent( short sPane, int iX, int iY );

   pixq_FrameImageStat *GetImageStat( void ) { return &_ImageStat; }  

   // *** data ***

   pixq_Properties *GetEnv( void ) { return _pDepthEnv; }
   pixq_ScreenPara *GetScreenPara( void ) { return _pScreenPara; }
   pixq_FlipPara *GetIndexPara( void ) { return _IndexPara; }  
   
   pixq_ImageDualSet *GetImageData( void ) { return _pImageDataSet; }  

   pixq_TextureBuffer *GetTextureBuffer( void ) { return _MainTexBuffer; }
   
   // mouse mode
   short sGetLeftMouseMode( void ) { return _sLeftMouseMode; }
   void SetLeftMouseMode( short sMode );
   void ResetLeftMouseMode( void );

   void ClearRectificationTags( void );
   
private:
   pixq_Version Version( void ); 
};
