#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "scope_common.h"
#include "scope_panes.h"
#include "scope_monitor.h"

#include "scope_window.h"
#include "ui_scope_window.h"

void scope_window::CreateMain( void )
{
   int k;
   QIcon icon;
   QString strHeader; 

   QMenu *menu = ui->menuControl;

   Qt::DockWidgetAreas areas = Qt::LeftDockWidgetArea | 
      Qt::RightDockWidgetArea | 
      Qt::TopDockWidgetArea | 
      Qt::BottomDockWidgetArea;

   menu->addSeparator( );

   // windows

   _ImageSplitter = new ImageSplitter( Qt::Horizontal );

   _ImageSplitter->setOrientation( Qt::Horizontal );
   _ImageSplitter->SetMainWindow( this );

   for( k = 0 ; k < 2 ; k++ ) {
      _Image_Pane[k] = new ScopePane; 
      _Image_Pane[k]->SetMainWindow( this ); 
   }

   _ImageSplitter->insertWidget( 0, _Image_Pane[0] );
   _ImageSplitter->insertWidget( 1, _Image_Pane[1] );
   _ImageSplitter->setChildrenCollapsible( false );

   _ImageSplitter->setCollapsible( 0, false );
   _ImageSplitter->setCollapsible( 1, true );

   setCentralWidget( _ImageSplitter );

   connect( _ImageSplitter, SIGNAL( splitterMoved(int,int)),
      this, SLOT(ImageSplitterMoved(int,int)) );
   
   _Image_Pane[0]->show( );
   _Image_Pane[1]->show( );

   // *** control pane ***

   // index 

   _Dock_Index = new scope_dock( tr("Index Image"), this ); 
   _Dock_Index->SetType( (short)scope_dock::ScopeDockIndex );  
   _Dock_Index->setAllowedAreas( areas );  

   _Index_Pane = new ScopePane;  
   _Index_Pane->SetMainWindow( this );  

    _Dock_Index->setWidget( _Index_Pane ); 
    addDockWidget( Qt::BottomDockWidgetArea, _Dock_Index ); 
    menu->addAction(_Dock_Index->toggleViewAction()); 

    _Dock_Index->setMinimumWidth( 350 );  
    _Dock_Index->setMaximumWidth( 350 ); 
    _Dock_Index->setFloating( false ); 
    _Dock_Index->show( ); 

    // chart pane

   _Dock_Chart = new scope_dock( tr("Statistics"), this );
   _Dock_Chart->SetType( (short)scope_dock::ScopeDockChart );  
   _Dock_Chart->setAllowedAreas( Qt::LeftDockWidgetArea | Qt::RightDockWidgetArea |
       Qt::TopDockWidgetArea | Qt::BottomDockWidgetArea );

   _Chart_Pane = new ChartPane( this );
   _Chart_Pane->SetMainWindow( this );

    _Dock_Chart->setWidget( _Chart_Pane );
    addDockWidget(Qt::BottomDockWidgetArea, _Dock_Chart);
    menu->addAction(_Dock_Chart->toggleViewAction());

   // _Dock_Chart->setMinimumWidth( 350 );  
    //_Dock_Chart->setMaximumWidth( 350 ); 
    _Dock_Chart->setFloating( false );
    _Dock_Chart->show( );

    // monitor

   _Dock_Monitor = new scope_dock( tr("Monitor"), this );
   _Dock_Monitor->SetType( (short)scope_dock::ScopeDockMonitor );  
   _Dock_Monitor->setAllowedAreas( Qt::LeftDockWidgetArea | Qt::RightDockWidgetArea |
       Qt::TopDockWidgetArea | Qt::BottomDockWidgetArea );

   _Scope_Monitor = new ScopeMonitor( this );

    _Dock_Monitor->setWidget( _Scope_Monitor );
    addDockWidget( Qt::BottomDockWidgetArea, _Dock_Monitor);
    menu->addAction(_Dock_Monitor->toggleViewAction());

    _Dock_Monitor->setFloating( false );
    _Dock_Monitor->show( );
 
   // *** create meanu and actions

   _sPaneShowMode = pixq_ScreenPara::ScopePaneShowNone;
   CreateActions( );
   CreateToolBars( );

   // window title bars

   strHeader = _strOrganisation + tr(" - ") + _strApplication;
   setWindowTitle( strHeader );

   //icon = QIcon( ":/images/scan2.png" );
   //icon = QIcon( ":/images/flower.png" );
   //icon = QIcon( ":/images/ramarro_architetto_fran_03r.png" );
   //icon = QIcon( ":/images/ahiru.ico" );
   icon = QIcon( ":/images/6719832621109352972.png" );
   setWindowIcon( icon );

   return;
}

void scope_window::AddMenuAction( QAction *pAction, int iSelectMode )
{
   _list_menu_actions.push_back( pAction );
   pAction->setData( QVariant( iSelectMode ) );

   return;
}


void scope_window::CreateToolBars( void )
{
   // main tool bar

   ui->mainToolBar->addAction( ui->action_file_select_image_pair );
   ui->mainToolBar->addAction( ui->action_file_select_two_sequences );
   ui->mainToolBar->addAction( ui->action_file_properties );

   ui->mainToolBar->addSeparator( );

   // view tool bar

   ui->viewToolBar->addAction( ui->action_view_first_image );
   ui->viewToolBar->addAction( ui->action_view_second_image );
   ui->viewToolBar->addAction( ui->action_view_wiper );
   ui->viewToolBar->addAction( ui->action_view_input_in_scope );
   ui->viewToolBar->addAction( ui->action_view_output_in_scope );
   ui->viewToolBar->addAction( ui->action_view_split_horizontally );
   ui->viewToolBar->addAction( ui->action_view_split_vertically );

   ui->viewToolBar->addSeparator( );

   ui->viewToolBar->addAction( ui->action_view_rgb );
   ui->viewToolBar->addAction( ui->action_view_red_channel );
   ui->viewToolBar->addAction( ui->action_view_green_channel );
   ui->viewToolBar->addAction( ui->action_view_blue_channel );

   return;
}

void scope_window::CreateActions( void )
{
   _list_menu_actions.clear( );

   // *** file menu ***

   AddMenuAction( ui->action_file_select_image_pair, (int)MouseActionItemEnabled );
   AddMenuAction( ui->action_file_select_two_sequences, (int)MouseActionItemEnabled );

   AddMenuAction( ui->action_file_properties, (int)MouseActionItemEnabled );
   AddMenuAction( ui->action_file_list_supported_formats, (int)MouseActionItemEnabled );

   AddMenuAction( ui->action_file_exit, (int)MouseActionItemEnabled );

   // *** Data menu ***
   
   AddMenuAction( ui->action_data_statistics, (int)MouseActionItemDouble );

   AddMenuAction( ui->action_data_show_histogram, (int)MouseActionItemEnabled );
   AddMenuAction( ui->action_data_hide_histogram, (int)MouseActionItemEnabled );

   // *** View menu ***

   AddMenuAction( ui->action_view_first_image, (int)MouseActionItemDouble );
   AddMenuAction( ui->action_view_second_image, (int)MouseActionItemDouble );
   AddMenuAction( ui->action_view_wiper, (int)MouseActionItemDouble );
   AddMenuAction( ui->action_view_input_in_scope, (int)MouseActionItemDouble );
   AddMenuAction( ui->action_view_output_in_scope, (int)MouseActionItemDouble );
   AddMenuAction( ui->action_view_split_vertically, (int)MouseActionItemDouble );
   AddMenuAction( ui->action_view_split_horizontally, (int)MouseActionItemDouble );

   AddMenuAction( ui->action_view_rgb, (int)MouseActionItemDouble );
   AddMenuAction( ui->action_view_red_channel, (int)MouseActionItemDouble );
   AddMenuAction( ui->action_view_green_channel, (int)MouseActionItemDouble );
   AddMenuAction( ui->action_view_blue_channel, (int)MouseActionItemDouble );

   // *** Zoom menu ***

   AddMenuAction( ui->action_zoom_real_size, (int)MouseActionItemDouble );
   AddMenuAction( ui->action_zoom_recneter, (int)MouseActionItemDouble );
   AddMenuAction( ui->action_zoom_zoom_up, (int)MouseActionItemDouble );
   AddMenuAction( ui->action_zoom_zoom_down, (int)MouseActionItemDouble );
   AddMenuAction( ui->action_zoom_scroll_up, (int)MouseActionItemDouble );
   AddMenuAction( ui->action_zoom_scroll_down, (int)MouseActionItemDouble );
   AddMenuAction( ui->action_zoom_scroll_left, (int)MouseActionItemDouble );
   AddMenuAction( ui->action_zoom_scroll_right, (int)MouseActionItemDouble );

   // *** Frame menu ***

   AddMenuAction( ui->action_frame_next, (int)MouseActionItemDouble );
   AddMenuAction( ui->action_frame_reload, (int)MouseActionItemDouble );

   // *** Help menu ***

   AddMenuAction( ui->action_help_about, (int)MouseActionItemEnabled );

   return;
}
