#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "scope_common.h"
#include "scope_panes.h"
#include "scope_monitor.h"
#include "scope_window.h"

//
// get sampled list of pixels values and histogram
//
bool scope_window::GetCorrelation( void ) // [i] if true, get all statistics anyway
{
   bool bRetCode = false;
   int nPitch, nWidth, nHeight;
   
#ifdef _DEBUG
   double dScale[3], dOffset[3], dCorr[3];
#endif // _DEBUG

   ScopeMonitor *pMonitor = (ScopeMonitor*)GetMonitorPane( );
	QString strMessage;

   pixq_Properties *pEnv = GetEnv( );
   pixq_FrameImageStat *pStat = GetImageStat( ); 

QApplication::setOverrideCursor( Qt::BusyCursor );

   // check if the current stat data is up to date(statistics obtained for current frame)
    
   pStat->Init( );

   // get sampling positions

   nWidth = _ImageInMtx[0][0].GetWidth( );
   nHeight = _ImageInMtx[0][0].GetHeight( );   
   nPitch = pEnv->_ImageStatSamplePitch.iGet( );
   if( 0 >= nPitch ) {
      strMessage.sprintf( "ERROR! Image Sampling Pitch is Wrong: %d", nPitch ); 
      pMonitor->DisplayMessage( strMessage );
      goto PIX_EXIT;
   }
   
   if( !pStat->SetSamplePosition( nHeight, nWidth, nPitch ) ) {
      goto PIX_EXIT;
   }

   //
   // single sequence
   // ....compare image 0(input) and 2(derived)
   // dual sequence
   // ....compare image 0(first sequence) and 1(second)

   // *** create sample image list (1d) in m_vsRed, m_vsGrn, m_vsBlu ***
 
   // input first image
   pStat->CreatePixelSample( 0, &_ImageInMtx[0][0], &_ImageInMtx[0][1],
      &_ImageInMtx[0][2] );
   
   // input second image
   pStat->CreatePixelSample( 1, &_ImageInMtx[1][0], &_ImageInMtx[1][1],
      &_ImageInMtx[1][2] );

   // *** get correlation of whole image ***
  
#ifdef _DEBUG
   if( !pStat->GetImageCorrelation( dCorr ) ) {
      strMessage.sprintf( "ERROR! Failed to get Image Statistics/Correlation." );
      pMonitor->DisplayMessage( strMessage );
      goto PIX_EXIT;
   }

   strMessage.sprintf( " - Correlation in Red Channels: %11.5f.", dCorr[0] );
   pMonitor->DisplayMessage( strMessage );
   strMessage.sprintf( " - Correlation in Grn Channels: %11.5f.", dCorr[1] );
   pMonitor->DisplayMessage( strMessage );
   strMessage.sprintf( " - Correlation in Blu Channels: %11.5f.", dCorr[2] );
   pMonitor->DisplayMessage( strMessage );
   
   if( !pStat->GetRegressionPara( dScale, dOffset ) ) {
      strMessage.sprintf( "ERROR! Failed to get Image Statistics/Correlation." );
      pMonitor->DisplayMessage( strMessage );
      goto PIX_EXIT;
   }

   strMessage.sprintf( " - Regressions: Red' = Red * %11.5f + %11.5f.", dScale[0], dOffset[0] );
   pMonitor->DisplayMessage( strMessage );
   strMessage.sprintf( " - Regressions: Grn' = Grn * %11.5f + %11.5f.", dScale[1], dOffset[1] );
   pMonitor->DisplayMessage( strMessage );
   strMessage.sprintf( " - Regressions: Blu' = Blu * %11.5f + %11.5f.", dScale[2], dOffset[2] );
   pMonitor->DisplayMessage( strMessage );
#endif

   // *** make histogram from list ***

   if( !pStat->CreateSampleHistogram( ) ) {
      goto PIX_EXIT;
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
QApplication::restoreOverrideCursor();
   return bRetCode;
}

bool scope_window::GetStatistics( void ) 
{
   bool bRetCode = false;   
   unsigned short usMin[2], usMax[2], usMean[2], usStd[2];
   int iSide, k, nWidth[2], nHeight[2];

   ScopeMonitor *pMonitor = (ScopeMonitor*)GetMonitorPane( );
   QString strMessage;

   strMessage = "**** Image Statistics ****";
   pMonitor->DisplayMessage( strMessage );

   for( iSide = 0 ; iSide < 2 ; iSide++ ) {
      nWidth[iSide] = _ImageInMtx[0][0].GetWidth( );
      nHeight[iSide] = _ImageInMtx[0][0].GetHeight( );
   
      for( k = 0 ; k < 3 ; k++ ) {
         _ImageInMtx[iSide][k].Statistics( &usMin[iSide], &usMax[iSide], &usMean[iSide], &usStd[iSide], true );
         strMessage.sprintf( "**** Channel %1d: Range=%05d-%05d: Avr.=%05d: StDev=%05d", k+1,
            usMin[iSide], usMax[iSide], usMean[iSide], usStd[iSide] );
         pMonitor->DisplayMessage( strMessage );
      }
   }

   strMessage.sprintf( "**** Size: %dW * %dH / %dW * %dH", nWidth[0], nHeight[0], nWidth[1], nHeight[1] );
   pMonitor->DisplayMessage( strMessage );
      
   for( k = 0 ; k < 3 ; k++ ) {
      strMessage.sprintf( "**** Channel %1d: Range=%05d-%05d/%05d-%05d : Avr.=%05d/%05d: StDev=%05d/%05d", k+1,
         usMin[0], usMax[0], usMin[1], usMax[1], usMean[0], usMean[1], usStd[0], usStd[1] );
      pMonitor->DisplayMessage( strMessage );
   }

   // --- Done ---
   bRetCode = true;
//PIX_EXIT:
   return bRetCode;
}

//
// select new frame, load the image and apply the current image conversion
//
bool scope_window::SelectFrame( void )
{ 
   bool bRetCode = false;   
   bool bShowStat;
   pixq_ImageDualSet *pData = GetImageData( );

QApplication::setOverrideCursor( Qt::BusyCursor );
SetImageLoading( true );

   // load input images

   if( !CreateDoubleBitmap( ) )  {
      //QMessageBox::warning( this, _strApplication, "ERROR! Failed to Load Image Files" );
      pData->Init( );
      goto PIX_EXIT;
   }
         
   // show the frame infor

   SetFrameStatusBar( );

   // *** get image statistics and show *** 
   
   //bShowStat = pEnv->_ImageStatActiveFrame.GetBool( );
   bShowStat = true;
   if( bShowStat ) {
      if( GetCorrelation( ) ) {
         if( ChartPane::ChartTypeNone == _Chart_Pane->GetChartType( ) ) {
            _Chart_Pane->SetChartType( ChartPane::ChartTypeRgb0Histogram );
         }
         _Chart_Pane->PlotChart( );
         _Chart_Pane->update( );
      }
   }

   // draw the image

SetImageLoading( false );
   RefreshPanes( );

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
QApplication::restoreOverrideCursor();
SetImageLoading( false );
   return bRetCode;
}
