#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "scope_common.h"
#include "scope_panes.h"
#include "scope_monitor.h"
#include "scope_window.h"

void scope_window::OpenGlHigherThanTwo( void )
{
   ScopeMonitor *pMonitor = (ScopeMonitor*)GetMonitorPane( );
   char szVersion[STANDARD_BUFFER_SIZE];
   char szVendor[STANDARD_BUFFER_SIZE];
   char szExtensions[STANDARD_BUFFER_SIZE], szRenderer[STANDARD_BUFFER_SIZE];
   QString strMessage;

   //
   strncpy( szVendor, (char*)glGetString( GL_VENDOR ), STANDARD_BUFFER_SIZE );
   strncpy( szRenderer, (char*)glGetString( GL_RENDERER ), STANDARD_BUFFER_SIZE );
   strncpy( szVersion, (char*)glGetString( GL_VERSION ), STANDARD_BUFFER_SIZE );
   strncpy( szExtensions, (char*)glGetString( GL_EXTENSIONS ), STANDARD_BUFFER_SIZE );

   strMessage.sprintf( "===> OpenGL Vendor: %s", szVendor );
   pMonitor->DisplayMessage( strMessage );

   strMessage.sprintf( "===> OpenGL Renderer: %s", szRenderer );
   pMonitor->DisplayMessage( strMessage );

   strMessage.sprintf( "===> OpenGL Version: %s", szVersion );
   pMonitor->DisplayMessage( strMessage );

   //strMessage.sprintf( "===> OpenGL Extensions: %s", szExtensions );
   //pMonitor->DisplayMessage( strMessage );

   return;
}

//
// load double images and copy it to each pane
//
bool scope_window::CreateDoubleBitmap( void )
{
   bool bRetCode = false;
   bool bExpand;
	QString strImageFile[2], strFrame, strMessage;
   int k, nWidth, nHeight, nImgXSize[2], nImgYSize[2];
   ScopePane *pPanes[3];

   pixq_ImageDualSet *pData = GetImageData( );
   
   ScopeMonitor *pMonitor = (ScopeMonitor*)GetMonitorPane( );
   QSize rect;
      
   short sPaneMode = GetPaneShowMode( );
   pixq_ScreenPara *pScreen = GetScreenPara( ); 
   pixq_FlipPara *pIndex = GetIndexPara( );  
   
   pScreen->Lock( );

#ifdef _DEBUG
   int i;
   unsigned short usMin[2][3], usMax[2][3], usMean[2][3], usStd[2][3];
#endif

   pPanes[0] = (ScopePane*)_Image_Pane[0];  
   pPanes[1] = (ScopePane*)_Image_Pane[1]; 
   pPanes[2] = (ScopePane*)_Index_Pane; 

   for( k = 0 ; k < 2 ; k++ ) {
      if( !GetSideFile( k, &strImageFile[k] ) ) {
         goto PIX_EXIT; 
      }
   }

   // --- initialize viewport ---
   // --- init image texture ---
   for( k = 0 ; k < 3 ; k++ ) {
      pPanes[k]->SetCurrentViewport( );
      pPanes[k]->InitTexture( );
   }

   // *** load image and change to 3-channel and 8-bit depth ***
   
   for( k = 0 ; k < 2 ; k++ ) {
      
      _ImageInMtx[k][0].Free( ); 
      _ImageInMtx[k][1].Free( ); 
      _ImageInMtx[k][2].Free( ); 

      if( !LoadFrame( strImageFile[k], &_ImageInMtx[k][0], &_ImageInMtx[k][1], &_ImageInMtx[k][2] ) ) {
         strMessage = QString( "Failed to Load Image: " ) +  strImageFile[k];
         QMessageBox::warning( this, _strApplication, strMessage );
         pMonitor->DisplayMessage( strMessage );
         goto PIX_EXIT; 
      }
  
      nImgXSize[k] = _ImageInMtx[k][0].GetWidth( );
      nImgYSize[k] = _ImageInMtx[k][0].GetHeight( );

      strMessage = QString( "Image Loaded: ") + strImageFile[k];
      pMonitor->DisplayMessage( strMessage );
   }

#ifdef _DEBUG
for( k = 0 ; k < 2 ; k++ ) {
   for( i = 0 ; i < 3 ; i++ ) {
      _ImageInMtx[k][i].Statistics( &usMin[k][i], &usMax[k][i], &usMean[k][i], 
         &usStd[k][i], true );
   }
}
#endif // _DEBUG

   // --- set the image size to global ---
     
   nWidth = max( nImgXSize[0], nImgXSize[1] );
   nHeight = max( nImgYSize[0], nImgYSize[1] );

   strFrame = pData->GetFrameString( );
   pMonitor->DisplayMessage( strFrame );

   strMessage.sprintf( "Loaded: Image Dimension [%dW*%dH].", nWidth, nHeight );
   pMonitor->DisplayMessage( strMessage );

   // --- if the size of two images don;t match, set them to the larger one ---

   for( k = 0 ; k < 2 ; k++ ) {
      bExpand = false;
      if( nWidth != nImgXSize[k] ) bExpand = true;
      if( nHeight != nImgYSize[k] ) bExpand = true;
      
      // --- image must be resized here if two image are not same size ---
      if( bExpand ) {
         // change the size of matrix to the nWidth * nHeight
      } 
   }

   if( !CreateLoadedTexture( ) ) {
      pMonitor->DisplayMessage( "ERROR! Failed to Create Loaded Image Texture." );
      goto PIX_EXIT;
   }      

   // index

   if( !CreateImageTexture( pPanes[2], 0 ) ) { 
      pMonitor->DisplayMessage( "ERROR! Failed to Create texture." );
      goto PIX_EXIT;
   }

   // --- initialize texture copy parameters ---

   rect = _Image_Pane[0]->size( );  
   pScreen->SetFlipRatio( sPaneMode, rect ); 
   pScreen->InitFlip( nWidth, nHeight ); 
   pScreen->SetSingleViewports( ); 
   pScreen->SetSingleConversion( ); 

   rect = _Index_Pane->size( );  
   pIndex->SetFlipRatio( rect );  
   pIndex->InitFlip( nWidth, nHeight, nWidth, nHeight );  
   pIndex->SetSingleViewports( rect );  
   pIndex->SetSingleConversion( );  

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
   pScreen->Unlock( );
   return bRetCode;
}

