#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "scope_common.h"
#include "scope_panes.h"
#include "scope_monitor.h"
#include "scope_window.h"
#include "ui_scope_window.h"

void scope_window::SetLeftMouseMode( short sMode )
{
   _sLeftMouseMode = sMode;

   _Image_Pane[0]->SetModeCursor( ); 
   _Image_Pane[1]->SetModeCursor( );    
   _Index_Pane->setCursor( Qt::ArrowCursor );  

   return;
}

void scope_window::ResetLeftMouseMode( void )
{
   SetLeftMouseMode( (short)MouseLeftClickNone ); 

   return;
}

//
// notes:
// this should be only called onece at the start-up!
//
void scope_window::InitData( void )
{
   int k;
  
   ResetLeftMouseMode( );

   // --- env setting --- 

   _pDepthEnv = new pixq_Properties;
   _pDepthEnv->InitEnv( _strOrganisation, _strApplication );

   // image sequence

   _pImageDataSet = new pixq_ImageDualSet;
   _pImageDataSet->Init( );

   // --- new project and data shot ---

   for( k = LEFT ; k <= RIGHT ; k++ ) {
      
      // texture 

      if( _pImgTexture[k] ) {
         delete _pImgTexture[k];
         _pImgTexture[k] = NULL;
      }

      _pImgTexture[k] = new pixq_DepthTexture;
      _pImgTexture[k]->Init( );   
   }

   // --- working buffers ---

   _MainTexBuffer = new pixq_TextureBuffer; 
   _MainTexBuffer->Reset( ); 

   // --- init flip parameters ---

   _pScreenPara = new pixq_ScreenPara;
   _IndexPara = new pixq_FlipPara; 

   return;
}

void scope_window::DeInitData( void )
{   
   int k, l;
	
   if( NULL != _pScreenPara ) {
      delete _pScreenPara;
      _pScreenPara = NULL;
   }

   if( NULL != _IndexPara ) { 
      delete _IndexPara;  
      _IndexPara = NULL;  
   }

   if( NULL != _pDepthEnv ) {
      delete _pDepthEnv;
      _pDepthEnv = NULL;
   }

   if( NULL != _pImageDataSet ) {
      delete _pImageDataSet;
      _pImageDataSet = NULL;
   }

   for( k = LEFT ; k <= RIGHT ; k++ ) {
      if( _pImgTexture[k] ) {
         delete _pImgTexture[k];
         _pImgTexture[k] = NULL;
      }
   }

   for( k = 0 ; k < 2 ; k++ ) {
      for( l = 0 ; l < 3 ; l++ ) {
         _ImageInMtx[k][l].Free( );
      }
   }

   // *** others ***

   ResetLeftMouseMode( );

   if( _MainTexBuffer ) { 
      delete _MainTexBuffer; 
      _MainTexBuffer = NULL; 
   }

   return;
}

void scope_window::StoreEnv( void )
{
   pixq_Properties *pEnv = GetEnv( );

   pEnv->SetRegEnv( _strOrganisation, _strApplication );

   return;
}

//
// store window position in the setting
//
void scope_window::StoreWindowPosition()
{
   QByteArray sta;
   QByteArray geo;

   QSettings settings( _strOrganisation, _strApplication );

   //

   geo = saveGeometry( );
   settings.setValue( "geometry", geo );

   //

   sta = saveState( );
   settings.setValue( "windowState", sta );

   return;
}

//
// restore the last window geometry
//
void scope_window::RestoreWindowPosition()
{
   int iCount;
   QByteArray sta;
   QByteArray geo;

   QSettings settings( _strOrganisation, _strApplication );

   geo = settings.value("geometry").toByteArray( );
   iCount = geo.count( );
   if( 0 >= iCount ) {
      // first time
      int iLeft = 30;
      int iTop = 30;
      int iWidth = 600;
      int iHeight = 700;
      QSize sz;
      QPoint ps;

      ps.setX ( iLeft );
      ps.setY ( iTop );
      sz.setWidth ( iWidth );
      sz.setHeight ( iHeight );
      move( ps );
      resize( sz );
   } else {
      restoreGeometry( geo );
   }

   //

   sta = settings.value("windowState").toByteArray( );
   iCount = sta.count( );
   if( 0 < iCount ) {
      restoreState ( sta );
   }

   return;
}

//
// to maintain left and right image image panes, same width
//
void scope_window::fixScopePanes( int nPanes )
{
   int nSize, iHandle, iPaneSize[2], iSum;
   QList<int> sp_sz;

   iHandle = _ImageSplitter->handleWidth( );

   // only need this when second image pane is shown

   if( !_Image_Pane[1]->isVisible( ) ) {
      //goto PIX_EXIT;
   }

   sp_sz = _ImageSplitter->sizes( );
   nSize = (int)sp_sz.size( ); 
   if( 2 != nSize ) {
      goto PIX_EXIT;
   }

   // two images panesmust be of same width

   iPaneSize[0] = sp_sz.at( 0 );
   iPaneSize[1] = sp_sz.at( 1 );
   iSum = iPaneSize[0] + iPaneSize[1];
   if( 0 >= iSum ) {
      goto PIX_EXIT;
   }

   if( 1 == nPanes ) {
      iPaneSize[0] = iSum;
      iPaneSize[1] = 0;
      _ImageSplitter->setHandleWidth( 0 );
   } else {
      iPaneSize[0] = iSum / 2;
      iPaneSize[1] = iPaneSize[0];
      _ImageSplitter->setHandleWidth( 1 );
   }

   sp_sz.replace( 0, iPaneSize[0] );
   sp_sz.replace( 1, iPaneSize[1] );
   _ImageSplitter->setSizes( sp_sz );

   _ImageSplitter->handle(1)->setCursor( Qt::ArrowCursor );

PIX_EXIT:
   return;
}

//
// notes:
// ResetDocAll
// 
void scope_window::ResetMain( void )
{
   pixq_FrameImageStat *pStat = GetImageStat( ); 
   pixq_ImageDualSet *pData = GetImageData( );
   int k, l;

   // --- init sequences ---

   SetImageLoading( false );
   pData->Init( );

   for( k = 0 ; k < 2 ; k++ ) {
      for( l = 0 ; l < 3 ; l++ ) {
         _ImageInMtx[k][l].Free( );
      }
   }

   // *** reset panes ***

   _sPaneShowMode = pixq_ScreenPara::ScopePaneShowNone;
   ResetLeftMouseMode( ); 

   // --- delete texture ---
     
   _pImgTexture[LEFT]->UnloadAll( ); 
   _pImgTexture[RIGHT]->UnloadAll( ); 
   
   _Image_Pane[0]->ResetPane( ); 
   _Image_Pane[1]->ResetPane( ); 
   _Index_Pane->ResetPane( ); 
   _Chart_Pane->ResetPane( );

   _Image_Pane[0]->InitWiperPos( );

   // release texture work buffer

   _MainTexBuffer->Reset( ); 

   _pScreenPara->DeInit( ); 
   _IndexPara->DeInit( ); 
   
   SetMenuState( );

   // init statistics

   pStat->Init( );

//PIX_EXIT:
   return;
}

bool scope_window::GetImageFile( int iSide, // [i] side
                                int iFrame, // [i] frame number
                                QString *strFile ) // [o] file name
{
   bool bRetCode = false;;
   pixq_ImageDualSet *pData = GetImageData( );

   // --- check arguments ---

   if( !pData->GetImageFile( iSide, iFrame,strFile ) ) {
      goto PIX_EXIT;
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
   return bRetCode;
}


//
// get texture ID for the side/frame
//
unsigned int scope_window::GetTexture( int iSide, // [i] 0 or 1
                                      int iFrame ) // [i] frame number
{
   unsigned int uiImgTexture = _pImgTexture[iSide]->GetTexture( iFrame );

   return uiImgTexture;
}

void scope_window::SetDisplayColor( short sDisplayColor )
{
   // left pane -> always rgb color

   _Image_Pane[0]->SetDisplayColor( sDisplayColor ); 
	_Image_Pane[1]->SetDisplayColor( sDisplayColor ); 
   
   // index pane -> always rgb color
   _Index_Pane->SetDisplayColor( PixImageDisplayColorRgb ); 
   
   return;
}

//
// get display color mode from the right pane
//
short scope_window::GetDisplayColor( void ) 
{
   return _Image_Pane[0]->GetDisplayColor( );  
}
//
// set the "second pane mode" for the second pane
//
// notes:
// second pane mode for the pane0 and the index 0 has no meaning
// 
void scope_window::SetPanesShowMode( short sPaneMode )
{
   pixq_ScreenPara *pScreen = GetScreenPara( ); 
   QSize in_rect, out_rect;
   
   pScreen->Lock( );
   
   in_rect = _Image_Pane[0]->size( );

   _Image_Pane[0]->setSizePolicy( QSizePolicy::Maximum, QSizePolicy::Maximum );
   _Image_Pane[1]->setSizePolicy( QSizePolicy::Maximum, QSizePolicy::Maximum );

   switch( sPaneMode ) {
   case pixq_ScreenPara::ScopePaneShowFirst: 
   case pixq_ScreenPara::ScopePaneShowSecond:
   case pixq_ScreenPara::ScopePaneShowWiper:
   case pixq_ScreenPara::ScopePaneShowInBox:
   case pixq_ScreenPara::ScopePaneShowOutBox: 
      _sPaneShowMode = sPaneMode; 
      _Image_Pane[1]->hide( );
      _Image_Pane[0]->show( );
      fixScopePanes( 1 );
      break;

   case pixq_ScreenPara::ScopePaneShowHorizontalSplit:
      _sPaneShowMode = sPaneMode; 
      _Image_Pane[0]->show( );
      _Image_Pane[1]->show( );
      _ImageSplitter->setOrientation( Qt::Horizontal );
      _Image_Pane[1]->setFocusPolicy( Qt::StrongFocus ); 
      _Image_Pane[1]->setMouseTracking( true ); 
      fixScopePanes( 2 );
      break;

   case pixq_ScreenPara::ScopePaneShowVerticalSplit:
      _sPaneShowMode = sPaneMode; 
      _Image_Pane[0]->show( );
      _Image_Pane[1]->show( );
      _ImageSplitter->setOrientation( Qt::Vertical );
      _Image_Pane[1]->setFocusPolicy( Qt::StrongFocus ); 
      _Image_Pane[1]->setMouseTracking( true ); 
      fixScopePanes( 2 );
      break;

   case pixq_ScreenPara::ScopePaneShowNone:
      _sPaneShowMode = sPaneMode; 
      _Image_Pane[0]->show( );
      _Image_Pane[1]->hide( );
      fixScopePanes( 1 );
      break;

   default: 
      _Image_Pane[0]->show( );
      _Image_Pane[1]->hide( );
      fixScopePanes( 1 );
      goto PIX_EXIT;
      break;
   }
   
   _Image_Pane[0]->setFocusPolicy( Qt::StrongFocus ); 
   _Image_Pane[0]->setMouseTracking( true ); 

   // modify geometry of windows
      
   _ImageSplitter->updateGeometry( );
   _ImageSplitter->update( );

   _Image_Pane[0]->adjustSize( );
   _Image_Pane[1]->adjustSize( );
   _Image_Pane[0]->updateGeometry( );
   _Image_Pane[1]->updateGeometry( );

   _Image_Pane[0]->update( );
   _Image_Pane[1]->update( );
   
   out_rect = _Image_Pane[0]->size( );
   pScreen->SwitchAreaType( _sPaneShowMode, out_rect );

   //

   RefreshPanes( ); 
   SetMenuState( );

PIX_EXIT:
   pScreen->Unlock( );
   return;
}

bool scope_window::SetProperties( void )
{
   bool bRetCode = false;
   pixq_Properties *pEnv = GetEnv( );
   int iMode;

   // show dialog and get the results

   iMode = EnvModeScope;
   if( !ShowPixProperty_PC( _strOrganisation, _strApplication, pEnv, iMode ) ) {
      goto PIX_EXIT;
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

static void EnableMenuActions( QList<QAction*> _actions,
                              bool bEnable )
{
   int i, nActions;
   QAction *action;

   nActions = _actions.size( );
   for( i = 0 ; i < nActions ; i++ ) {
      action = (QAction*)_actions.at( i );
      action->setEnabled( bEnable );
   }

   return;
}

//
// set menu status according to the conditions
//
void scope_window::SetMenuState( void )
{
   int i, iSelectMode, nActions;
   QAction *action;

   bool bLoaded = ValidPaneDisplayMode( );

   short sPaneMode = GetPaneShowMode( ); 
	short sPaneColor = _Image_Pane[0]->GetDisplayColor( ); 

   // enable/disable all menus

   nActions = _list_menu_actions.size( );
   for( i = 0 ; i < nActions ; i++ ) {
      action = (QAction*)_list_menu_actions.at( i );
      iSelectMode = ((QVariant)action->data( )).toInt( );

      switch( iSelectMode ) {
      case MouseActionItemEnabled:
         action->setEnabled( true );
         break;

      case MouseActionItemDouble: 
         action->setEnabled( bLoaded );
         break;

      case MouseActionItemDisabled:
      default:
         action->setEnabled( false );
         break;
      }

      // uncheck action
      action->setCheckable( true );
      action->setChecked( false );
   }

   // check items - view comparison mode
   
   switch( sPaneMode ) {
   case pixq_ScreenPara::ScopePaneShowFirst: 
      ui->action_view_first_image->setChecked( true );
      break;

   case pixq_ScreenPara::ScopePaneShowSecond:
      ui->action_view_second_image->setChecked( true );
      break;

   case pixq_ScreenPara::ScopePaneShowWiper:
      ui->action_view_wiper->setChecked( true );
      break;

   case pixq_ScreenPara::ScopePaneShowInBox:
      ui->action_view_input_in_scope->setChecked( true );
      break;

   case pixq_ScreenPara::ScopePaneShowOutBox: 
      ui->action_view_output_in_scope->setChecked( true );
      break;

   case pixq_ScreenPara::ScopePaneShowHorizontalSplit:
      ui->action_view_split_horizontally->setChecked( true );
      break;

   case pixq_ScreenPara::ScopePaneShowVerticalSplit:
      ui->action_view_split_vertically->setChecked( true );
      break;

   case pixq_ScreenPara::ScopePaneShowNone:
   default:
      break;
   }

   // check items - view color mode

   switch( sPaneColor ) {
   case PixImageDisplayColorRgb:
      ui->action_view_rgb->setChecked( true );
      break;
   case PixImageDisplayColorRed:
      ui->action_view_red_channel->setChecked( true );
      break;
   case PixImageDisplayColorGreen:
      ui->action_view_green_channel->setChecked( true );
      break;
   case PixImageDisplayColorBlue:
      ui->action_view_blue_channel->setChecked( true );
      break;
   case PixImageDisplayColorPseudoRed:
   case PixImageDisplayColorPseudoGreen:
   case PixImageDisplayColorPseudoBlue:
   default:
      break;
   }

   return;
}

//
// add a new line of message to the monitor 
//
void scope_window::DisplayMessage( const char *szFormat, ... )
{   
   char szBuffer[RECORD_SIZE];
   va_list ap;	
   
   va_start( ap, szFormat );
	sprintf( szBuffer, szFormat, ap );
	va_end( ap );

   _Scope_Monitor->DisplayMessage( szBuffer );

   return;
}

void scope_window::DisplayMessage( QString strBuffer )
{
   _Scope_Monitor->DisplayMessage( strBuffer );
}

bool scope_window::ShiftFrame( int iShift ) // [i] frame number increment
{
   bool bRetCode = false;
   pixq_ImageDualSet *pData = GetImageData( );

   // --- check conditions --- 
   
   if( !pData->ShiftCurrentFrame( iShift ) ) {
      goto PIX_EXIT;
   }

   // --- move to the frame ---

   SelectFrame( );

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
   return bRetCode;
}

bool scope_window::ReloadFrame( void )
{   
   bool bRetCode = false;   

QApplication::setOverrideCursor( Qt::BusyCursor );

   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }
   
   if( !SelectFrame( ) ) {
      goto PIX_EXIT;
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
QApplication::restoreOverrideCursor();
   return bRetCode;
}


void scope_window::SetPanesCursor( QCursor cur )
{
   setCursor( cur );

   _Image_Pane[0]->setCursor( cur ); 
	_Image_Pane[1]->setCursor( cur ); 
   _Index_Pane->setCursor( cur ); 

   QApplication::processEvents( );

   return;
}

void scope_window::RefreshPanes( void )
{
   if( _Image_Pane[0]->isVisible( ) ) {
      _Image_Pane[0]->RefreshSingle( ); 
   }
   
   if( _Image_Pane[1]->isVisible( ) ) {
      _Image_Pane[1]->RefreshSingle( ); 
   }
   
   if( _Index_Pane->isVisible( ) ) {
      _Index_Pane->RefreshSingle( ); 
   }

   return;
}

//
// get image file name according to the mode and side
//
bool scope_window::GetSideFile( int iSide, // [i] 0 or 1
                              QString *strFile ) 
{
   bool bRetCode = false;
   pixq_ImageDualSet *pData = GetImageData( );

   if( 0 > iSide || 1 < iSide ) {
      goto PIX_EXIT;
   }

   if( !pData->GetImageFile( iSide, strFile ) ) {
      goto PIX_EXIT;
   }      

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
   return bRetCode;
}


bool scope_window::LoadFrame( const QString strFile, 
                             pixq_Matrix<unsigned short> *usRed, 
                             pixq_Matrix<unsigned short> *usGrn, 
                             pixq_Matrix<unsigned short> *usBlu )
{
   bool bRetCode = false;
   
   // --- file existence ---

   if( !FileExist_PC( strFile ) ) {
      goto PIX_EXIT;  
   }

   // load supported image 

   if( !MagickLoadImage_PC( strFile, usRed, usGrn, usBlu ) ) {
      goto PIX_EXIT;
   }

	// --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}


//
// create image texture for given pane from given image matrix(0/1/2)
//
bool scope_window::CreateImageTexture( ScopePane *pPane, // [i] for which pane?
                                     int iIMage )  // [i] which image matrix to use, 0 or 1
{
   bool bRetCode = false;

   if( !pPane->CreateImageTexture( &_ImageInMtx[iIMage][0], 
      &_ImageInMtx[iIMage][1], &_ImageInMtx[iIMage][2], iIMage ) ) {
         goto PIX_EXIT;
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
   return bRetCode;
}


//
// set loade image matrix to inout 
//
bool scope_window::CreateLoadedTexture( void )
{
   bool bRetCode = false;
   ScopeMonitor *pMonitor = (ScopeMonitor*)GetMonitorPane( );
   ScopePane *pLeftPane = (ScopePane*)_Image_Pane[0];
   ScopePane *pRightPane = (ScopePane*)_Image_Pane[1];
            
   // *** create image texture for the right pane from the derive image matrices ***
   
   // --- create OpenGL texture from the image matrix 1 in the right pane's first texture ---
   // --- create OpenGL texture from the image matrix 2 in the right pane's second texture ---
     
   if( !CreateImageTexture( pLeftPane, 0 ) ) { 
      pMonitor->DisplayMessage( "ERROR! Failed to Create texture." );
      goto PIX_EXIT;
   }
 
   if( !CreateImageTexture( pLeftPane, 1 ) ) { 
      pMonitor->DisplayMessage( "ERROR! Failed to Create texture." );
      goto PIX_EXIT;
   }

   if( !CreateImageTexture( pRightPane, 0 ) ) { 
      pMonitor->DisplayMessage( "ERROR! Failed to Create texture." );
      goto PIX_EXIT;
   }

   if( !CreateImageTexture( pRightPane, 1 ) ) { 
      pMonitor->DisplayMessage( "ERROR! Failed to Create texture." );
      goto PIX_EXIT;
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
   return bRetCode;
}

//
// display color under the mouse on status bar
//
void scope_window::GetColor( int iSide, int iMouseX, int iMouseY )
{
   int k, iPixX, iPixY;
   double dPixX, dPixY;

   unsigned short usRed, usGrn, usBlu;
   QString strValue, strCoo, strColor[2];

   const pixq_ScreenPara *pScreen = GetScreenPara( );
   const pixq_PanePara *pFlip = pScreen->GetSingleFlip( ); 
   const pixq_FlipPara *pIndex = GetIndexPara( );  

   if( pScreen->IsLocked( ) ) {
      // screen is busy
      goto PIX_EXIT;
   }

   // coordinate    
   switch( iSide ) {

   case ScopePane::ScopePaneSplitLeft: // left split pane 
   case ScopePane::ScopePaneSplitRight: // right split pane 
      pFlip->ViewportToPixelCoo( iMouseX, iMouseY, &dPixX, &dPixY ); 
      //pSplit->ViewportToPixelCoo( iMouseX, iMouseY, &dPixX, &dPixY ); 
      iPixX = (int)floor( dPixX );
      iPixY = (int)floor( dPixY );
      break;

   case ScopePane::ScopePaneIndex:
      pIndex->ViewportToPixelCoo( iMouseX, iMouseY, &dPixX, &dPixY ); 
      iPixX = (int)floor( dPixX );
      iPixY = (int)floor( dPixY );
      break;

   case ScopePane::ScopePaneUnknown: 
   default:
      goto PIX_EXIT;
   }

   // *** First image -> always display pixel value! ***

   switch( iSide ) {

   case ScopePane::ScopePaneSplitLeft: // left split pane 
   case ScopePane::ScopePaneSplitRight: // right split pane 
   case ScopePane::ScopePaneIndex:
      
      strCoo.sprintf( "Coo(%7.2f,%7.2f)", dPixX, dPixY );
      //strCoo.sprintf( "Coo(%04d,%04d), iPixX, iPixY, usRed );
      
      for( k = 0 ; k < 2 ; k++ ) {
         if( _ImageInMtx[k][0].IsInside( iPixX, iPixY ) ) {
            usRed = _ImageInMtx[k][0].Get( iPixY, iPixX );
            usGrn = _ImageInMtx[k][1].Get( iPixY, iPixX );
            usBlu = _ImageInMtx[k][2].Get( iPixY, iPixX );
            strColor[k].sprintf( "[%05d,%05d,%05d]", usRed, usGrn, usBlu );
         } else {
            strColor[k] = "[*****,*****,*****]";
         }
      }

      strValue = strCoo + ": Color" + strColor[0] + "/" + strColor[1];
      _statusLabel[0]->setText( strValue );

      break;
   }

PIX_EXIT:
   return;
}

//
// handle key input
//
// returns:
// true: key input in handled
//
bool scope_window::ProcessKeyEvent( short sPane, int iKey )
{
   bool bProc = false;
   pixq_ScreenPara *pScreen = GetScreenPara( );

   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

	switch( sPane ) {
   case ScopePane::ScopePaneSplitLeft: 
   case ScopePane::ScopePaneSplitRight: 
		break;

   case ScopePane::ScopePaneUnknown:
   case ScopePane::ScopePaneIndex:
   default:
      goto PIX_EXIT;
      break;
   }

	switch( iKey ) {
	case Qt::Key_Right:	
      if( ValidPaneDisplayMode( ) ) {
         ShiftFrame( 1 );
      }
      bProc = true;
		break;

	case Qt::Key_Left:
      if( ValidPaneDisplayMode( ) ) {
         ShiftFrame( -1 );
      }
      bProc = true;
		break;

   case Qt::Key_1: // 1 on NumPad
      if( ValidPaneDisplayMode( ) ) {
         pScreen->XYViewShift( 1, 1 );
         RefreshPanes( );
      }
      bProc = true;
      break;

   case Qt::Key_2: // 2 on NumPad
      if( ValidPaneDisplayMode( ) ) {
         pScreen->XYViewShift( 0, 1 );
         RefreshPanes( );
      }
      bProc = true;
      break;

   case Qt::Key_3: // 3 on NumPad
      if( ValidPaneDisplayMode( ) ) {
         pScreen->XYViewShift( -1, 1 );
         RefreshPanes( );
      }
      break;

   case Qt::Key_4: // 4 on NumPad
      if( ValidPaneDisplayMode( ) ) {
         pScreen->XYViewShift( 1, 0 );
         RefreshPanes( );
      }
      bProc = true;
      break;

   case Qt::Key_5: // 5 on NumPad
      if( ValidPaneDisplayMode( ) ) {
         //BlackOutWindow_ITFM( (CWnd*)this );
         pScreen->FlipRecenter( );
         RefreshPanes( );
      }
      bProc = true;
      break;

   case Qt::Key_6: // 6 on NumPad
      if( ValidPaneDisplayMode( ) ) {
         pScreen->XYViewShift( -1, 0 );
         RefreshPanes( );
      }
      bProc = true;
      break;

   case Qt::Key_7: // 7 on NumPad
      if( ValidPaneDisplayMode( ) ) {
         pScreen->XYViewShift( 1, -1 );
         RefreshPanes( );
      }
      bProc = true;
      break;

   case Qt::Key_8: // 8 on NumPad
      if( ValidPaneDisplayMode( ) ) {
         pScreen->XYViewShift( 0, -1 );
         RefreshPanes( );
      }
      bProc = true;
      break;

   case Qt::Key_9: // 9 on NumPad
      if( ValidPaneDisplayMode( ) ) {
         pScreen->XYViewShift( -1, -1 );
         RefreshPanes( );
      }
      bProc = true;
      break;

   case Qt::Key_Home: 
      if( ValidPaneDisplayMode( ) ) {
         pScreen->ViewOneToOne( );
         RefreshPanes( );
      }
      bProc = true;
      break;

	case Qt::Key_Plus: // + on NumPad
      if( ValidPaneDisplayMode( ) ) {
         pScreen->ZViewShift( -1 );
         RefreshPanes( );
      }
      bProc = true;
      break;

   case Qt::Key_Minus:	// - on NumPad
      if( ValidPaneDisplayMode( ) ) {
         pScreen->ZViewShift( 1 );
         RefreshPanes( );
      }
      bProc = true;
      break;

	// ESCAPE stop play/repeat thread
   case Qt::Key_Escape:
      // no mouse mode
      ResetLeftMouseMode( );
      RefreshPanes( );
      bProc = true;
      break;  

	// SPACE: pause play/repeat thread
	case Qt::Key_Space:
      break;
	}

PIX_EXIT:
   return bProc;
}

bool scope_window::ProcessWheelEvent( short sPane, 
                                     int iDelta )
{
   bool bProc = false;
   int iShift;   
   pixq_ScreenPara *pScreen = GetScreenPara( );
   //pixq_FlipPara *pFlip = NULL;  

   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

	switch( sPane ) {
   case ScopePane::ScopePaneSplitLeft: 
   case ScopePane::ScopePaneSplitRight: 
      break;

   case ScopePane::ScopePaneIndex:
   case ScopePane::ScopePaneUnknown:
   default:
      goto PIX_EXIT;
      break;
   }

   iShift = (int)-iDelta / 10;
   pScreen->ZViewShift( iShift );
   RefreshPanes( );

PIX_EXIT:
   return bProc;
}

bool scope_window::ProcessScrollEvent( short sPane,
                                      int iX, 
                                      int iY )
{
   bool bProc = false;
   pixq_ScreenPara *pScreen = GetScreenPara( ); 

   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

	switch( sPane ) {
   case ScopePane::ScopePaneSplitLeft: 
   case ScopePane::ScopePaneSplitRight: 
      //pFlip = GetSplitPara( ); 
      break;

   case ScopePane::ScopePaneIndex:
   case ScopePane::ScopePaneUnknown:
   default:
      goto PIX_EXIT;
      break;
   }

   pScreen->XYViewStep( -iX, iY );
   RefreshPanes( );

PIX_EXIT:
   return bProc;
}


void scope_window::ImageSplitterMoved( int /* pos */,
                                      int /* index */ )
{
   SetImageSplitterWidth( );

   return;
}

void scope_window::SetImageSplitterWidth( void )
{
   QList<int> sp_sz;
   int nSize;
   int nWidth, iPaneWidth[2];

   sp_sz = _ImageSplitter->sizes( );
   nSize = (int)sp_sz.size( ); 
   if( 2 != nSize ) {
      goto PIX_EXIT;
   }

   iPaneWidth[0] = sp_sz.at( 0 );
   iPaneWidth[1] = sp_sz.at( 1 );
   nWidth = iPaneWidth[0] + iPaneWidth[1];
   if( 0 >= nWidth ) {
      goto PIX_EXIT;
   }

   iPaneWidth[0] = nWidth / 2;
   iPaneWidth[1] = iPaneWidth[0];

   sp_sz.replace( 0, iPaneWidth[0] );
   sp_sz.replace( 1, iPaneWidth[1] );
   _ImageSplitter->setSizes( sp_sz );

PIX_EXIT:
   return;
}

void scope_window::SetFrameStatusBar( void )
{
   QString strFrame, strImage0, strImage1;
   pixq_ImageDualSet *pData = GetImageData( );
   short sSelectMode = pData->GetSelectMode( );
   int iCurrentFrame, iFirstFrame, iLastFrame; 

   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   if( !pData->GetCurrentFiles( &strImage0, &strImage1 ) ) {
      strImage0 = QString("********");
      strImage1 = QString("********");
   }

   strFrame = pData->GetFrameString( );

   _statusLabel[1]->setText( strImage0 );
   _statusLabel[2]->setText( strImage1 );
   _statusLabel[3]->setText( strFrame );

   //

   switch( sSelectMode ) {
   case pixq_ImageDualSet::PixDualSetSequence:
      iCurrentFrame = pData->GetCurrentFrame( );
      iFirstFrame = pData->GetFirstFrame( );
      iLastFrame = pData->GetLastFrame( );
      _statusProgress->setRange( iFirstFrame+1, iLastFrame+1 );
      _statusProgress->setValue( iCurrentFrame+1 );
      break;

   case pixq_ImageDualSet::PixDualSetPair:
   case pixq_ImageDualSet::PixDualSetNone:
   default:
      _statusProgress->setRange( 0, 1 );
      _statusProgress->setValue( 0 );
      break;
   }

PIX_EXIT:
   return;
}

bool scope_window::SelectImagePair( void )
{
   bool bRetCode = false;
   int nSize;
   pixq_Properties *pEnv = GetEnv( );
   pixq_ImageDualSet *pData = GetImageData( );

   QFileInfo finfo;
   QString strPath, strLastDir, strLabel, strFile[2];
   QStringList fileNames;
   QString strFilters, strSelectedFilter;
#ifdef _READY
   QFileDialog dialog( this );
#endif 

   QFileDialog::Options options;

   ScopeMonitor *pMonitor = (ScopeMonitor*)GetMonitorPane( );

   // reset data settings

   ResetMain( );

   // show dialog and get the results

   strLastDir = pEnv->_ScopeLastImageDir.strGet( );
   if( strLastDir.isEmpty( ) ) {
      strLastDir = QDir::currentPath( );
   }

   strLabel = tr("Select Two Images");
   ImageFileFilter_ITF( true, &strFilters );
   
#ifdef _READY
   dialog.setNameFilter( strFilters );
   dialog.setLabelText( QFileDialog::LookIn, strLabel );
   dialog.setDirectory( strLastDir );

   dialog.setAcceptMode( QFileDialog::AcceptOpen );
   dialog.setFileMode( QFileDialog::ExistingFiles );	
   dialog.setConfirmOverwrite( false );	

   // get sample file!

   options = QFileDialog::DontUseNativeDialog;
   dialog.setOption( QFileDialog::DontUseNativeDialog );
   if( QDialog::Accepted != dialog.exec( ) ) {
      goto PIX_EXIT;
   }

   fileNames = dialog.selectedFiles( );
#endif

   options = QFileDialog::ReadOnly;
   fileNames = QFileDialog::getOpenFileNames ( this, 
      strLabel,
      strLastDir, 
      strFilters, 
      &strSelectedFilter,
      options );

   nSize = fileNames.size( );
   if( 2 > nSize ) {
      pMonitor->DisplayMessage( "ERROR! Select two Images." );
      goto PIX_EXIT;
   }

   strFile[0] = fileNames.at( 0 );
   strFile[1] = fileNames.at( 1 );

   pData->SetImagePair( strFile[0], strFile[1] ); 

   // --- start to draw! ---  
   
   if( pixq_ScreenPara::ScopePaneShowNone == GetPaneShowMode( ) ) {
      SetPanesShowMode( pixq_ScreenPara::ScopePaneShowWiper );
   }

   if( !SelectFrame( ) ) {
      RefreshPanes( );
      goto PIX_EXIT;
   }

   SetMenuState( );

   // remember the directory for the next time

   finfo.setFile( strFile[0] );
   strPath = finfo.path( );
   pEnv->_ScopeLastImageDir.Set( strPath );
   pEnv->SetRegEnv( _strOrganisation, _strApplication );

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool scope_window::SelectDualSequence( void )
{
   bool bRetCode = false;
   pixq_Properties *pEnv = GetEnv( );
   pixq_ImageDualSet *pData = GetImageData( );
   QString strApplication;
   short sMode;
   short sPaneMode = GetPaneShowMode( );

   // reset data settings

   ResetMain( );

   // show dialog and get the results

   strApplication = _strApplication;
   if( !SelectDualSequences_ITF( _strOrganisation, strApplication, pEnv, pData ) ) {
      goto PIX_EXIT;
   }

   // --- check the sequence ---

   sMode = (short)pixq_ImageDualSet::PixDualSetSequence;
   pData->SetSelectMode( sMode );

   if( !pData->CheckSequences( ) ) {
      goto PIX_EXIT;
   }

   pData->InitFrame( );

   // --- start to draw! ---  
   
   if( pixq_ScreenPara::ScopePaneShowNone == sPaneMode ) {
      SetPanesShowMode( pixq_ScreenPara::ScopePaneShowWiper );
   }

   if( !SelectFrame( ) ) {
      goto PIX_EXIT;
   }

   SetMenuState( );

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}


bool scope_window::ValidPaneDisplayMode( void )
{
   bool bRetCode = false;
   short sPaneShowMode = GetPaneShowMode( );
   
   switch( sPaneShowMode ) {
   case pixq_ScreenPara::ScopePaneShowFirst: 
   case pixq_ScreenPara::ScopePaneShowSecond:
   case pixq_ScreenPara::ScopePaneShowWiper: 
   case pixq_ScreenPara::ScopePaneShowInBox:
   case pixq_ScreenPara::ScopePaneShowOutBox: 
   case pixq_ScreenPara::ScopePaneShowHorizontalSplit:
   case pixq_ScreenPara::ScopePaneShowVerticalSplit:
      break;

   case pixq_ScreenPara::ScopePaneShowNone: 
      goto PIX_EXIT;
      break;

   default:
      goto PIX_EXIT;
      break;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}
