#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "scope_common.h"
#include "scope_panes.h"
#include "scope_monitor.h"
#include "scope_window.h"

//
// Version History:
//
// 1.1
// 20120921
// depth-adaptive sharpning
//

pixq_Version scope_window::Version( void )
{
   pixq_Version ver;
   short sPlatform;
   QDate date;

   ver.SetCompany( "PixTOPO" );
   ver.SetProductName( tr("Image Enhancement Tools") );
   ver.SetApplication( "Scope" );
   ver.SetDescription( tr("Image Enhancement Tool") );

   ver.SetMajorVersion( 1 );
   ver.SetMinorVersion( 1 );
   ver.SetReleaseNumber( 0 );

   date.setYMD( 2012, 5, 11 );
   ver.SetReleaseDate( date );

   ver.SetContact( tr("pixtopo@gmail.com") );
   ver.SetWebSite( tr("www.pixtopo.com") );

#ifdef _WIN64
   sPlatform = pixq_Properties::PlatformWin64;
#else
   sPlatform = pixq_Properties::PlatformWin32;
#endif
   ver.SetPlatform( sPlatform );

   return ver;
}

