#pragma once

#include <QtWidgets>

#include <property_page.h>
#include "props_op_dft_filter.h"

class sampler_window;
class SamplerDock;

namespace Ui {
    class ImageCtrl;
}

class ImageCtrl : public QWidget
{
    Q_OBJECT

public:
    explicit ImageCtrl(QWidget *parent = 0);
    ~ImageCtrl();

public:
   void Init( void );
   void AddPropPage( QWidget *pPage, QString strName, int iPageType ); 
   //void AddPropPage( void *pPage, QString strName, int iPageType ); 

   void SetMainWindow( sampler_window *pMain ) { _pMainWindow = pMain; }
   sampler_window *GetMainWindow( void ) { return _pMainWindow; }
   
   void SetParent( SamplerDock *pDock ) { _pParent = pDock; }
   SamplerDock *GetParent( void ) { return _pParent; }

   void setCurrentPage( int iPage );

   void EnableCtrlButtons( bool bEnabled );

   bool SetPageIndex( int iPageIndex );

private:
   bool CheckPageType( int iPageType );
   bool CheckPageIndex( int iPageIndex );
   
   int GetPageType( int iPageIndex );

   bool DefaultPageIndex( int iPageIndex );
   bool DefaultPageType( int iPageType );

   bool SetPageType( int iPageType );

private:
   Ui::ImageCtrl *ui;
      
   // pointer to the main window
   sampler_window *_pMainWindow;
   SamplerDock *_pParent;

private slots:
   void on_apply_button_clicked();
   void on_default_button_clicked();

   void on_close_Button_clicked();

public:
   props_op_dft_filter     _opPropDftFilter;  
   
protected:   
   void showEvent( QShowEvent *eve );
};
