#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "sampler_common.h"

#include <property_page.h>
#include "props_op_dft_filter.h"
#include "ui_props_op_dft_filter.h"

props_op_dft_filter::props_op_dft_filter(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::props_op_dft_filter)
{
    ui->setupUi(this);
    
    _propPage = value_prop_page_op_dft_filter;
}

props_op_dft_filter::~props_op_dft_filter()
{
    delete ui;
}

void props_op_dft_filter::Init( pixq_Properties *pEnv )
{
   Store( pEnv );

   SetData( );

   return;
}

//
// set current data
//
void props_op_dft_filter::SetData( void )
{   
   pixq_Properties *pEnv = GetEnv( );
   
   // ******************
   // *** DFT Filter ***
   // ******************

   // filter - low/high filter, boundary
   
   Set2Double( &pEnv->_DftFilterHighLowPassBoundary,
      ui->dft_filter_high_low_pass_boundary_edit ); 

   // filter DFT visualize sigma range
   // when the results of DFT is visualized, extent of average +/- sigma * range is
   // scaled to 0 - 255

   Set2Double( &pEnv->_DftFilterDftSigmaRange, 
      ui->dft_filter_dft_sigma_range_edit ); 

   // filter - band-pass filter, lower boundary
   
   Set2Double( &pEnv->_DftFilterBandPassLowBoundary,
      ui->dft_filter_band_pass_low_boundary_edit ); 

   // filter - band-pass filter,  higher boundary 
  
   Set2Double( &pEnv->_DftFilterBandPassHighBoundary,
      ui->dft_filter_band_pass_high_boundary_edit ); 
      
   // filter - filter type, one of DigitalImageFilterShape

   SetDigitalFilterShape( );

   // filter - channel to analyze for 1D or 2D visualization of DFT results
   // one of PixImageColorChannel

   SetVisualizeColor( );

   // --- Done ---
   return;
}

bool props_op_dft_filter::Check( void )
{  
   bool bRetCode = false;
   pixq_Properties *pEnv = GetEnv( );

   // ******************
   // *** DFT Filter ***
   // ******************

   // filter DFT visualize sigma range
   // when the results of DFT is visualized, extent of average +/- sigma * range is
   // scaled to 0 - 255

   if( !GetDouble( &pEnv->_DftFilterDftSigmaRange, 
      ui->dft_filter_dft_sigma_range_edit ) ) {
         QMessageBox::critical( this, _strApplication, "Enter Real Value." );
         goto PIX_EXIT;
   } 

   // filter - low/high filter, boundary

   if( !GetDouble( &pEnv->_DftFilterHighLowPassBoundary, 
      ui->dft_filter_high_low_pass_boundary_edit ) ) {
         QMessageBox::critical( this, _strApplication, "Enter Real Value." );
         goto PIX_EXIT;
   } 

   // filter - band-pass filter, lower boundary
   
   if( !GetDouble( &pEnv->_DftFilterBandPassLowBoundary, 
      ui->dft_filter_band_pass_low_boundary_edit ) ) {
         QMessageBox::critical( this, _strApplication, "Enter Real Value." );
         goto PIX_EXIT;
   } 

   // filter - band-pass filter,  higher boundary 
  
   if( !GetDouble( &pEnv->_DftFilterBandPassHighBoundary, 
      ui->dft_filter_band_pass_high_boundary_edit ) ) {
         QMessageBox::critical( this, _strApplication, "Enter Real Value." );
         goto PIX_EXIT;
   } 
      
   // filter - filter type, one of DigitalImageFilterShape

   // done in radio box 

   // filter - channel to analyze for 1D or 2D visualization of DFT results
   // one of PixImageColorChannel

   // done in radio box

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// set shape of the Digital Filter
//
void props_op_dft_filter::SetDigitalFilterShape( void )
{
   pixq_Properties *pEnv = GetEnv( );
   int iShape;

   ui->dft_filter_shape_low_pass_radio->setChecked( false );
   ui->dft_filter_shape_high_pass_radio->setChecked( false );
   ui->dft_filter_shape_band_pass_radio->setChecked( false );
   ui->dft_filter_shape_notch_radio->setChecked( false );

   // texture style
   iShape = pEnv->_DftFilterDigitalFiltersShape.GetInt( );

   switch( iShape ) {
   case pixq_Properties::DigitalFilterLowPass:
      ui->dft_filter_shape_low_pass_radio->setChecked( true );
      break;
   case pixq_Properties::DigitalFilterHighPass:
      ui->dft_filter_shape_high_pass_radio->setChecked( true );
      break;
   case pixq_Properties::DigitalFilterBandPass:
      ui->dft_filter_shape_band_pass_radio->setChecked( true );
      break;
   case pixq_Properties::DigitalFilterNotch:
      ui->dft_filter_shape_notch_radio->setChecked( true );
      break;
   }

   return;
}

//
// set color to visualize
//
void props_op_dft_filter::SetVisualizeColor( void )
{
   pixq_Properties *pEnv = GetEnv( );
   int iColor;

   ui->dt_filter_dft_visualize_color_red_radio->setChecked( false );
   ui->dt_filter_dft_visualize_color_green_radio->setChecked( false );
   ui->dt_filter_dft_visualize_color_blue_radio->setChecked( false );
   ui->dt_filter_dft_visualize_color_gray_radio->setChecked( false );

   // texture style
   iColor = pEnv->_DftFilterDftVisualizeColor.GetInt( );

   switch( iColor ) {
   case pixq_Properties::PixImageColorRed:
      ui->dt_filter_dft_visualize_color_red_radio->setChecked( true );
      break;
   case pixq_Properties::PixImageColorGreen:
      ui->dt_filter_dft_visualize_color_green_radio->setChecked( true );
      break;
   case pixq_Properties::PixImageColorBlue:
      ui->dt_filter_dft_visualize_color_blue_radio->setChecked( true );
      break;
   case pixq_Properties::PixImageColorGrayscale:
      ui->dt_filter_dft_visualize_color_gray_radio->setChecked( true );
      break;
   }

   return;
}

void props_op_dft_filter::on_dt_filter_dft_visualize_color_red_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iColor = pixq_Properties::PixImageColorRed;
   pEnv->_DftFilterDftVisualizeColor.Set( iColor );

   SetVisualizeColor( );

   return;
}

void props_op_dft_filter::on_dt_filter_dft_visualize_color_green_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iColor = pixq_Properties::PixImageColorGreen;
   pEnv->_DftFilterDftVisualizeColor.Set( iColor );

   SetVisualizeColor( );

   return;
}

void props_op_dft_filter::on_dt_filter_dft_visualize_color_blue_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iColor = pixq_Properties::PixImageColorBlue;
   pEnv->_DftFilterDftVisualizeColor.Set( iColor );

   SetVisualizeColor( );

   return;
}

void props_op_dft_filter::on_dt_filter_dft_visualize_color_gray_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iColor = pixq_Properties::PixImageColorGrayscale;
   pEnv->_DftFilterDftVisualizeColor.Set( iColor );

   SetVisualizeColor( );

   return;
}

void props_op_dft_filter::on_dft_filter_shape_low_pass_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iShape = pixq_Properties::DigitalFilterLowPass;
   pEnv->_DftFilterDigitalFiltersShape.Set( iShape );

   SetDigitalFilterShape( );

   return;
}

void props_op_dft_filter::on_dft_filter_shape_high_pass_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iShape = pixq_Properties::DigitalFilterHighPass;
   pEnv->_DftFilterDigitalFiltersShape.Set( iShape );

   SetDigitalFilterShape( );

   return;
}

void props_op_dft_filter::on_dft_filter_shape_band_pass_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iShape = pixq_Properties::DigitalFilterBandPass;
   pEnv->_DftFilterDigitalFiltersShape.Set( iShape );

   SetDigitalFilterShape( );

   return;
}

void props_op_dft_filter::on_dft_filter_shape_notch_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iShape = pixq_Properties::DigitalFilterNotch;
   pEnv->_DftFilterDigitalFiltersShape.Set( iShape );

   SetDigitalFilterShape( );

   return;
}
