#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "sampler_common.h"
#include "sampler_panes.h"
#include "sampler_monitor.h"
#include "sampler_window.h"

SamplerPane::SamplerPane(QWidget *parent)
    : QGLWidget(parent)
{
   _sPaneType = SamplerPaneUnknown;
   _pMainWindow = (sampler_window*)NULL;   

   _bMouseDragging = false;
   _PaneTexture.Init( );
   _bWiperVertical = true;
   
   return;
}

SamplerPane::~SamplerPane()
{
   return;
}

void SamplerPane::showEvent( QShowEvent * /*eve*/ )
{
   return;
}

void SamplerPane::initializeGL( void )
{
   glEnable( GL_LIGHTING );
   glEnable( GL_LIGHT0 );
   glEnable( GL_DEPTH_TEST );
   glEnable( GL_NORMALIZE );
   glClearColor( 0.0f, 0.0f, 0.0f, 1.0f ); 

   return;
}

void SamplerPane::paintGL( void )
{
   if( !ValidPaneDisplayMode( ) ) {
      RefreshClear( );
      goto PIX_EXIT;
   }

   RefreshSingle( );

PIX_EXIT:
   return;
}

void SamplerPane::resizeEvent( QResizeEvent * /*eve*/ )
{
   sampler_window *pMain = (sampler_window*)GetMainWindow( );

   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   if( !pMain->GetImageLoaded( ) ) {
      goto PIX_EXIT;
   }

   // set viewport

   ChangeScreenSize( );

PIX_EXIT:
   return;
}

void SamplerPane::keyPressEvent( QKeyEvent *eve )
{
   sampler_window *pMain = (sampler_window*)GetMainWindow( );
   
   if( !pMain->GetImageLoaded( ) ) {
      goto PIX_EXIT;
   }

   int iKey = eve->key( );

   if( pMain->ProcessKeyEvent( _sPaneType, iKey ) ) {
      goto PIX_EXIT;
   }

   QGLWidget::keyPressEvent( eve );

PIX_EXIT:
   return;
}

void SamplerPane::wheelEvent( QWheelEvent *eve )
{
   sampler_window *pMain = (sampler_window*)GetMainWindow( );
   int iDelta;

   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   if( !pMain->GetImageLoaded( ) ) {
      goto PIX_EXIT;
   }

   switch( _sPaneType ) {
   case SamplerPaneSplitLeft: 
   case SamplerPaneSplitRight:
      break;

   case SamplerPaneIndex: 
      goto PIX_EXIT;
      break;
   }

   iDelta = eve->delta( );
   if( pMain->ProcessWheelEvent( _sPaneType, iDelta ) ) {
      goto PIX_EXIT;
   }

PIX_EXIT:
   return;
}

//
// mouse button pressed
//
void SamplerPane::mousePressEvent( QMouseEvent *eve )
{
   sampler_window *pMain = (sampler_window*)GetMainWindow( );
   short sLeftMouseMode = pMain->sGetLeftMouseMode( );

   QSize rect = size( );

   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   if( !pMain->GetImageLoaded( ) ) {
      goto PIX_EXIT;
   }

   switch( eve->button( ) ) {
   //
   // Left Click
   //
   case Qt::LeftButton:   
      switch( _sPaneType ) {
      case SamplerPaneSplitLeft: 
         // left -> do some job accotrding to the mode
         switch( sLeftMouseMode ) {

         case sampler_window::MouseLeftClickNone:
         default:
            //
            // no work to do
            //
            if( pMain->CheckLoadSequence( ) ) {
               SwitchPaneMode( );
            }
            break;
         }
         break;

      case SamplerPaneSplitRight: 
         // right pane -> switch viewing method according to the mode
         
         switch( sLeftMouseMode ) {

         case sampler_window::MouseLeftClickNone:
         default:
            //
            // no work to do
            //
            if( pMain->CheckLoadSequence( ) ) {
               SwitchPaneMode( );
            }
            break;
         }
         break; 
         

      case SamplerPaneIndex: 
         RefreshSingle( );
         break;
      }
      break;

   //
   // Right Click
   //
   case Qt::RightButton:      
      _bMouseDragging = true;
      _MousePoint = eve->pos();
      RefreshSingle( );
      break;
   }

   //QGLWidget::mousePressEvent( eve );

PIX_EXIT:
   return;
}

//
// mouse button released
//
void SamplerPane::mouseReleaseEvent( QMouseEvent *eve )
{
   sampler_window *pMain = (sampler_window*)GetMainWindow( );

   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   if( !pMain->GetImageLoaded( ) ) {
      goto PIX_EXIT;
   }

   // right button

   if( Qt::RightButton == eve->button( ) ) {
      _bMouseDragging = false;
      goto PIX_EXIT;
   }

   //QGLWidget::mouseReleaseEvent( eve );

PIX_EXIT:
   return;
}

void SamplerPane::mouseMoveEvent( QMouseEvent *eve )
{
   sampler_window *pMain = (sampler_window*)GetMainWindow( );
   QSize rect = size( );

   int iMouseX = eve->x();
   int iMouseY = rect.height( ) - eve->y();

   if( !ValidPaneDisplayMode( ) ) {
      QGLWidget::mouseMoveEvent( eve );
      goto PIX_EXIT;
   }

   if( !pMain->GetImageLoaded( ) ) {
      goto PIX_EXIT;
   }

   // right button pressed down
   // --- drag the image ---

   if( Qt::RightButton == eve->button( ) ) {
      // right mouse button is being pressed
       setCursor( Qt::DragMoveCursor );
      // setCursor( Qt::MoveCursor );
      _bMouseDragging = true;
   }
   
   // --- display coordinate ---

   pMain->GetColor( _sPaneType, iMouseX, iMouseY );
   
   // --- drag the image ---

   if( _bMouseDragging ) {
      int iX = eve->x() - _MousePoint.x( );
      int iY = eve->y() - _MousePoint.y( );
      pMain->ProcessScrollEvent( _sPaneType, iX, iY );
   }

   _MousePoint.setX( eve->x() );
   _MousePoint.setY( eve->y() );

   // *** if wiper mode, move wiper ***

   switch( _sPaneType ) {
   case SamplerPaneSplitLeft:  
      switch( _sPaneShowMode ) {
      case SamplerPaneShowWiper:  
         _nWiperX = iMouseX; 
         _nWiperY = iMouseY;    
         RefreshSingle( );
         break;
      

      default: 
         break;
      }

      break;

   case SamplerPaneSplitRight:  

      switch( _sPaneShowMode ) {
      case SamplerPaneShowWiper:  
         _nWiperX = iMouseX; 
         _nWiperY = iMouseY;    
         RefreshSingle( );
         break;
               
      default: 
         break;
      }
      break;

   }

PIX_EXIT:
   return;
}

void SamplerPane::closeEvent( QCloseEvent * /*eve*/ )
{
   DeInit( );
}
