#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "sampler_common.h"
#include "sampler_panes.h"
#include "sampler_monitor.h"
#include "sampler_window.h"

bool SamplerPane::InitializeOpenGL( void ) 
{  
   bool bRetCode = false; 
   int nWidth, nHeight;
   float fLineRange[2];
   QSize rect;

   // --- get dimension ---
   
   rect = size( );
   nWidth = (int)rect.width( );
   nHeight = (int)rect.height( ); 		
				
	// *** DO NOT Enable GL_DEPTH here as it causes ***
   // unknown error while intializing the OpenGL extension ***

   //glEnable( GL_DEPTH );
	glEnable( GL_TEXTURE_RECTANGLE_ARB );
	glClearColor( 0.0f, 0.0f, 0.0f, 1.0f );

	glViewport( 0, 0, nWidth, nHeight );		
												
	glMatrixMode( GL_PROJECTION );		
	glLoadIdentity( );				

	glMatrixMode( GL_MODELVIEW );		
	glLoadIdentity( );

   // --- Check if OpenGL version 2.0 or higher? ---

   _bOpenGL2 = OpenGlHigherThanTwo_PI( );   
   if( !_bOpenGL2 ) {
   //   QMessageBox::warning( this, "OpenGL",
  //       "This Copmputer does not Support OpenGL 2.0 or Higher." );
      //exit( 0 );
   }
   
   // set line symbl size
   glGetFloatv( GL_LINE_WIDTH_RANGE, fLineRange );
   _fMinLineWidth = fLineRange[0];
   _fMaxLineWidth = fLineRange[1];   
   _fSelectedLineWidth = min( _fMaxLineWidth, _fMinLineWidth * 4.0f );

   glClearColor( 0.0f, 0.0f, 0.0f, 0.0f ); 
   glClear( GL_COLOR_BUFFER_BIT ); 
	glFlush( );

   // --- Done ---
   bRetCode = true;
//PIX_EXIT:
   return bRetCode;
}

void SamplerPane::RefreshSingle(void )
{			   
   makeCurrent( );	

   switch( _sPaneShowMode ) {
   case SamplerPaneShowFirst:
   case SamplerPaneShowSecond:
      RefreshTexture( );
      break;

   case SamplerPaneShowWiper: 
      RefreshWiperDouble( );
      break;

   case SamplerPaneShowNone: 
   default:
      RefreshClear( );
      break;
   }

   // draw index area

   switch( _sPaneType ) {
   case SamplerPaneSplitLeft:      
   case SamplerPaneSplitRight:  
      break;

   case SamplerPaneIndex:
      DrawIndexArea( );    
      break;

   default:
      goto PIX_EXIT;
      break;
   }

   swapBuffers( );

   // --- done ---
PIX_EXIT:
   return;
}

//
// wiper-stype line, two textures
//
void SamplerPane::RefreshWiperDouble( void )
{
   unsigned int uiImgTexture[2];
   sampler_window *pMain = (sampler_window*)GetMainWindow( );
   pixq_FlipPara *pFlip = GetFlipPara( );

   switch( _sPaneShowMode ) {
   case SamplerPaneShowWiper: 
      break;

   default:
      goto PIX_EXIT;
      break;
   }

   // check mode

   if( !pMain->CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }

   uiImgTexture[0] = GetColorModeTexture( true ); 
   uiImgTexture[1] = GetColorModeTexture( false ); 

   RefreshWiper_WON( uiImgTexture[0], uiImgTexture[1], _bWiperVertical,
      _nWiperX, _nWiperY, pFlip );

   // --- Done ---
PIX_EXIT:
   return;
}


void SamplerPane::RefreshClear( void ) 
{
   float fValue;

   glDisable( GL_DEPTH_TEST );
   glDisable( GL_CULL_FACE );
   glDisable( GL_LIGHTING );
   glDisable( GL_LIGHT0 );

   // clear the screen

   switch( _sPaneType ) {
   case SamplerPaneSplitLeft: 
   case SamplerPaneSplitRight: 
      fValue = 0.4f;
      glClearColor( fValue, fValue, fValue, 1.0f );
      break;
      
   case SamplerPaneIndex:
      fValue = 0.0f;
      glClearColor( fValue, fValue, fValue, 1.0f );
      break;
      
   default:
      fValue = 0.8f;
      glClearColor( fValue, fValue, fValue, 1.0f );
      break;
   }
   
   glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT ); 
			
   return;
}

//
// set /reset the flag to indicate that the texture is already created
//
void SamplerPane::SetColorModeTexture( bool bSource, // [i] source or derived image
                                    bool bSet ) // [i] set to true(loaded) or false
{
   short sDisplayColor = _sDisplayColor;

   int iSide = bSource ? 0 : 1;

   switch( sDisplayColor ) {
   case PixImageDisplayColorRgb:
      _PaneTexture.SetRgbTexture( iSide, bSet );
      break;

	case PixImageDisplayColorRed: 
      _PaneTexture.SetRedTexture( iSide, bSet );
      break;

	case PixImageDisplayColorGreen:
      _PaneTexture.SetGreenTexture( iSide, bSet );
      break;

   case PixImageDisplayColorBlue:
      _PaneTexture.SetBlueTexture( iSide, bSet );
      break;

   case PixImageDisplayColorPseudoRed:
      _PaneTexture.SetRedPseudoTexture( iSide, bSet );
      break;

   case PixImageDisplayColorPseudoGreen:
      _PaneTexture.SetGreenPseudoTexture( iSide, bSet );
      break;

   case PixImageDisplayColorPseudoBlue:
      _PaneTexture.SetBluePseudoTexture( iSide, bSet );
      break;
   }

   return;
}

unsigned int SamplerPane::GetColorModeTexture( void )
{
   sampler_window *pMain = (sampler_window*)GetMainWindow( );
   unsigned int uiImgTexture;

   if( !pMain->CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }

   switch( _sPaneType ) {
   case SamplerPaneIndex:  
      uiImgTexture = GetColorModeTexture( true ); 
      goto PIX_EXIT;
      break;

   default:
      break;
   }

   switch( _sPaneType ) {
   case SamplerPaneSplitLeft:        
      uiImgTexture = GetColorModeTexture( true ); 
      break;
   
   case SamplerPaneSplitRight:        
      switch( _sPaneShowMode ) {
      case SamplerPaneShowFirst:
         uiImgTexture = GetColorModeTexture( true ); 
         break;

      case SamplerPaneShowSecond:
         uiImgTexture = GetColorModeTexture( false ); 
         break;
   
      default:
         uiImgTexture = GetColorModeTexture( true );
         goto PIX_EXIT;
      }
      break;
   }

PIX_EXIT:
   return uiImgTexture;
}

//
// get the textue id according to the display color mode
//
unsigned int SamplerPane::GetColorModeTexture( bool bSource ) // [i] source or derived image
{
   unsigned int uiTexture;
   short sDisplayColor = _sDisplayColor;

   int iSide = bSource ? 0 : 1;

   switch( sDisplayColor ) {
   case PixImageDisplayColorRgb:
      uiTexture = _PaneTexture.GetRgbTexture( iSide );
      break;

	case PixImageDisplayColorRed: 
      uiTexture = _PaneTexture.GetRedTexture( iSide );
      break;

	case PixImageDisplayColorGreen:
      uiTexture = _PaneTexture.GetGrnTexture( iSide );
      break;

   case PixImageDisplayColorBlue:
      uiTexture = _PaneTexture.GetBluTexture( iSide );
      break;

   case PixImageDisplayColorPseudoRed:
      uiTexture = _PaneTexture.GetRedPseudoTexture( iSide );
      break;

   case PixImageDisplayColorPseudoGreen:
      uiTexture = _PaneTexture.GetGrnPseudoTexture( iSide );
      break;

   case PixImageDisplayColorPseudoBlue:
      uiTexture = _PaneTexture.GetBluPseudoTexture( iSide );
      break;
   }

   return uiTexture;
}

void SamplerPane::DrawIndexArea( void )
{
   sampler_window *pMain = (sampler_window*)GetMainWindow( );
   pixq_FlipPara *pFlip = GetFlipPara( ); 
   pixq_FlipPara *pIndexFlip = pMain->GetSplitPara( ); 
   double dScreenX0, dScreenX1, dScreenY0, dScreenY1;
   double dTexX0, dTexX1, dTexY0, dTexY1;

   // *** draw source area on index ***

   glDisable( GL_TEXTURE_RECTANGLE_ARB );

   glDisable( GL_LIGHTING ); // to show lines in color
   glDisable( GL_LIGHT0 );
   glEnable( GL_DEPTH_TEST );

   glLineWidth( _fMinLineWidth );  
   glColor3f( 1.0f, 1.0f, 0.0f );

   dTexX0 = pIndexFlip->GetTexCooX( 0 );
   dTexX1 = pIndexFlip->GetTexCooX( 1 );
   dTexY0 = pIndexFlip->GetTexCooY( 0 );
   dTexY1 = pIndexFlip->GetTexCooY( 1 );
   
   pFlip->TexToScreenCoo( dTexX0, dTexY0, &dScreenX0, &dScreenY0 );
   pFlip->TexToScreenCoo( dTexX1, dTexY1, &dScreenX1, &dScreenY1 );
   glBegin( GL_LINE_STRIP );
      glVertex3d( dScreenX0, dScreenY0, 0.1 );
      glVertex3d( dScreenX1, dScreenY0, 0.1 );
      glVertex3d( dScreenX1, dScreenY1, 0.1 );
      glVertex3d( dScreenX0, dScreenY1, 0.1 );
      glVertex3d( dScreenX0, dScreenY0, 0.1 );
   glEnd( );    
   
   // label test
   
#ifdef _DEBUG2
   QFont fn = font( );

   QString strName = fn.rawName( );
   QString strFamily = fn.family( );

   fn.setBold( true );
   fn.setPointSize( 12 );

   fn.setRawName( "Ariel" );
   fn.setFamily( "Ariel" );
   setFont( fn );
 
   QString str1;
   QString str2;
   
   str1 = "A simple OpenGL framebuffer object example.";
   str2.sprintf( "This is Frame %05d-%05d-%05d", iFirstFrame+1, iCurrentFrame+1,
      iLastFrame+1 );

   qglColor(Qt::blue);
   renderText((dScreenX0+dScreenX1)/2, (dScreenY0+3.0*dScreenY1)/4.0, 0.0, str1 );
    
   qglColor(Qt::red);
   renderText((dScreenX0+dScreenX1)/2, (3.0*dScreenY0+dScreenY1)/4.0, 0.0, str2 );
#endif // _DEBUG2

   // --- done ---
//PIX_EXIT:
   return;
}

//
// dispklay single(first or second texture) on the pane
//
void SamplerPane::RefreshTexture( void )
{
   sampler_window *pMain = (sampler_window*)GetMainWindow( );
   pixq_FlipPara *pFlip = GetFlipPara( ); 

	unsigned int uiImgTexture; 
   
   if( !pMain->CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }

   // select texture
   
   uiImgTexture = GetColorModeTexture( );   
   RefreshTexture_WON( uiImgTexture, pFlip );

   // --- DONE ---
PIX_EXIT:

   return;
}
