#pragma once

#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

namespace Ui {
   class sampler_window;
}

class SamplerPane;

class ImageCtrl;
class SamplerMonitor;
class ImageSplitter;
class ImageSideSplitter;

class ImageSideLabel;
class SamplerDock;

class sampler_window : public QMainWindow, protected QOpenGLFunctions
{
   Q_OBJECT

public:
   // left mouse working mode
   enum {
      // do nothing
      MouseLeftClickNone = 0, 
   } MouseLeftClickWorkMode;


   // *** DO NOT CHANGE THESE NUMBERS ***
   // Menu Action Stratus Mode
   // This is encedded to QAction Items
   enum {
      // always enabled
      MouseActionItemEnabled = 0, 
      // enabled only when image is loaded
      MouseActionItemSingleDouble = 1, 
      // always disnabled
      MouseActionItemDisabled = 2, 
   } MouseActionSelectionMode;

public:
    explicit sampler_window(QWidget *parent = 0);
    ~sampler_window();

private:
    Ui::sampler_window *ui;

public:
   void AddMenuAction( QAction *pAction, int iSelectMode );

   void CreateMain( void );
   
   void CreateActions( void );
   void CreateToolBars( void );

   void SetImageSplitterWidth( void );
   void SetImageSideSplitterHeight( int iSide );

public slots:
    void ImageSplitterMoved( int pos, int index  );
    void ImageSideSplitterMoved( int pos, int index  );

private:
   ImageSplitter *_ImageSplitter;

   ImageSideSplitter *_ImageSideSplitter[2];

   // status bar
   QLabel *_statusLabel[3];
   QProgressBar  *_statusProgress;
   
   // actions list

   QList<QAction*> _list_menu_actions;

private:

   // *** opengl screen ***

   SamplerPane *_Image_Pane[2];  
   ImageSideLabel *_Image_Label[2];

   // index image

   SamplerPane *_Index_Pane; 
   ImageCtrl *_Image_Props;
   SamplerMonitor *_Sampler_Monitor;

   // parameters and data in 3D depth simulator
    
   SamplerDock *_Dock_Index; 
   SamplerDock *_Dock_Monitor;
   SamplerDock *_Dock_Props;
  
   //
   // *** copied from WontonLeDoc
   //

   bool _bInitialized;

   //
   // *** image data ***
   //

   pixq_ImageSingleSet *_pImageDataSet;

   // --- OpenGL texture for left and right image ---
   pixq_DepthTexture *_pImgTexture[2];

   // --- geometric parameters of page flipping ---
   pixq_FlipPara *_SplitPara; 
   pixq_FlipPara *_IndexPara; // index panes 

   // --- environment ---
   pixq_Properties *_pDepthEnv;
   
   // input image matrix
   pix_ImageMatrix _ImageInMtx[3];

   // derive image matrix 
   pix_ImageMatrix _ImageDrvMtx[3];
    
   // setting
   static QString _strOrganisation;
   static QString _strApplication;

   // left mouse click work mode, one of MouseLeftClickWorkMode;
   short _sLeftMouseMode;

   // type of second(derived) image, one of SamplerDerivedImageType
   short _sDerivedImage;

   // buffer to transfer matrix data to opengl texture
   pixq_TextureBuffer *_MainTexBuffer;
   
private slots:

   // *** file menu ***

   void on_action_file_select_files_triggered();
   void on_action_file_select_sequence_triggered();
   void on_action_file_properties_triggered();
   void on_action_file_list_supported_formats_triggered();

   void on_action_file_exit_triggered();

   // *** Basic menu ***

   void on_action_basic_original_triggered();
   void on_action_basic_grayscale_triggered();   
   void on_action_basic_revert_triggered();

   void on_action_basic_dft_value_triggered();
   void on_action_basic_dft_filter_shape_triggered();
   void on_action_basic_dft_filtered_image_triggered();

   // *** Data menu ***

   void on_action_data_statistics_triggered();

   // *** View menu ***

   void on_action_view_first_image_triggered();
   void on_action_view_second_image_triggered();
   void on_action_view_wiper_triggered();

   void on_action_view_rgb_triggered();
   void on_action_view_red_channel_triggered();
   void on_action_view_green_channel_triggered();
   void on_action_view_blue_channel_triggered();

   // *** Frame menu ***

   void on_action_frame_next_triggered();
   void on_action_frame_previous_triggered();
   void on_action_frame_first_triggered();
   void on_action_frame_last_triggered();
   void on_action_frame_reload_triggered();
   void on_action_frame_select_frame_triggered();

   // *** Help menu ***

   void on_action_help_about_triggered();

protected:
   void closeEvent( QCloseEvent *eve );
   void showEvent( QShowEvent *eve );
   void resizeEvent( QResizeEvent *eve );

public:
   QString strGetOrganisation( void ) const { return _strOrganisation; }
   QString strGetApplication( void ) const { return _strApplication; }

   void RefreshClear( void );
   void OpenGlHigherThanTwo( void );

   void InitData( void );
   void DeInitData( void );

   void ResetMain( void );

   // image load mode
  
   void SetFrameStatusBar( void );

   //
   // utility functions
   //
   void RestoreWindowPosition( void );
   void StoreWindowPosition( void );
   void fixSamplerPanes( void );

   bool SelectFileList( void );
   bool SelectSingleSequence( void );

   bool SetProperties( void );
   void DisplayFrameInfo( void );

   // select new frame, load the image and apply the current image conversion
   bool SelectFrame( int iNewFrame );

   // load single image from file and set it to the left pane
   bool CreateSingleBitmap( void );

   void SetPanesShowMode( short sSecondPaneMode );
   void ResetPanesShowMode( void );

   short GetPaneShowMode( int iSide );

   // load image into three(rgb) unsigned short matrices

   bool LoadFrame( const QString strFile, 
      pix_ImageMatrix *usRed,
      pix_ImageMatrix *usGrn,
      pix_ImageMatrix *usBlu );

   // create image texture for given pane from given image matrix(0/1/2)
   bool CreateImageTexture( SamplerPane *pPane, bool bSource );

   // derive some image from the loaded single image
   // and set the result in second matrix
   bool DeriveFromSingleBitmap( short sSecond );

   // create texture on the right pane from the derived image matrices

   bool CreateLoadedTexture( void );
   bool CreateDerivedTexture( void );
   
   bool CreateSecondOriginal( void );
   bool CreateSecondGrayscale( void );
   bool CreateSecondRevert( void );

   bool CreateSecondDftImage( void );
   bool CreateSecondDftShape( void );
   bool CreateSecondDftFiltered( void );

   // reallocate second/third image matrixces for three colors
   bool AllocDerivedMatrix( void );

   void DisplayMessage( const char *szFormat, ... );
   void DisplayMessage( const QString strMessage );
   void DisplayMessage( const string strMessage );

   // get output image file for the current frame

   bool CheckImagePowerOfTwo( void );

   bool GetStatistics( void );

   // create gray scale image from rgb matrix in float matrix
   bool CreateGrayMatrix( pixq_Matrix<float> *fGray );

   float fGetRed( int iRow, int iCol );
   float fGetGreen( int iRow, int iCol );
   float fGetBlue( int iRow, int iCol );

   // Create grayscale image from (any) float matrix in RGB image three matrices
   bool FloatMatrixGrayImage( pixq_Matrix<float> *fMtx );

   bool bSetAll( pixq_Matrix<float> *fPix );   

   bool ApplyFilterImage( pixq_Matrix<float> *fReal, pixq_Matrix<float> *fImag,
      pixq_Matrix<float> *fFilter );
   
   // image is successfully loaded in the panes
   // set to false, while the image is being loaded/processed to avoid mouse event on the image pane!
   bool _bImageLoaded;

public:
   void SetImageLoaded( bool bLoaded ) { _bImageLoaded = bLoaded; }
   bool GetImageLoaded( void ) { return _bImageLoaded; }

public:

   short GetDerivedImage( void ) { return _sDerivedImage; }
   void SetDerivedImage( short sDerivedImage );

   void StoreEnv( void );

   // redo the current image converson to the current frame
   bool SelectFrame( void );

   void SetMenuState( void );

   void GetColor( int iSide, int iMouseX, int iMouseY );

   bool ValidPaneDisplayMode( void );
  

   pixq_ImageSingleSet *GetImageData( void ) { return _pImageDataSet; } 

   ImageSideLabel *GetImageLabel( int iSide ) { return _Image_Label[iSide]; }
   SamplerMonitor *GetMonitorPane( void ) { return _Sampler_Monitor; }

   bool GetImageFile( int iFrame, QString *strFile );


   // get texture ID for the side/frame
   unsigned int GetTexture( int iSide, int iFrame );

   bool ShiftFrame( int iShift );
   bool FirstFrame( void );
   bool LastFrame( void );
   bool ReloadFrame( void );
   
   void SetDisplayColor( short sDisplayColor );
   short GetDisplayColor( void );
   
   void RefreshPanes( void );

   void SetPanesCursor( QCursor cur );

   // create derived image from the single or double images
   bool CreateDerivedBitmap( short sSecond );

   // handle key input on pane
   bool ProcessKeyEvent( short sPane, int iKey );
   
   bool ProcessWheelEvent( short sPane, int iDelta );
   bool ProcessScrollEvent( short sPane, int iX, int iY );

   pixq_FlipPara *GetFlipPara( short sPane ); 

   // *** data ***

   pixq_Properties *GetEnv( void ) { return _pDepthEnv; }
   pixq_FlipPara *GetSplitPara( void ) { return _SplitPara; }    
   pixq_FlipPara *GetIndexPara( void ) { return _IndexPara; }  
   
   pixq_TextureBuffer *GetTextureBuffer( void ) { return _MainTexBuffer; }
   
   // returns true if some image or sequence is selected
   bool CheckLoadSequence( void );
   
   // mouse mode
   short sGetLeftMouseMode( void ) { return _sLeftMouseMode; }
   void SetLeftMouseMode( short sMode );
   void ResetLeftMouseMode( void );

   void ClearRectificationTags( void );
   
private://
   void ShowImagePropPage( int iPage );

   public:
   void HideImageProp( void );

private:
    pixq_Version Version( void ); 
  
private:
   // last mouse position
   int _nLastMouseY; 


public:
   void SetLastMousePos( int iY ) { _nLastMouseY = iY; }
   int GetLastMousePos( void ) { return _nLastMouseY; }

private:

};
