/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.maintenance;

import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.Schedule;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.maintenance.bean.MaintenanceInfoDataImp;
import com.clustercontrol.maintenance.bean.ScheduleInfo;
import com.clustercontrol.maintenance.ejb.session.MaintenanceController;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.ejb.DuplicateKeyException;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.NotifyUtil;
import jp.co.intellilink.hinemos.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMaintenance {
    private static Log log = LogFactory.getLog(ImportMaintenance.class);
    private ArrayList maintenanceList = null;
    private ArrayList<ArrayList<String>> monitorInfos = null;

    public void importMaintenance() {
        log.info((Object)Messages.getMsg("Maintenance.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/MAINTENANCE.csv");
        this.maintenanceList = this.getMaintenanceList();
        for (ArrayList<String> arrayList : this.monitorInfos) {
            MaintenanceInfoDataImp maintenanceInfoDataImp = this.createMaintenanceInfo(arrayList);
            ScheduleInfo scheduleInfo = this.createScheduleInfo(arrayList);
            this.registerMaintenanceInfo(maintenanceInfoDataImp, scheduleInfo);
        }
        log.info((Object)Messages.getMsg("Maintenance.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    public MaintenanceInfoDataImp createMaintenanceInfo(ArrayList<String> arrayList) {
        String[] stringArray;
        Object[] objectArray;
        MaintenanceInfoDataImp maintenanceInfoDataImp = new MaintenanceInfoDataImp();
        String string = CheckString.checkLength(arrayList.get(0), 64);
        if (!string.equals(arrayList.get(0))) {
            objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"maintenance.id"), "64"};
            log.error((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
            System.exit(20);
        }
        maintenanceInfoDataImp.setMaintenance_id(string);
        objectArray = CheckString.checkLength(arrayList.get(1), 120);
        if (!objectArray.equals(arrayList.get(1))) {
            stringArray = new String[]{com.clustercontrol.util.Messages.getString((String)"description"), "120"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", stringArray));
        }
        maintenanceInfoDataImp.setDescription((String)objectArray);
        if (arrayList.get(2).equals(com.clustercontrol.util.Messages.getString((String)"maintenance.delete_event_log"))) {
            maintenanceInfoDataImp.setType_id("DELETE_EVENT_LOG");
        } else if (arrayList.get(2).equals(com.clustercontrol.util.Messages.getString((String)"maintenance.delete_job_history"))) {
            maintenanceInfoDataImp.setType_id("DELETE_JOB_HISTORY");
        } else if (arrayList.get(2).equals(com.clustercontrol.util.Messages.getString((String)"maintenance.delete_crun_history"))) {
            maintenanceInfoDataImp.setType_id("DELETE_CRUN_HISTORY");
        }
        if (arrayList.get(3).equals(com.clustercontrol.util.Messages.getString((String)"maintenance.keep.one_month"))) {
            maintenanceInfoDataImp.setKeep_id("ONE_MONTH");
        } else if (arrayList.get(3).equals(com.clustercontrol.util.Messages.getString((String)"maintenance.keep.one_week"))) {
            maintenanceInfoDataImp.setKeep_id("ONE_WEEK");
        } else if (arrayList.get(3).equals(com.clustercontrol.util.Messages.getString((String)"maintenance.keep.one_year"))) {
            maintenanceInfoDataImp.setKeep_id("ONE_YEAR");
        } else if (arrayList.get(3).equals(com.clustercontrol.util.Messages.getString((String)"maintenance.keep.six_months"))) {
            maintenanceInfoDataImp.setKeep_id("SIX_MONTHS");
        } else if (arrayList.get(3).equals(com.clustercontrol.util.Messages.getString((String)"maintenance.keep.three_months"))) {
            maintenanceInfoDataImp.setKeep_id("THREE_MONTHS");
        } else if (arrayList.get(3).equals(com.clustercontrol.util.Messages.getString((String)"maintenance.keep.two_months"))) {
            maintenanceInfoDataImp.setKeep_id("TWO_MONTHS");
        } else if (arrayList.get(3).equals(com.clustercontrol.util.Messages.getString((String)"maintenance.keep.two_weeks"))) {
            maintenanceInfoDataImp.setKeep_id("TWO_WEEKS");
        }
        maintenanceInfoDataImp.setCalendar_id(arrayList.get(4));
        stringArray = this.createSchedule(arrayList.subList(5, 13));
        maintenanceInfoDataImp.setSchedule_date(new Timestamp(stringArray.getDate().getTime()));
        this.createNotify(arrayList.subList(13, 18), maintenanceInfoDataImp);
        String string2 = CheckString.checkLength(arrayList.get(18), 64);
        if (!string2.equals(arrayList.get(18))) {
            Object[] objectArray2 = new String[]{com.clustercontrol.util.Messages.getString((String)"application"), "64"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray2));
        }
        maintenanceInfoDataImp.setApplication(string2);
        maintenanceInfoDataImp.setValid_flg(Integer.valueOf(ValidConstant.stringToType((String)arrayList.get(19))));
        return maintenanceInfoDataImp;
    }

    public ScheduleInfo createScheduleInfo(ArrayList<String> arrayList) {
        ScheduleInfo scheduleInfo = new ScheduleInfo();
        scheduleInfo.setId(arrayList.get(0));
        scheduleInfo.setJobId(arrayList.get(0));
        scheduleInfo.setName(arrayList.get(1));
        scheduleInfo.setJobName(arrayList.get(1));
        scheduleInfo.setCalendarId(arrayList.get(4));
        Schedule schedule = this.createSchedule(arrayList.subList(5, 13));
        scheduleInfo.setSchedule(schedule);
        scheduleInfo.setValid(ValidConstant.stringToType((String)arrayList.get(19)));
        return scheduleInfo;
    }

    protected void createNotify(List<String> list, MaintenanceInfoDataImp maintenanceInfoDataImp) {
        maintenanceInfoDataImp.setNotifyGroupId(NotifyRelationInfo.createNotifyGroupIdMaintenance((String)maintenanceInfoDataImp.getMaintenance_id()));
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (int i = 0; i < 5; ++i) {
            Object[] objectArray;
            if (!(list.get(i) instanceof String) || list.get(i).length() <= 0) continue;
            if (!NotifyUtil.findNotifyId(list.get(i))) {
                objectArray = new String[]{maintenanceInfoDataImp.getMaintenance_id(), list.get(i)};
                log.error((Object)Messages.getMsg("ImportTool.Notify.1", objectArray));
                System.exit(20);
            }
            objectArray = new NotifyRelationInfo();
            objectArray.setNotifyId(list.get(i));
            objectArray.setNotifyGroupId(maintenanceInfoDataImp.getNotifyGroupId());
            objectArray.setNotifyFlg(Integer.valueOf(0));
            if (i == 0) {
                objectArray.setNotifyType(Integer.valueOf(0));
            } else if (i == 1) {
                objectArray.setNotifyType(Integer.valueOf(1));
            } else if (i == 2) {
                objectArray.setNotifyType(Integer.valueOf(2));
            } else if (i == 3) {
                objectArray.setNotifyType(Integer.valueOf(3));
            } else if (i == 4) {
                objectArray.setNotifyType(Integer.valueOf(4));
            }
            arrayList.add(objectArray);
        }
        maintenanceInfoDataImp.setNotifyId(arrayList);
    }

    protected Schedule createSchedule(List<String> list) {
        Schedule schedule = new Schedule();
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        Integer n5 = null;
        if (list.get(0).equals(com.clustercontrol.util.Messages.getString((String)"time"))) {
            if (list.get(1).length() > 0) {
                n = Integer.parseInt(list.get(1));
            }
            if (list.get(2).length() > 0) {
                n2 = Integer.parseInt(list.get(2));
            }
            if (list.get(3).length() > 0) {
                n3 = Integer.parseInt(list.get(3));
            }
            if (list.get(4).length() > 0) {
                n4 = Integer.parseInt(list.get(4));
            }
            if (list.get(1).length() == 0 && list.get(2).length() == 0 && list.get(3).length() == 0) {
                schedule.setType(3);
            } else if (list.get(1).length() == 0 && list.get(2).length() == 0) {
                schedule.setType(2);
            } else if (list.get(1).length() == 0) {
                schedule.setType(1);
            } else {
                schedule.setType(0);
            }
            if (!(n instanceof Integer) && schedule.getType() == 0) {
                log.error((Object)com.clustercontrol.util.Messages.getString((String)"message.job.26"));
                return null;
            }
            if (!(n2 instanceof Integer || schedule.getType() != 0 && schedule.getType() != 1)) {
                log.error((Object)com.clustercontrol.util.Messages.getString((String)"message.job.27"));
                return null;
            }
            if (!(n3 instanceof Integer || schedule.getType() != 0 && schedule.getType() != 1 && schedule.getType() != 2)) {
                log.error((Object)com.clustercontrol.util.Messages.getString((String)"message.job.28"));
                return null;
            }
            if (!(n4 instanceof Integer)) {
                log.error((Object)com.clustercontrol.util.Messages.getString((String)"message.job.29"));
                return null;
            }
        } else {
            schedule.setType(4);
            if (list.get(5).length() > 0) {
                n5 = new Integer(DayOfWeekConstant.stringToType((String)list.get(5)));
            }
            if (list.get(6).length() > 0) {
                n3 = Integer.parseInt(list.get(6));
            }
            if (list.get(7).length() > 0) {
                n4 = Integer.parseInt(list.get(7));
            }
            if (!(n5 instanceof Integer)) {
                log.error((Object)com.clustercontrol.util.Messages.getString((String)"message.job.37"));
                return null;
            }
            if (!(n3 instanceof Integer)) {
                log.error((Object)com.clustercontrol.util.Messages.getString((String)"message.job.28"));
                return null;
            }
            if (!(n4 instanceof Integer)) {
                log.error((Object)com.clustercontrol.util.Messages.getString((String)"message.job.29"));
                return null;
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 0);
        if (n instanceof Integer) {
            calendar.set(2, n - 1);
        }
        if (n2 instanceof Integer) {
            calendar.set(5, n2);
        }
        if (n3 instanceof Integer) {
            calendar.set(11, n3);
        }
        if (n5 instanceof Integer) {
            calendar.set(7, n5);
            schedule.setDayOfWeek(n5.intValue());
        }
        calendar.set(12, n4);
        calendar.set(13, 0);
        schedule.setDate(calendar.getTime());
        return schedule;
    }

    protected void registerMaintenanceInfo(MaintenanceInfoDataImp maintenanceInfoDataImp, ScheduleInfo scheduleInfo) {
        MaintenanceController maintenanceController = EjbConnectionManager.getConnectionManager().getMaintenanceController();
        try {
            ArrayList arrayList = this.checkMaintenanceList(maintenanceInfoDataImp.getMaintenance_id());
            if (arrayList instanceof ArrayList) {
                Date date = (Date)arrayList.get(8);
                String string = (String)arrayList.get(7);
                maintenanceInfoDataImp.setRegDate(new Timestamp(date.getTime()));
                maintenanceInfoDataImp.setRegUser(string);
                scheduleInfo.setCreateTime(date);
                scheduleInfo.setCreateUser(string);
                Object[] objectArray = new Object[]{maintenanceInfoDataImp.getMaintenance_id()};
                log.info((Object)(Messages.getMsg("MaintenanceID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                maintenanceController.modifyMaintenance(maintenanceInfoDataImp, scheduleInfo);
            } else {
                Object[] objectArray = new Object[]{maintenanceInfoDataImp.getMaintenance_id()};
                log.info((Object)(Messages.getMsg("MaintenanceID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                maintenanceController.addMaintenance(maintenanceInfoDataImp, scheduleInfo);
            }
        }
        catch (DuplicateKeyException duplicateKeyException) {
            Object[] objectArray = new String[]{maintenanceInfoDataImp.getMaintenance_id()};
            log.error((Object)Messages.getMsg("ImportTool.Common.1", objectArray));
            System.exit(20);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList checkMaintenanceList(String string) {
        if (this.maintenanceList instanceof ArrayList) {
            for (ArrayList arrayList : this.maintenanceList) {
                String string2 = (String)arrayList.get(0);
                if (string2.compareTo(string) != 0) continue;
                return arrayList;
            }
        }
        return null;
    }

    protected ArrayList getMaintenanceList() {
        MaintenanceController maintenanceController = EjbConnectionManager.getConnectionManager().getMaintenanceController();
        ArrayList arrayList = null;
        try {
            arrayList = maintenanceController.getMaintenanceList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

