/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.master.mib;

import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapController;
import java.io.IOException;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import jp.co.intellilink.hinemos.importtool.master.mib.EntityFactory;
import jp.co.intellilink.hinemos.importtool.master.mib.ResultSubject;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import net.percederberg.mibble.MibLoaderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMib {
    protected ResultSubject subject = null;

    public void importMib(String[] stringArray) {
        MonitorSnmpTrapController monitorSnmpTrapController = EjbConnectionManager.getConnectionManager().getMonitorSnmpTrapController();
        this.subject = new ResultSubject(stringArray);
        EntityFactory entityFactory = new EntityFactory();
        for (int i = 0; i < this.subject.getFilePathSize(); ++i) {
            boolean bl = false;
            try {
                entityFactory.create(this.subject.getFilePath(i));
                bl = true;
            }
            catch (IOException iOException) {
                this.subject.ioError(i);
            }
            catch (MibLoaderException mibLoaderException) {
                System.out.print("\n");
                System.out.print("************** Exception : " + this.subject.getFilePath(i) + " ****************************\n");
                System.out.print(this.subject.getFilePath(i));
                mibLoaderException.getLog().printTo(System.out);
                this.subject.noDependent(i);
            }
            try {
                if (!bl) continue;
                if (entityFactory.getTrapsData().size() > 0) {
                    monitorSnmpTrapController.addMibMaster(entityFactory.getMibData());
                    for (SnmpTrapMasterInfo snmpTrapMasterInfo : entityFactory.getTrapsData()) {
                        monitorSnmpTrapController.addOidMaster(snmpTrapMasterInfo);
                    }
                    this.subject.success(i);
                    continue;
                }
                this.subject.noTrap(i);
                continue;
            }
            catch (CreateException createException) {
                if (createException instanceof DuplicateKeyException) {
                    this.subject.duplicate(i);
                    continue;
                }
                this.subject.error(i);
                continue;
            }
            catch (Exception exception) {
                this.subject.error(i);
            }
        }
        String string = this.getResult();
        System.out.print(string);
    }

    protected String getResult() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("************** Summay ****************************\n\n");
        if (this.subject.isConnectError()) {
            stringBuilder.append(Messages.getMsg("ImportTool.Mib.9") + "\n\n");
        } else if (this.subject.isAccessError()) {
            stringBuilder.append(Messages.getMsg("ImportTool.Mib.10") + "\n\n");
        } else if (this.subject.isCancel()) {
            stringBuilder.append(Messages.getMsg("ImportTool.Mib.7") + "\n\n");
        }
        int n = this.subject.getSuccessCount();
        int n2 = this.subject.getDuplicateCount() + this.subject.getNoDependentCount() + this.subject.getNoTrapCount();
        int n3 = this.subject.getErrorCount() + this.subject.getIoErrorCount();
        stringBuilder.append(Messages.getMsg("successful") + " : " + n + "\n");
        stringBuilder.append(Messages.getMsg("failed") + " : " + n3 + "\n\n");
        stringBuilder.append(Messages.getMsg("warning") + " : " + n2 + "\n");
        if (n > 0) {
            stringBuilder.append("-------------- " + Messages.getMsg("successful") + " ----------------------------\n\n");
            stringBuilder.append(this.getFileListMessages(Messages.getMsg("ImportTool.Mib.6"), this.subject.getSuccessList()));
        }
        if (n3 > 0) {
            stringBuilder.append("-------------- " + Messages.getMsg("failed") + " ----------------------------\n\n");
            stringBuilder.append(this.getFileListMessages(Messages.getMsg("ImportTool.Mib.2"), this.subject.getIoErrorList()));
            stringBuilder.append(this.getFileListMessages(Messages.getMsg("ImportTool.Mib.4"), this.subject.getErrorList()));
        }
        if (n2 > 0) {
            stringBuilder.append("-------------- " + Messages.getMsg("warning") + " ----------------------------\n\n");
            stringBuilder.append(this.getFileListMessages(Messages.getMsg("ImportTool.Mib.5"), this.subject.getDuplicateList()));
            stringBuilder.append(this.getFileListMessages(Messages.getMsg("ImportTool.Mib.8"), this.subject.getNoTrapList()));
            stringBuilder.append(this.getFileListMessages(Messages.getMsg("ImportTool.Mib.3"), this.subject.getNoDependentList()));
        }
        return stringBuilder.toString();
    }

    protected String getFileListMessages(String string, List<String> list) {
        if (list.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" " + string + "\n");
            for (String string2 : list) {
                stringBuilder.append(" " + string2 + "\n");
            }
            stringBuilder.append("\n");
            return stringBuilder.toString();
        }
        return "";
    }
}

