/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.monitor;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.http.bean.MonitorHttpInfo;
import com.clustercontrol.http.ejb.session.MonitorHttpController;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorNumeric;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMonitorHttp
extends ExportMonitorNumeric {
    private static Log log = LogFactory.getLog(ExportMonitorHttp.class);

    public ExportMonitorHttp() {
        super(2);
    }

    public void exportHttp() {
        log.info((Object)Messages.getMsg("Http.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getHttpList();
        if (arrayList2 instanceof ArrayList) {
            for (Cloneable cloneable : arrayList2) {
                int n = MonitorTypeConstant.stringToType((String)((String)((ArrayList)cloneable).get(3)));
                if (n != 1) continue;
                Object[] objectArray = new Object[]{(String)((ArrayList)cloneable).get(0)};
                log.info((Object)Messages.getMsg("MonitorID", objectArray));
                MonitorInfo monitorInfo = this.getHttp((String)((ArrayList)cloneable).get(0), n);
                arrayList.add(this.createCsvFormat(monitorInfo));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        Object object = "";
        if (Config.getConfig("file.timestamp").equalsIgnoreCase("on")) {
            Cloneable cloneable;
            cloneable = new SimpleDateFormat("yyyyMMdd_HHmmss");
            object = "_" + ((DateFormat)cloneable).format(new Date());
        }
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/HTTP" + (String)object + ".csv", arrayList);
        log.info((Object)Messages.getMsg("Http.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    @Override
    public ArrayList<String> createCsvFormat(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.createMonitorBase(monitorInfo));
        arrayList.addAll(this.createMonitorRule(monitorInfo));
        arrayList.addAll(this.createMonitorInfo(monitorInfo));
        arrayList.addAll(this.createMonitorJudgement(monitorInfo));
        arrayList.addAll(this.createMonitorNotify(monitorInfo));
        if (monitorInfo.getApplication() != null) {
            arrayList.add(monitorInfo.getApplication());
        } else {
            arrayList.add("");
        }
        arrayList.add(ValidConstant.typeToString((int)monitorInfo.getValid()));
        return arrayList;
    }

    @Override
    public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        MonitorHttpInfo monitorHttpInfo = (MonitorHttpInfo)monitorInfo.getCheckInfo();
        if (monitorHttpInfo == null) {
            monitorHttpInfo = new MonitorHttpInfo();
        }
        if (monitorHttpInfo.getRequestUrl() != null) {
            arrayList.add(monitorHttpInfo.getRequestUrl());
        } else {
            arrayList.add("");
        }
        arrayList.add(String.valueOf(monitorHttpInfo.getTimeout()));
        return arrayList;
    }

    protected MonitorInfo getHttp(String string, int n) {
        MonitorHttpController monitorHttpController = EjbConnectionManager.getConnectionManager().getMonitorHttpController();
        MonitorInfo monitorInfo = null;
        try {
            monitorInfo = monitorHttpController.getHttpInfo(string, n);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return monitorInfo;
    }

    protected ArrayList getHttpList() {
        MonitorHttpController monitorHttpController = EjbConnectionManager.getConnectionManager().getMonitorHttpController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorHttpController.getHttpList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

