/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.export.conf.monitor;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.IntegerListComparator;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.sql.bean.MonitorSqlInfo;
import com.clustercontrol.sql.ejb.session.MonitorSqlController;

/**
 * SQL監視情報を取得するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ExportMonitorSqlString extends ExportMonitorString{

	// ログ出力
	private static Log log = LogFactory.getLog(ExportMonitorSqlString.class);

	/**
	 * SQL監視情報をExportする。<br>
	 */
	public void exportSql() {
		log.info(Messages.getMsg("Sql.Start", new String[]{Messages.getMsg("ExportTool.Export")}));

		//CSV出力配列を用意
		ArrayList<ArrayList<String>> csvMainOutput = new ArrayList<ArrayList<String>>();
		ArrayList<ArrayList<String>> csvRuleOutput = new ArrayList<ArrayList<String>>();

		//監視項目リスト取得
		ArrayList idList = getSnmpList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();

				int monitorType = MonitorTypeConstant.stringToType((String)line.get(3));
				if(monitorType == MonitorTypeConstant.TYPE_STRING){
					Object[] args = {(String)line.get(0)};
					log.info(Messages.getMsg("MonitorID", args));

					MonitorInfo info = getSnmp((String)line.get(0), monitorType);
					csvMainOutput.add(createCsvFormat(info));
					csvRuleOutput.addAll(createMonitorJudgement(info));
				}
			}

			//監視項目IDでソート
			Collections.sort(csvMainOutput, new StringListComparator(0));

			//監視項目IDと順序でソート
			Collections.sort(csvRuleOutput, new IntegerListComparator(1));
			Collections.sort(csvRuleOutput, new StringListComparator(0));
		}

		String timestamp = "";
		if(Config.getConfig("file.timestamp").equalsIgnoreCase("on")){
			SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");
			timestamp = "_" + format.format(new Date());
		}
		WriteCsvFile.writeCsvFile(
				Config.getConfig("Export.Dir") + "/SQL_STR" + timestamp + ".csv", 
				csvMainOutput);

		WriteCsvFile.writeCsvFile(
				Config.getConfig("Export.Dir") + "/SQL_STR_RULE" + timestamp + ".csv", 
				csvRuleOutput);

		log.info(Messages.getMsg("Sql.End", new String[]{Messages.getMsg("ExportTool.Export")}));
	}

	/**
	 * SQL監視情報をExportする。<br>
	 * 
	 * @param monitorInfo SQL監視情報
	 * @return CSVフォーマット文字列
	 */
	@Override
	public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
		ArrayList<String> csvFormat = new ArrayList<String>();

		MonitorSqlInfo sqlInfo = (MonitorSqlInfo)monitorInfo.getCheckInfo();
		if(sqlInfo == null){
			sqlInfo = new MonitorSqlInfo();
		}
		//接続先URL
		if (sqlInfo.getConnectionUrl() != null)
			csvFormat.add(sqlInfo.getConnectionUrl());
		else
			csvFormat.add("");
		//接続先DB
		if (sqlInfo.getJdbcDriver() != null){
			List<List<String>> list = JdbcDriverUtil.getJdbcDriver();
			for(int i = 0; i < list.size(); i++){
				List<String> driver = list.get(i);
				String className = (String)driver.get(1);
				if(className.equals(sqlInfo.getJdbcDriver())){
					csvFormat.add((String)driver.get(0));
					break;
				}
			}
		}
		else
			csvFormat.add("");
		//ユーザID
		if (sqlInfo.getUser() != null)
			csvFormat.add(sqlInfo.getUser().toString());
		else
			csvFormat.add("");
		//パスワード
		if (sqlInfo.getPassword() != null)
			csvFormat.add(sqlInfo.getPassword());
		else
			csvFormat.add("");
		//SQL
		if (sqlInfo.getQuery() != null)
			csvFormat.add(sqlInfo.getQuery());
		else
			csvFormat.add("");

		return csvFormat;
	}

	/**
	 * SQL監視情報を取得する。<br>
	 * 
	 * @param monitorId 取得対象の監視項目ID
	 * @return SQL監視情報
	 */
	protected MonitorInfo getSnmp(String monitorId, int monitorType) {

		MonitorSqlController sql = EjbConnectionManager.getConnectionManager().getMonitorSqlController();

		MonitorInfo info = null;
		try {
			info = sql.getSqlInfo(monitorId, monitorType);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return info;
	}

	/**
	 * 監視項目リストを取得する。<br>
	 * 
	 * @return 監視項目一覧
	 */
	protected ArrayList getSnmpList() {

		MonitorSqlController sql = EjbConnectionManager.getConnectionManager().getMonitorSqlController();

		ArrayList records = null;
		try {
			records = sql.getSqlList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}