/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.export;

import java.util.Arrays;

import javax.naming.NamingException;

import jp.co.intellilink.hinemos.export.conf.access.ExportAccess;
import jp.co.intellilink.hinemos.export.conf.calendar.ExportCalendar;
import jp.co.intellilink.hinemos.export.conf.calendar.ExportCalendarSchedule;
import jp.co.intellilink.hinemos.export.conf.job.ExportJob;
import jp.co.intellilink.hinemos.export.conf.job.ExportSchedule;
import jp.co.intellilink.hinemos.export.conf.logtransfer.ExportLogTransfer;
import jp.co.intellilink.hinemos.export.conf.maintenance.ExportMaintenamce;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorAgent;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorHttp;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorHttpString;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorPerformance;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorPing;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorPort;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorProcess;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorSnmp;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorSnmpString;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorSnmpTrap;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorSql;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorSqlString;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorSyslogng;
import jp.co.intellilink.hinemos.export.conf.notify.ExportMailTemplate;
import jp.co.intellilink.hinemos.export.conf.notify.ExportNotify;
import jp.co.intellilink.hinemos.export.conf.performance.ExportPerformance;
import jp.co.intellilink.hinemos.export.conf.repository.ExportNode;
import jp.co.intellilink.hinemos.export.conf.repository.ExportNodeScope;
import jp.co.intellilink.hinemos.export.conf.repository.ExportScope;
import jp.co.intellilink.hinemos.util.LoginManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ExportConf メインクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ExportConf {
	// main関数に与えられる引数
	private static String mode = "all";

	// ログ出力
	private static Log log = LogFactory.getLog(ExportConf.class);

	/**
	 * メイン
	 * 
	 * @param args
	 */
	public static void main(String[] args) {

		// 実行ログを記載
		log.info(Messages.getMsg("ExportTool.Exec") + " : " + Arrays.toString(args));

		// 引数の数の確認
		if (args.length > 1) {
			log.error(Messages.getMsg("ArgsInvalid"));
			System.exit(11);
		}

		// 引数の格納
		if(args.length == 0 || args[0].equals(""))
			mode = "all";
		else if(args.length == 1)
			mode = args[0];

		if(mode.equalsIgnoreCase("access") || mode.equalsIgnoreCase("all")){
			//アクセス機能
			ExportAccess access = new ExportAccess();
			access.exportAccess();
		}
		if(mode.equalsIgnoreCase("node") || mode.equalsIgnoreCase("all")){
			//ノード
			ExportNode node = new ExportNode();
			node.exportNode();
		}
		if(mode.equalsIgnoreCase("scope") || mode.equalsIgnoreCase("all")){
			//スコープ
			ExportScope scope = new ExportScope();
			scope.exportScope();
			//スコープへのノード割り当て
			ExportNodeScope nodeScope = new ExportNodeScope();
			nodeScope.exportNodeScope();
		}
		if(mode.equalsIgnoreCase("notify") || mode.equalsIgnoreCase("all")){
			//通知機能
			ExportNotify notify = new ExportNotify();
			notify.exportNotify();
		}
		if(mode.equalsIgnoreCase("log") || mode.equalsIgnoreCase("all")){
			//ログ転送機能
			ExportLogTransfer logTransfer = new ExportLogTransfer();
			logTransfer.exportLogTransfer();
		}
		if(mode.equalsIgnoreCase("mail") || mode.equalsIgnoreCase("all")){
			//メールテンプレート機能
			ExportMailTemplate mailTemplate = new ExportMailTemplate();
			mailTemplate.exportMailTemplate();
		}
		if(mode.equalsIgnoreCase("mainte") || mode.equalsIgnoreCase("all")){
			//メンテナンス機能
			ExportMaintenamce maintenance = new ExportMaintenamce();
			maintenance.exportMaintenance();
		}
		if(mode.equalsIgnoreCase("ping") || mode.equalsIgnoreCase("all")){
			//Ping監視
			ExportMonitorPing ping = new ExportMonitorPing();
			ping.exportPing();
		}
		if(mode.equalsIgnoreCase("agent") || mode.equalsIgnoreCase("all")){
			//エージェント監視
			ExportMonitorAgent agent = new ExportMonitorAgent();
			agent.exportAgent();
		}
		if(mode.equalsIgnoreCase("process") || mode.equalsIgnoreCase("all")){
			//プロセス監視
			ExportMonitorProcess process = new ExportMonitorProcess();
			process.exportProcess();
		}
		if(mode.equalsIgnoreCase("resource") || mode.equalsIgnoreCase("all")){
			//リソース監視
			ExportMonitorPerformance perf = new ExportMonitorPerformance();
			perf.exportPerformance();
		}
		if(mode.equalsIgnoreCase("perf") || mode.equalsIgnoreCase("all")){
			//性能管理機能の実績収集
			ExportPerformance performance = new ExportPerformance();
			performance.exportPerformance();
		}
		if(mode.equalsIgnoreCase("syslog") || mode.equalsIgnoreCase("all")){
			//syslog-ng監視
			ExportMonitorSyslogng syslog = new ExportMonitorSyslogng();
			syslog.exportSyslogng();
		}
		if(mode.equalsIgnoreCase("snmp") || mode.equalsIgnoreCase("all")){
			//SNMP監視(数値)
			ExportMonitorSnmp snmpNum = new ExportMonitorSnmp();
			snmpNum.exportSnmp();
			//SNMP監視(文字列)
			ExportMonitorSnmpString snmpStr = new ExportMonitorSnmpString();
			snmpStr.exportSnmp();
		}
		if(mode.equalsIgnoreCase("trap") || mode.equalsIgnoreCase("all")){
			//SNMPTRAP監視
			ExportMonitorSnmpTrap trap = new ExportMonitorSnmpTrap();
			trap.exportSnmpTrap();
		}
		if(mode.equalsIgnoreCase("port") || mode.equalsIgnoreCase("all")){
			//サービス・ポート監視
			ExportMonitorPort port = new ExportMonitorPort();
			port.exportPort();
		}
		if(mode.equalsIgnoreCase("http") || mode.equalsIgnoreCase("all")){
			//HTTP監視(数値)
			ExportMonitorHttp httpNum = new ExportMonitorHttp();
			httpNum.exportHttp();
			//HTTP監視(文字列)
			ExportMonitorHttpString httpStr = new ExportMonitorHttpString();
			httpStr.exportHttp();
		}
		if(mode.equalsIgnoreCase("sql") || mode.equalsIgnoreCase("all")){
			//SQL監視(数値)
			ExportMonitorSql sqlNum = new ExportMonitorSql();
			sqlNum.exportSql();
			//SQL監視(文字列)
			ExportMonitorSqlString sqlStr = new ExportMonitorSqlString();
			sqlStr.exportSql();
		}
		if(mode.equalsIgnoreCase("job") || mode.equalsIgnoreCase("all")){
			//ジョブ
			ExportJob job = new ExportJob();
			job.exportJob();
			//ジョブスケジュール
			ExportSchedule sche = new ExportSchedule();
			sche.exportSchedule();
		}
		if(mode.equalsIgnoreCase("cal") || mode.equalsIgnoreCase("all")){
			//カレンダ
			ExportCalendar cal = new ExportCalendar();
			cal.exportCalendar();
			//カレンダ
			ExportCalendarSchedule cal2 = new ExportCalendarSchedule();
			cal2.exportSchedule();
		}
//		else{
//		log.error(Messages.getMsg("ModeNotFound"));
//		System.exit(12);
//		}

		// マネージャー接続の切断
		try {
			LoginManager.getContextManager().logout();
		} catch (NamingException e) {
			log.warn(Messages.getMsg("DisconnectManagerFailed"), e);
		}

		// 正常終了
		log.info(Messages.getMsg("ExportTool.Exit"));
		System.exit(0);
	}
}
