/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.importtool.master.mib;

import java.io.IOException;
import java.util.List;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import net.percederberg.mibble.MibLoaderException;

import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapController;

/**
 * Import MIB
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ImportMib {
	protected ResultSubject subject = null;
	
	/**
	 * Import MIB
	 * 
	 * @param filePaths
	 */
	public void importMib(String[] filePaths) {
		MonitorSnmpTrapController snmpTrap = 
			EjbConnectionManager.getConnectionManager().getMonitorSnmpTrapController();

		subject = new ResultSubject(filePaths);

		EntityFactory factory = new EntityFactory();
		
		for(int i = 0; i < subject.getFilePathSize(); i++){
			boolean createResult = false;
			try {
				factory.create(subject.getFilePath(i));
				createResult = true;
			} catch (IOException e) {
				subject.ioError(i);
			} catch (MibLoaderException e) {
				System.out.print("\n");
				System.out.print("************** Exception : " + subject.getFilePath(i) + " ****************************\n");
				System.out.print(subject.getFilePath(i));
				e.getLog().printTo(System.out);
				subject.noDependent(i);
			}
			
			try {
				if(createResult){
					if(factory.getTrapsData().size() > 0){
						snmpTrap.addMibMaster(factory.getMibData());
						for(SnmpTrapMasterInfo trap : factory.getTrapsData()){
							snmpTrap.addOidMaster(trap);
						}
						subject.success(i);
					}
					else
						subject.noTrap(i);
				}
			} catch (CreateException e) {
				if(e instanceof DuplicateKeyException)
					subject.duplicate(i);
				else
					subject.error(i);
			} catch (Exception e) {
				subject.error(i);
			}
		}
		
		String msg = getResult();
		System.out.print(msg);
	}
	
	/**
	 * get result
	 * 
	 * @return message
	 */
	protected String getResult() {
		StringBuilder message = new StringBuilder();
		
		message.append("************** Summay ****************************\n\n");

		if(subject.isConnectError()){
			message.append(Messages.getMsg("ImportTool.Mib.9") + "\n\n");
		}
		else if(subject.isAccessError()){
			message.append(Messages.getMsg("ImportTool.Mib.10") + "\n\n");
		}
		else if(subject.isCancel()){
			message.append(Messages.getMsg("ImportTool.Mib.7") + "\n\n");
		}
		
		int success = subject.getSuccessCount();
		int warning = subject.getDuplicateCount() + subject.getNoDependentCount() + subject.getNoTrapCount();
		int failed = subject.getErrorCount() + subject.getIoErrorCount();
		
		message.append(Messages.getMsg("successful") + " : " + success + "\n");
		message.append(Messages.getMsg("failed") + " : " + failed + "\n\n");
		message.append(Messages.getMsg("warning") + " : " + warning + "\n");
		
		if(success > 0){
			message.append("-------------- " + Messages.getMsg("successful") + " ----------------------------\n\n");
			
			message.append(getFileListMessages(
					Messages.getMsg("ImportTool.Mib.6"), 
					subject.getSuccessList()));
		}
		
		if(failed > 0){
			message.append("-------------- " + Messages.getMsg("failed") + " ----------------------------\n\n");
			
			message.append(getFileListMessages(
					Messages.getMsg("ImportTool.Mib.2"), 
					subject.getIoErrorList()));
			
			message.append(getFileListMessages(
					Messages.getMsg("ImportTool.Mib.4"), 
					subject.getErrorList()));
		}
		
		if(warning > 0){
			message.append("-------------- " + Messages.getMsg("warning") + " ----------------------------\n\n");
			
			message.append(getFileListMessages(
					Messages.getMsg("ImportTool.Mib.5"), 
					subject.getDuplicateList()));
			
			message.append(getFileListMessages(
					Messages.getMsg("ImportTool.Mib.8"), 
					subject.getNoTrapList()));
			
			message.append(getFileListMessages(
					Messages.getMsg("ImportTool.Mib.3"), 
					subject.getNoDependentList()));
		}
		return message.toString();
	}
	
	/**
	 * get file list
	 * 
	 * @param header
	 * @param list
	 * @return file list message
	 */
	protected String getFileListMessages(String header, List<String> list) {
		
		if(list.size() > 0){
			StringBuilder message = new StringBuilder();
			
			message.append(" " + header + "\n");
			for(String file : list){
				message.append(" " + file + "\n");
			}
			message.append("\n");
			
			return message.toString();
		}
		else{
			return "";
		}
	}
}