/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.performance;

import com.clustercontrol.bean.RunIntervalConstant;
import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.performance.bean.CollectorProperty;
import com.clustercontrol.performance.ejb.bmp.RecordCollectorData;
import com.clustercontrol.performance.ejb.session.CollectorController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import jp.co.intellilink.hinemos.export.conf.performance.CollectorItemCodeFactory;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportPerformance {
    private static Log log = LogFactory.getLog(ExportPerformance.class);

    public void exportPerformance() {
        log.info((Object)Messages.getMsg("Performance.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getPerformanceList();
        if (arrayList2 instanceof ArrayList) {
            for (Cloneable cloneable : arrayList2) {
                Object[] objectArray = new Object[]{(String)((ArrayList)cloneable).get(2)};
                log.info((Object)Messages.getMsg("CollectorID", objectArray));
                CollectorProperty collectorProperty = this.getPerformance((String)((ArrayList)cloneable).get(2));
                arrayList.add(this.createCsvFormat(collectorProperty));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        Object object = "";
        if (Config.getConfig("file.timestamp").equalsIgnoreCase("on")) {
            Cloneable cloneable;
            cloneable = new SimpleDateFormat("yyyyMMdd_HHmmss");
            object = "_" + ((DateFormat)cloneable).format(new Date());
        }
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/PERFORMANCE" + (String)object + ".csv", arrayList);
        log.info((Object)Messages.getMsg("Performance.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    public ArrayList<String> createCsvFormat(CollectorProperty collectorProperty) {
        ArrayList<String> arrayList = new ArrayList<String>();
        RecordCollectorData recordCollectorData = collectorProperty.getCollectorData();
        arrayList.add(recordCollectorData.getCollectorID());
        if (recordCollectorData.getLabel() != null) {
            arrayList.add(recordCollectorData.getLabel());
        } else {
            arrayList.add("");
        }
        arrayList.add(recordCollectorData.getFacilityID());
        arrayList.add(RunIntervalConstant.typeToString((int)recordCollectorData.getIntervalSec()));
        int n = recordCollectorData.getPeriodMin();
        if (n != -1) {
            arrayList.add(Messages.getMsg("PERIOD_SETTING"));
        } else {
            arrayList.add(Messages.getMsg("UNLIMIT_COLLECT"));
        }
        if (n != -1) {
            arrayList.add(Integer.toString(n / 60 / 24));
            arrayList.add(Integer.toString(n / 60 % 24));
            arrayList.add(Integer.toString(n % 60));
            arrayList.add("");
        } else {
            arrayList.add("");
            arrayList.add("");
            arrayList.add("");
            arrayList.add(Integer.toString(recordCollectorData.getPresavePeriod()));
        }
        List list = collectorProperty.getItemList();
        for (CollectorItemInfo collectorItemInfo : list) {
            String string = CollectorItemCodeFactory.getFullItemName(collectorItemInfo);
            arrayList.add(string);
        }
        return arrayList;
    }

    protected CollectorProperty getPerformance(String string) {
        CollectorController collectorController = EjbConnectionManager.getConnectionManager().getCollectorController();
        CollectorProperty collectorProperty = null;
        try {
            collectorProperty = collectorController.getCollectorProperty(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return collectorProperty;
    }

    protected ArrayList getPerformanceList() {
        CollectorController collectorController = EjbConnectionManager.getConnectionManager().getCollectorController();
        ArrayList arrayList = null;
        try {
            arrayList = collectorController.getCollectionList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

