/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.history;

import com.clustercontrol.performance.bean.CollectorProperty;
import com.clustercontrol.performance.ejb.bmp.RecordCollectorData;
import com.clustercontrol.performance.ejb.session.CollectorController;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import jp.co.intellilink.hinemos.export.history.ExportRecordData;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportPerformance {
    private static Log log = LogFactory.getLog(ExportPerformance.class);

    public void export(Date date) {
        log.info((Object)Messages.getMsg("Performance.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = this.getPerformanceList();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date2 = calendar.getTime();
        calendar.add(5, 1);
        calendar.add(14, -1);
        Date date3 = calendar.getTime();
        if (arrayList2 instanceof ArrayList) {
            for (ArrayList arrayList3 : arrayList2) {
                Object[] objectArray = new Object[]{(String)arrayList3.get(2)};
                log.info((Object)Messages.getMsg("CollectorID", objectArray));
                CollectorProperty collectorProperty = this.getPerformance((String)arrayList3.get(2));
                this.createPerformance(collectorProperty, date2, date3);
            }
        }
        log.info((Object)Messages.getMsg("Performance.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    public void createPerformance(CollectorProperty collectorProperty, Date date, Date date2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        RecordCollectorData recordCollectorData = collectorProperty.getCollectorData();
        arrayList.addAll(this.getNodeList(recordCollectorData.getFacilityID()));
        for (String string : arrayList) {
            Object[] objectArray = new Object[]{string};
            log.info((Object)Messages.getMsg("FacilityID", objectArray));
            ExportRecordData exportRecordData = new ExportRecordData(collectorProperty, string, date, date2);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
            String string2 = Config.getConfig("History.Dir") + "/PERF_" + recordCollectorData.getCollectorID() + "_" + string + "_" + simpleDateFormat.format(date) + ".csv";
            exportRecordData.write(string2);
        }
    }

    protected ArrayList<String> getNodeList(String string) {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (repositoryController.isNode(string)) {
                arrayList.add(string);
            } else {
                arrayList.addAll(repositoryController.getExecTargetFacilityIdList(string));
            }
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }

    protected CollectorProperty getPerformance(String string) {
        CollectorController collectorController = EjbConnectionManager.getConnectionManager().getCollectorController();
        CollectorProperty collectorProperty = null;
        try {
            collectorProperty = collectorController.getCollectorProperty(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return collectorProperty;
    }

    protected ArrayList getPerformanceList() {
        CollectorController collectorController = EjbConnectionManager.getConnectionManager().getCollectorController();
        ArrayList arrayList = null;
        try {
            arrayList = collectorController.getCollectionList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

