/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.util;

import com.clustercontrol.jobmanagement.bean.JobCommandInfo;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobNotificationsInfo;
import com.clustercontrol.jobmanagement.bean.JobObjectInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.NotifyUtil;
import jp.co.intellilink.hinemos.util.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobUtil {
    private static Log log = LogFactory.getLog(JobUtil.class);

    public static boolean findJobId(String string, JobTreeItem jobTreeItem) {
        boolean bl = false;
        JobInfo jobInfo = jobTreeItem.getData();
        if (jobInfo != null && jobInfo instanceof JobInfo && string.compareTo(jobInfo.getId()) == 0) {
            bl = true;
            return bl;
        }
        JobTreeItem[] jobTreeItemArray = jobTreeItem.getChildrenArray();
        for (int i = 0; i < jobTreeItemArray.length && !(bl = JobUtil.findJobId(string, jobTreeItemArray[i])); ++i) {
        }
        return bl;
    }

    public static boolean findJobUnitId(String string, JobTreeItem jobTreeItem) {
        boolean bl = false;
        JobInfo jobInfo = jobTreeItem.getData();
        if (jobInfo != null && jobInfo instanceof JobInfo && string.compareTo(jobInfo.getJobunitId()) == 0) {
            bl = true;
            return bl;
        }
        JobTreeItem[] jobTreeItemArray = jobTreeItem.getChildrenArray();
        for (int i = 0; i < jobTreeItemArray.length && !(bl = JobUtil.findJobUnitId(string, jobTreeItemArray[i])); ++i) {
        }
        return bl;
    }

    public static JobTreeItem getTopJobTreeItem(JobTreeItem jobTreeItem) {
        if (jobTreeItem == null) {
            return null;
        }
        while (jobTreeItem.getParent() != null) {
            if (jobTreeItem.getParent().getData().getType() == -1) {
                jobTreeItem = jobTreeItem.getParent();
                break;
            }
            jobTreeItem = jobTreeItem.getParent();
        }
        return jobTreeItem;
    }

    public static boolean checkWaitRule(JobTreeItem jobTreeItem) {
        Object object;
        boolean bl = true;
        if (jobTreeItem == null) {
            return bl;
        }
        if (jobTreeItem.getData() != null && jobTreeItem.getData() instanceof JobInfo) {
            object = jobTreeItem.getData().getId();
            JobWaitRuleInfo jobWaitRuleInfo = jobTreeItem.getData().getWaitRule();
            if (jobWaitRuleInfo != null && jobWaitRuleInfo instanceof JobWaitRuleInfo && jobWaitRuleInfo.getObject() != null && jobWaitRuleInfo.getObject().size() > 0) {
                for (JobObjectInfo jobObjectInfo : jobWaitRuleInfo.getObject()) {
                    if (jobObjectInfo.getType() == 2) continue;
                    boolean bl2 = false;
                    String string = jobObjectInfo.getJobId();
                    JobTreeItem[] jobTreeItemArray = jobTreeItem.getParent().getChildrenArray();
                    for (int i = 0; i < jobTreeItemArray.length; ++i) {
                        JobInfo jobInfo = jobTreeItemArray[i].getData();
                        if (jobInfo == null || !(jobInfo instanceof JobInfo) || ((String)object).equals(jobInfo.getId()) || string.compareTo(jobInfo.getId()) != 0) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    Object[] objectArray = new String[]{object, string};
                    log.error((Object)Messages.getMsg("ImportTool.Job.1", objectArray));
                    bl = false;
                    return bl;
                }
            }
        }
        object = jobTreeItem.getChildrenArray();
        for (int i = 0; i < ((JobTreeItem[])object).length && (bl = JobUtil.checkWaitRule(object[i])); ++i) {
        }
        return bl;
    }

    public static boolean checkFacilityId(JobTreeItem jobTreeItem) {
        Object object;
        boolean bl = true;
        if (jobTreeItem == null) {
            return bl;
        }
        if (jobTreeItem.getData() != null && jobTreeItem.getData() instanceof JobInfo) {
            object = jobTreeItem.getData().getId();
            JobCommandInfo jobCommandInfo = jobTreeItem.getData().getCommand();
            if (jobCommandInfo != null && jobCommandInfo instanceof JobCommandInfo && !RepositoryUtil.findFacilityId(jobCommandInfo.getFacilityID())) {
                Object[] objectArray = new String[]{object, jobCommandInfo.getFacilityID()};
                log.error((Object)Messages.getMsg("ImportTool.Job.2", objectArray));
                return false;
            }
        }
        object = jobTreeItem.getChildrenArray();
        for (int i = 0; i < ((JobTreeItem[])object).length && (bl = JobUtil.checkFacilityId(object[i])); ++i) {
        }
        return bl;
    }

    public static boolean checkNotifyId(JobTreeItem jobTreeItem) {
        Object object;
        boolean bl = true;
        if (jobTreeItem == null) {
            return bl;
        }
        if (jobTreeItem.getData() != null && jobTreeItem.getData() instanceof JobInfo) {
            object = jobTreeItem.getData().getId();
            if (jobTreeItem.getData().getNotifications() != null) {
                for (JobNotificationsInfo jobNotificationsInfo : jobTreeItem.getData().getNotifications()) {
                    if (jobNotificationsInfo.getType() != 0) continue;
                    if (jobNotificationsInfo.getNotifyId() == null) break;
                    for (NotifyRelationInfo notifyRelationInfo : jobNotificationsInfo.getNotifyId()) {
                        if (NotifyUtil.findNotifyId(notifyRelationInfo.getNotifyId())) continue;
                        Object[] objectArray = new String[]{object, notifyRelationInfo.getNotifyId()};
                        log.error((Object)Messages.getMsg("ImportTool.Job.4", objectArray));
                        return false;
                    }
                }
            }
        }
        object = jobTreeItem.getChildrenArray();
        for (int i = 0; i < ((JobTreeItem[])object).length && (bl = JobUtil.checkNotifyId(object[i])); ++i) {
        }
        return bl;
    }
}

