/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.repository;

import java.util.ArrayList;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.ejb.session.RepositoryController;

/**
 * ノード情報の有効・無効を設定するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ChangeValidNode {

	// ログ出力
	private static Log log = LogFactory.getLog(ChangeValidNode.class);

	/**
	 * ノード監視情報の有効・無効を設定する<br>
	 * 
	 * @param valid 有効/無効
	 */
	@SuppressWarnings("unchecked")
	public void changeValid(boolean valid) {
		log.info(Messages.getMsg("Node.Start", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));

		//監視項目リスト取得
		ArrayList<NodeInfo> nodeList = getNodeList();

		for(NodeInfo node : nodeList){
			//管理対象
			node.setValid(valid);

			changeNodeInfo(node);
		}

		log.info(Messages.getMsg("Node.End", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));
	}

	/**
	 * ノード情報の有効・無効を変更する。<br>
	 * 
	 * @param node ノード情報
	 */
	protected void changeNodeInfo(NodeInfo node) {

		RepositoryController repository = EjbConnectionManager.getConnectionManager().getRepositoryController();

		String facilityId = node.getFacilityId();
		try {
			Object[] args = {facilityId};
			log.info(Messages.getMsg("FacilityID", args) + 
					" (" + Messages.getMsg("modify") + ")");

			repository.modifyNode(node);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
	}
	
	/**
	 * ファシリティリストを取得する。<br>
	 * 
	 * @return ファシリティ一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList<NodeInfo> getNodeList() {

		RepositoryController repository = EjbConnectionManager.getConnectionManager().getRepositoryController();

		ArrayList<NodeInfo> nodeList = new ArrayList<NodeInfo>();
		try {
			ArrayList<String> records = repository.getNodeFacilityIdList();
			for(String facilityId : records){
				NodeInfo node = repository.getNode(facilityId);
				nodeList.add(node);
			}
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return nodeList;
	}
}