/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.importtool.master.mib;

import java.util.ArrayList;
import java.util.List;

/**
 * Subject
 * 
 * @version 2.3.0
 * @since 2.3.0
 */
public class ResultSubject {
	protected int fileIndex = 0;
	protected String[] filePaths = null;
	
	private int success = 0;
	private int error = 0;
	private int noDependent = 0;
	private int duplicate = 0;
	private int ioError = 0;
	private int noTrap = 0;
	
	private boolean accessError = false;
	private boolean connectError = false;
	private boolean cancel = false;
	
	List<String> successList = new ArrayList<String>();
	List<String> errorList = new ArrayList<String>();
	List<String> noDependentList = new ArrayList<String>();
	List<String> duplicateList = new ArrayList<String>();
	List<String> ioErrorList = new ArrayList<String>();
	List<String> noTrapList = new ArrayList<String>();
	
	public ResultSubject(String[] filePaths){
		this.filePaths = filePaths;
	}
	
	public void success(int fileIndex){
		this.fileIndex = fileIndex;
		success++;
		successList.add(filePaths[fileIndex]);
	}
	
	public void error(int fileIndex){
		this.fileIndex = fileIndex;
		error++;
		errorList.add(filePaths[fileIndex]);
	}
	
	public void noDependent(int fileIndex){
		this.fileIndex = fileIndex;
		noDependent++;
		noDependentList.add(filePaths[fileIndex]);
	}
	
	public void duplicate(int fileIndex){
		this.fileIndex = fileIndex;
		duplicate++;
		duplicateList.add(filePaths[fileIndex]);
	}
	
	public void ioError(int fileIndex){
		this.fileIndex = fileIndex;
		ioError++;
		ioErrorList.add(filePaths[fileIndex]);
	}	
	
	public void noTrap(int fileIndex){
		this.fileIndex = fileIndex;
		noTrap++;
		noTrapList.add(filePaths[fileIndex]);
	}
	
	public void accessError(){
		accessError = true;
	}
	
	public void connectError(){
		connectError = true;
	}
	
	public void cancel(){
		cancel = true;
	}
	
	public boolean isAccessError() {
		return accessError;
	}

	public boolean isCancel() {
		return cancel;
	}

	public boolean isConnectError() {
		return connectError;
	}

	public int getDuplicateCount() {
		return duplicate;
	}

	public int getErrorCount() {
		return error;
	}

	public int getIoErrorCount() {
		return ioError;
	}

	public int getNoDependentCount() {
		return noDependent;
	}

	public int getNoTrapCount() {
		return noTrap;
	}

	public int getSuccessCount() {
		return success;
	}
	
	public List<String> getDuplicateList() {
		return duplicateList;
	}

	public List<String> getErrorList() {
		return errorList;
	}

	public List<String> getIoErrorList() {
		return ioErrorList;
	}

	public List<String> getNoDependentList() {
		return noDependentList;
	}

	public List<String> getNoTrapList() {
		return noTrapList;
	}

	public List<String> getSuccessList() {
		return successList;
	}

	public int getFileIndex() {
		return fileIndex;
	}
	
	public int getFilePathSize() {
		return filePaths.length;
	}
	
	public String getFilePath(int fileIndex) {
		return filePaths[fileIndex];
	}
}
