/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.jmx;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;

import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.WriteCsvFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

/**
 * MBeanAttributes出力クラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class OutputMBeanAttribute {
	// ログ出力
	private static Log log = LogFactory.getLog(OutputMBeanAttribute.class);

	public static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
	public static final String OBJECT_NAME = "jboss.jca:name=HinemosDS,service=ManagedConnectionPool";
	
	/**
	 * MBeanAttributes出力
	 * 
	 * @param objectName MBean名
	 * @param fileName ファイル名
	 */
	public void check(String objectName, String fileName) {
		ArrayList<ArrayList<String>> csvOutput = new ArrayList<ArrayList<String>>();
		ArrayList<String> csvLine = new ArrayList<String>();
		csvLine.add(DateFormat.getDateTimeInstance().format(new Date()));
		
        //RMIAdaptorを取得
        RMIAdaptor server = 
        	EjbConnectionManager.getConnectionManager().getRMIAdaptor();

		try {
			//ObjectNameを設定
			ObjectName name = new ObjectName(objectName);
			log.info("ObjectName = " + objectName);
			
	        MBeanInfo info = server.getMBeanInfo(name);
	        MBeanAttributeInfo[] attributeList = info.getAttributes();
	        
	        for(MBeanAttributeInfo attributeInfo : attributeList){
	        	//属性名
	        	String attributeName = attributeInfo.getName();
	        	log.info("AttributeName = " + attributeName);
	        	csvLine.add(attributeName);
	        	//値
	        	try {
	        		Object attribute = server.getAttribute(name, attributeName);
	        		if(attribute != null)
	        			csvLine.add(attribute.toString());
	        		else
	        			csvLine.add("");
	        	}
	        	catch (Exception e) {
	        		csvLine.add("");
	        		log.debug("Error : getAttribute", e);
	        	}
	        }
	        
	        csvOutput.add(csvLine);

			SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
			WriteCsvFile.writeCsvFile(
					Config.getConfig("JMX.Dir") + "/" + fileName + "_" + format.format(new Date()) + ".csv", 
					csvOutput, true);
	        
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
		}
	}
}
