/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.monitor;

import java.util.ArrayList;
import java.util.Iterator;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapController;

/**
 * SNMPTRAP監視情報の有効・無効を設定するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ChangeValidMonitorSnmpTrap {

	// ログ出力
	private static Log log = LogFactory.getLog(ChangeValidMonitorSnmpTrap.class);

	/**
	 * SNMPTRAP監視情報の有効・無効を設定する<br>
	 * 
	 * @param valid 有効/無効
	 */
	@SuppressWarnings("unchecked")
	public void changeValid(boolean valid) {
		log.info(Messages.getMsg("SnmpTrap.Start", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));

		//監視項目リスト取得
		ArrayList idList = getMonitorList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				MonitorInfo info = (MonitorInfo)itr.next();
				info.setValid(ValidConstant.booleanToType(valid));
				changeMonitorInfo(info);
			}
		}

		log.info(Messages.getMsg("SnmpTrap.End", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));
	}

	/**
	 * 監視情報の有効・無効を変更する。<br>
	 * 
	 * @param info 監視情報オブジェクト
	 */
	protected void changeMonitorInfo(MonitorInfo info) {
		MonitorSnmpTrapController snmpTrap = EjbConnectionManager.getConnectionManager().getMonitorSnmpTrapController();

		try {
			Object[] args = {info.getMonitorId()};
			log.info(Messages.getMsg("MonitorID", args) + 
					" (" + Messages.getMsg("modify") + ")");

			snmpTrap.modifyMonitor((MonitorSnmpTrapInfo)info);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * 監視項目リストを取得する。<br>
	 * 
	 * @return 監視項目一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getMonitorList() {

		MonitorSnmpTrapController snmpTrap = EjbConnectionManager.getConnectionManager().getMonitorSnmpTrapController();

		ArrayList records = null;
		try {
			records = snmpTrap.getMonitorList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}