/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.tm.JBossTransactionRolledbackException;
import org.jboss.util.deadlock.ApplicationDeadlockException;

import com.clustercontrol.jobmanagement.bean.SystemParameterConstant;
import com.clustercontrol.repository.ejb.session.RepositoryController;

/**
 * リポジトリユーティリティクラス
 * リポジトリに関するユーティリティを格納するクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class RepositoryUtil {

	// ログ出力
	private static Log log = LogFactory.getLog(RepositoryUtil.class);
	
	/**
	 * ファシリティIDが存在するかチェックする<BR>
	 * 
	 * @param facilityId ファシリティID
	 * @return 結果
	 */
	public static boolean findFacilityId(String facilityId) {
		boolean find = false;

		RepositoryController repository = 
			EjbConnectionManager.getConnectionManager().getRepositoryController();

		try {
			if(facilityId.compareTo(
					SystemParameterConstant.HEADER + 
					SystemParameterConstant.FACILITY_ID + 
					SystemParameterConstant.FOOTER) == 0)
				find = true;
			else {
				for(int i = 0; i < 5; i++){
					try {
						if(repository.isNode(facilityId)){
							find = true;
							break;
						}
						else{
							repository.getScopeProperty(facilityId);
							find = true;
							break;
						}
					} catch (JBossTransactionRolledbackException e) {
						if(e.getCause() instanceof ApplicationDeadlockException
								&& i < 4){
							log.debug("ApplicationDeadlockException");
							Thread.sleep(10000);
							continue;
						}
						else{
							throw e;
						}
					}
				}
			}
		} catch (Exception e) {
		}

		return find;
	}
}