/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.MibWriter;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class MibblePrinter {
    private static final String COMMAND_HELP = "Prints the contents of an SNMP MIB file. This program comes with\nABSOLUTELY NO WARRANTY; for details see the LICENSE.txt file.\n\nSyntax: MibblePrinter [--mib|--oid|--debug] <file(s) or URL(s)>\n\n    --mib     Prints a formatted and indented version of the MIB.\n              This is the default printing mode.\n    --oid     Prints the complete OID tree, including all nodes\n              in imported MIB files\n    --debug   Prints the MIB contents in debug format, which will\n              display all values completely resolved.";
    private static final String INTERNAL_ERROR = "INTERNAL ERROR: An internal error has been found. Please report\n    this error to the maintainers (see the web site for\n    instructions). Be sure to include the version number, as\n    well as the text below:\n";
    private static final int MIB_PRINT_MODE = 0;
    private static final int OID_PRINT_MODE = 1;
    private static final int DEBUG_PRINT_MODE = 2;

    public static void main(String[] args) {
        MibLoader loader = new MibLoader();
        int printMode = 0;
        Mib mib = null;
        int pos = 0;
        if (args.length < 1) {
            MibblePrinter.printHelp("No MIB file or URL specified");
            System.exit(1);
        } else if (args[0].startsWith("--") && args.length < 2) {
            MibblePrinter.printHelp("No MIB file or URL specified");
            System.exit(1);
        }
        if (args[0].equals("--mib")) {
            printMode = 0;
            ++pos;
        } else if (args[0].equals("--oid")) {
            printMode = 1;
            ++pos;
        } else if (args[0].equals("--debug")) {
            printMode = 2;
            ++pos;
        } else if (args[0].startsWith("--")) {
            MibblePrinter.printHelp("No option '" + args[0] + "' exist");
            System.exit(1);
        }
        try {
            while (pos < args.length) {
                URL url;
                try {
                    url = new URL(args[pos]);
                }
                catch (MalformedURLException e) {
                    url = null;
                }
                if (url == null) {
                    File file = new File(args[pos]);
                    loader.addDir(file.getParentFile());
                    mib = loader.load(file);
                } else {
                    mib = loader.load(url);
                }
                if (mib.getLog().warningCount() > 0) {
                    mib.getLog().printTo(System.err);
                }
                ++pos;
            }
        }
        catch (FileNotFoundException e) {
            MibblePrinter.printError(args[pos], e);
            System.exit(1);
        }
        catch (IOException e) {
            MibblePrinter.printError(args[pos], e);
            System.exit(1);
        }
        catch (MibLoaderException e) {
            e.getLog().printTo(System.err);
            System.exit(1);
        }
        catch (RuntimeException e) {
            MibblePrinter.printInternalError(e);
            System.exit(1);
        }
        if (printMode == 1) {
            MibblePrinter.printOidTree(loader);
        } else {
            MibblePrinter.printMibs(loader, printMode);
        }
    }

    private static void printMibs(MibLoader loader, int printMode) {
        Mib[] mibs = loader.getAllMibs();
        for (int i = 0; i < mibs.length; ++i) {
            if (!mibs[i].isLoaded()) continue;
            if (printMode == 0) {
                MibblePrinter.printMib(mibs[i]);
                continue;
            }
            MibblePrinter.printDebug(mibs[i]);
        }
    }

    private static void printMib(Mib mib) {
        MibWriter os = new MibWriter(System.out);
        os.print(mib);
        System.out.println();
        System.out.println();
    }

    private static void printDebug(Mib mib) {
        Iterator iter = mib.getAllSymbols().iterator();
        while (iter.hasNext()) {
            System.out.println(iter.next());
            System.out.println();
        }
        System.out.println();
        System.out.println();
    }

    private static void printOidTree(MibLoader loader) {
        ObjectIdentifierValue root = null;
        if (loader.getAllMibs().length <= 0) {
            MibblePrinter.printError("no MIB modules have been loaded");
            return;
        }
        Mib mib = loader.getAllMibs()[0];
        Iterator iter = mib.getAllSymbols().iterator();
        while (root == null && iter.hasNext()) {
            MibValue value;
            MibSymbol symbol = (MibSymbol)iter.next();
            if (!(symbol instanceof MibValueSymbol) || !((value = ((MibValueSymbol)symbol).getValue()) instanceof ObjectIdentifierValue)) continue;
            root = (ObjectIdentifierValue)value;
        }
        if (root == null) {
            MibblePrinter.printError("no OID value could be found in " + mib.getName());
        } else {
            while (root.getParent() != null) {
                root = root.getParent();
            }
            MibblePrinter.printOid(root);
        }
    }

    private static void printOid(ObjectIdentifierValue oid) {
        System.out.println(oid.toDetailString());
        for (int i = 0; i < oid.getChildCount(); ++i) {
            MibblePrinter.printOid(oid.getChild(i));
        }
    }

    private static void printHelp(String error) {
        System.err.println(COMMAND_HELP);
        System.err.println();
        if (error != null) {
            MibblePrinter.printError(error);
        }
    }

    private static void printInternalError(Exception e) {
        System.err.println(INTERNAL_ERROR);
        e.printStackTrace();
    }

    private static void printError(String message) {
        System.err.print("Error: ");
        System.err.println(message);
    }

    private static void printError(String file, FileNotFoundException e) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("couldn't open file:\n    ");
        buffer.append(file);
        MibblePrinter.printError(buffer.toString());
    }

    private static void printError(String url, IOException e) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("couldn't open URL:\n    ");
        buffer.append(url);
        MibblePrinter.printError(buffer.toString());
    }
}

