/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;

public class SnmpIndex {
    private boolean implied;
    private MibValue value;
    private MibType type;

    public SnmpIndex(boolean implied, MibValue value, MibType type) {
        this.implied = implied;
        this.value = value;
        this.type = type;
    }

    void initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        if (this.value != null) {
            this.value = this.value.initialize(log, null);
        }
        if (this.type != null) {
            this.type = this.type.initialize(symbol, log);
        }
    }

    public boolean isImplied() {
        return this.implied;
    }

    public MibValue getValue() {
        return this.value;
    }

    public MibType getType() {
        return this.type;
    }

    public Object getTypeOrValue() {
        if (this.value != null) {
            return this.value;
        }
        return this.type;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.implied) {
            buffer.append("IMPLIED ");
        }
        buffer.append(this.getTypeOrValue());
        return buffer.toString();
    }
}

