/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.snmp.SnmpCompliance;

public class SnmpModule {
    private String module;
    private ArrayList groups;
    private ArrayList compliances;
    private String comment = null;

    public SnmpModule(String module, ArrayList groups, ArrayList compliances) {
        this.module = module;
        this.groups = groups;
        this.compliances = compliances;
    }

    void initialize(MibLoaderLog log) throws MibException {
        int i;
        ArrayList<MibValue> list = new ArrayList<MibValue>();
        for (i = 0; i < this.groups.size(); ++i) {
            list.add(((MibValue)this.groups.get(i)).initialize(log, null));
        }
        this.groups = list;
        for (i = 0; i < this.compliances.size(); ++i) {
            ((SnmpCompliance)this.compliances.get(i)).initialize(log);
        }
    }

    public String getModule() {
        return this.module;
    }

    public ArrayList getGroups() {
        return this.groups;
    }

    public ArrayList getCompliances() {
        return this.compliances;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        if (this.module != null || !"THIS MODULE".equalsIgnoreCase(comment)) {
            this.comment = comment;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.module != null) {
            buffer.append(this.module);
        }
        if (this.groups.size() > 0) {
            buffer.append("\n    Mandatory Groups: ");
            buffer.append(this.groups);
        }
        for (int i = 0; i < this.compliances.size(); ++i) {
            buffer.append("\n    Module: ");
            buffer.append(this.compliances.get(i));
        }
        return buffer.toString();
    }
}

