/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.history;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.monitor.bean.StatusInfoData;
import com.clustercontrol.monitor.ejb.session.MonitorController;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportStatus {
    private static Log log = LogFactory.getLog(ExportStatus.class);

    public void export() {
        log.info((Object)Messages.getMsg("ExportTool.Status.Start"));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<StatusInfoData> arrayList2 = this.getStatus();
        for (StatusInfoData statusInfoData : arrayList2) {
            arrayList.addAll(this.createStatus(statusInfoData));
        }
        Collections.sort(arrayList, new StringListComparator(3));
        Collections.sort(arrayList, new StringListComparator(2));
        Collections.sort(arrayList, new StringListComparator(1));
        arrayList.add(0, this.createHeader());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("History.Dir") + "/STATUS_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)Messages.getMsg("ExportTool.Status.End"));
    }

    public ArrayList<String> createHeader() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"priority"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"plugin.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"monitor.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"facility.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"scope"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"application"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"update.time"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"output.time"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"message.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"message"));
        return arrayList;
    }

    public ArrayList<ArrayList<String>> createStatus(StatusInfoData statusInfoData) {
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        arrayList2.add(PriorityConstant.typeToString((int)statusInfoData.getPriority()));
        arrayList2.add(statusInfoData.getPluginId());
        arrayList2.add(statusInfoData.getMonitorId());
        arrayList2.add(statusInfoData.getFacilityId());
        arrayList2.add(statusInfoData.getFacilityPath());
        arrayList2.add(statusInfoData.getApplication());
        arrayList2.add(dateFormat.format(statusInfoData.getOutputDate()));
        arrayList2.add(dateFormat.format(statusInfoData.getGenerationDate()));
        arrayList2.add(statusInfoData.getMessageId());
        arrayList2.add(statusInfoData.getMessage());
        arrayList.add(arrayList2);
        return arrayList;
    }

    public synchronized ArrayList<StatusInfoData> getStatus() {
        MonitorController monitorController = EjbConnectionManager.getConnectionManager().getMonitorController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorController.getStatusList(null);
        }
        catch (RemoteException remoteException) {
        }
        catch (CreateException createException) {
        }
        catch (FinderException finderException) {
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return arrayList;
    }
}

