/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.repository;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.SnmpVersionConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.util.PropertyUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportNode {
    private static Log log = LogFactory.getLog(ExportNode.class);

    public void exportNode() {
        log.info((Object)Messages.getMsg("Node.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getNodeList();
        if (arrayList2 instanceof ArrayList) {
            for (Object object2 : arrayList2) {
                Object[] objectArray = new Object[]{object2};
                log.info((Object)Messages.getMsg("FacilityID", objectArray));
                Property property = this.getNode((String)object2);
                arrayList.add(this.createCsvFormat(property));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        Object object = "";
        if (Config.getConfig("file.timestamp").equalsIgnoreCase("on")) {
            Object object2;
            object2 = new SimpleDateFormat("yyyyMMdd_HHmmss");
            object = "_" + ((DateFormat)object2).format(new Date());
        }
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/NODE" + (String)object + ".csv", arrayList);
        log.info((Object)Messages.getMsg("Node.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    public ArrayList<String> createCsvFormat(Property property) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = null;
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"facilityId");
        arrayList.add(this.getStringValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"facilityName");
        arrayList.add(this.getStringValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"description");
        arrayList.add(this.getStringValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"platformFamilyName");
        arrayList.add(this.getStringValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"hardwareType");
        arrayList.add(this.getStringValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"iconImage");
        arrayList.add(this.getStringValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"valid");
        arrayList.add(this.getBooleanValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"snmpPort");
        arrayList.add(this.getIntegerValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"snmpCommunity");
        arrayList.add(this.getStringValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"snmpVersion");
        String string = this.getStringValue(arrayList2);
        if (!string.equals(SnmpVersionConstant.STRING_V1) && !string.equals(SnmpVersionConstant.STRING_V2)) {
            string = "";
        }
        arrayList.add(string);
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"snmpTimeout");
        arrayList.add(this.getIntegerValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"snmpRetries");
        arrayList.add(this.getIntegerValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"snmpProxy");
        arrayList.add(this.getStringValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"dhcpClient");
        arrayList.add(this.getBooleanValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressType");
        arrayList.add(this.getIntegerValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressVersion");
        arrayList.add(this.getIntegerValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressV4");
        arrayList.add(this.getStringValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressV6");
        arrayList.add(this.getStringValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"hostName");
        arrayList.add(this.getStringValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"nodeName");
        arrayList.add(this.getStringValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"osName");
        arrayList.add(this.getStringValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"osRelease");
        arrayList.add(this.getStringValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"osVersion");
        arrayList.add(CheckString.checkReturn(this.getStringValue(arrayList2)));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"characterSet");
        arrayList.add(this.getStringValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"virtualizationNodeType");
        arrayList.add(this.getStringValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"vMManagementNode");
        arrayList.add(this.getStringValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"VMINDEX");
        arrayList.add(this.getIntegerValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"VMName");
        arrayList.add(this.getStringValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"virtualizationSolution");
        arrayList.add(this.getStringValue(arrayList2));
        return arrayList;
    }

    public String getStringValue(ArrayList arrayList) {
        if (arrayList.size() > 0 && arrayList.get(0) instanceof String) {
            return (String)arrayList.get(0);
        }
        return "";
    }

    public String getIntegerValue(ArrayList arrayList) {
        if (arrayList.size() > 0 && arrayList.get(0) instanceof Integer) {
            return ((Integer)arrayList.get(0)).toString();
        }
        return "";
    }

    public String getBooleanValue(ArrayList arrayList) {
        if (arrayList.size() > 0 && arrayList.get(0) instanceof Boolean) {
            if (((Boolean)arrayList.get(0)).booleanValue()) {
                return YesNoConstant.typeToString((int)1);
            }
            return YesNoConstant.typeToString((int)0);
        }
        return "";
    }

    protected Property getNode(String string) {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        Property property = null;
        try {
            property = repositoryController.getNodeProperty(string, 2, Locale.getDefault());
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return property;
    }

    protected ArrayList getNodeList() {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        ArrayList arrayList = null;
        try {
            arrayList = repositoryController.getNodeFacilityIdList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

