/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.history;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.bean.ViewListInfo;
import com.clustercontrol.collectiverun.bean.DetailTableDefine;
import com.clustercontrol.collectiverun.bean.HistoryTableDefine;
import com.clustercontrol.collectiverun.ejb.session.CollectiveRunController;
import com.clustercontrol.util.PropertyUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportCollectiveRun {
    private static Log log = LogFactory.getLog(ExportCollectiveRun.class);

    public void export(Date date) {
        log.info((Object)Messages.getMsg("CollectiveRun.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date2 = calendar.getTime();
        calendar.add(5, 1);
        calendar.add(14, -1);
        Date date3 = calendar.getTime();
        ViewListInfo viewListInfo = this.getSessionList(date2, date3);
        if (viewListInfo.getList() instanceof ArrayList) {
            for (ArrayList arrayList3 : viewListInfo.getList()) {
                String string = (String)arrayList3.get(HistoryTableDefine.SESSION_ID);
                Object[] objectArray = new Object[]{string};
                log.info((Object)Messages.getMsg("SessionID", objectArray));
                arrayList.add(this.createSessionCsvFormat(arrayList3));
                arrayList2.addAll(this.createNodeCsvFormat(arrayList3));
            }
        }
        Collections.sort(arrayList, new StringListComparator(6));
        Collections.sort(arrayList, new StringListComparator(1));
        arrayList.add(0, this.createSessionCsvHeader());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        WriteCsvFile.writeCsvFile(Config.getConfig("History.Dir") + "/CRUN_" + simpleDateFormat.format(date2) + ".csv", arrayList);
        Collections.sort(arrayList2, new StringListComparator(4));
        Collections.sort(arrayList2, new StringListComparator(3));
        arrayList2.add(0, this.createNodeCsvHeader());
        WriteCsvFile.writeCsvFile(Config.getConfig("History.Dir") + "/CRUN_NODE_" + simpleDateFormat.format(date2) + ".csv", arrayList2);
        log.info((Object)Messages.getMsg("CollectiveRun.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    public ArrayList<String> createSessionCsvHeader() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"run.status"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"session.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"start.time"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"end.time"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"type"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"name"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"facility.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"scope"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"total"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"successful"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"warning"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"failed"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"waiting"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"running"));
        return arrayList;
    }

    public ArrayList<String> createNodeCsvHeader() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"run.status"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"end.status"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"return.value"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"session.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"facility.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"facility.name"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"start.time"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"end.time"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"message"));
        return arrayList;
    }

    public ArrayList<String> createSessionCsvFormat(ArrayList arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(StatusConstant.typeToString((int)((Number)arrayList.get(HistoryTableDefine.STATUS)).intValue()));
        arrayList2.add((String)arrayList.get(HistoryTableDefine.SESSION_ID));
        if (arrayList.get(HistoryTableDefine.START_TIME) instanceof Date) {
            arrayList2.add(DateFormat.getDateTimeInstance().format((Date)arrayList.get(HistoryTableDefine.START_TIME)));
        }
        if (arrayList.get(HistoryTableDefine.END_TIME) instanceof Date) {
            arrayList2.add(DateFormat.getDateTimeInstance().format((Date)arrayList.get(HistoryTableDefine.END_TIME)));
        }
        arrayList2.add((String)arrayList.get(HistoryTableDefine.TYPE));
        arrayList2.add((String)arrayList.get(HistoryTableDefine.NAME));
        arrayList2.add((String)arrayList.get(HistoryTableDefine.FACILITY_ID));
        arrayList2.add((String)arrayList.get(HistoryTableDefine.SCOPE));
        if (arrayList.get(HistoryTableDefine.TOTAL) instanceof Number) {
            arrayList2.add(((Number)arrayList.get(HistoryTableDefine.TOTAL)).toString());
        }
        if (arrayList.get(HistoryTableDefine.NORMAL) instanceof Number) {
            arrayList2.add(((Number)arrayList.get(HistoryTableDefine.NORMAL)).toString());
        }
        if (arrayList.get(HistoryTableDefine.WARNING) instanceof Number) {
            arrayList2.add(((Number)arrayList.get(HistoryTableDefine.WARNING)).toString());
        }
        if (arrayList.get(HistoryTableDefine.ABNORMAL) instanceof Number) {
            arrayList2.add(((Number)arrayList.get(HistoryTableDefine.ABNORMAL)).toString());
        }
        if (arrayList.get(HistoryTableDefine.WAITING) instanceof Number) {
            arrayList2.add(((Number)arrayList.get(HistoryTableDefine.WAITING)).toString());
        }
        if (arrayList.get(HistoryTableDefine.RUNNING) instanceof Number) {
            arrayList2.add(((Number)arrayList.get(HistoryTableDefine.RUNNING)).toString());
        }
        return arrayList2;
    }

    public ArrayList<ArrayList<String>> createNodeCsvFormat(ArrayList arrayList) {
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        String string = (String)arrayList.get(HistoryTableDefine.SESSION_ID);
        ArrayList arrayList3 = this.getNodeList(string);
        if (arrayList3 instanceof ArrayList) {
            for (ArrayList arrayList4 : arrayList3) {
                ArrayList<String> arrayList5 = new ArrayList<String>();
                arrayList5.add(StatusConstant.typeToString((int)((Number)arrayList4.get(DetailTableDefine.STATUS)).intValue()));
                if (arrayList4.get(DetailTableDefine.END_STATUS) instanceof Number) {
                    arrayList5.add(EndStatusConstant.typeToString((int)((Number)arrayList4.get(DetailTableDefine.END_STATUS)).intValue()));
                } else {
                    arrayList5.add("");
                }
                if (arrayList4.get(DetailTableDefine.RETURN_VALUE) instanceof Number) {
                    arrayList5.add(((Number)arrayList4.get(DetailTableDefine.RETURN_VALUE)).toString());
                } else {
                    arrayList5.add("");
                }
                arrayList5.add(string);
                arrayList5.add((String)arrayList4.get(DetailTableDefine.FACILITY_ID));
                arrayList5.add((String)arrayList4.get(DetailTableDefine.FACILITY_NAME));
                if (arrayList4.get(DetailTableDefine.START_TIME) instanceof Date) {
                    arrayList5.add(DateFormat.getDateTimeInstance().format((Date)arrayList4.get(DetailTableDefine.START_TIME)));
                }
                if (arrayList4.get(DetailTableDefine.END_TIME) instanceof Date) {
                    arrayList5.add(DateFormat.getDateTimeInstance().format((Date)arrayList4.get(DetailTableDefine.END_TIME)));
                }
                if (arrayList4.get(DetailTableDefine.MESSAGE) instanceof String) {
                    arrayList5.add(CheckString.checkReturn((String)arrayList4.get(DetailTableDefine.MESSAGE)));
                } else {
                    arrayList5.add("");
                }
                arrayList2.add(arrayList5);
            }
        }
        return arrayList2;
    }

    protected ViewListInfo getSessionList(Date date, Date date2) {
        CollectiveRunController collectiveRunController = EjbConnectionManager.getConnectionManager().getCollectiveRunController();
        ViewListInfo viewListInfo = null;
        try {
            ArrayList arrayList = null;
            Property property = collectiveRunController.getHistoryFilterProperty(Locale.getDefault());
            if (date instanceof Date) {
                arrayList = PropertyUtil.getProperty((Property)property, (String)"startFromDate");
                ((Property)arrayList.get(0)).setValue((Object)date);
            }
            if (date2 instanceof Date) {
                arrayList = PropertyUtil.getProperty((Property)property, (String)"startToDate");
                ((Property)arrayList.get(0)).setValue((Object)date2);
            }
            int n = Integer.parseInt(Config.getConfig("history.crun.max.list"));
            viewListInfo = collectiveRunController.getHistoryList(property, Locale.getDefault(), n);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return viewListInfo;
    }

    protected ArrayList getNodeList(String string) {
        CollectiveRunController collectiveRunController = EjbConnectionManager.getConnectionManager().getCollectiveRunController();
        ArrayList arrayList = null;
        try {
            arrayList = collectiveRunController.getDetailList(string, Locale.getDefault());
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

