/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.calendar;

import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.calendar.ejb.session.CalendarController;
import com.clustercontrol.util.PropertyUtil;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import javax.ejb.DuplicateKeyException;
import javax.ejb.FinderException;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.ReadCsvFile;
import jp.co.intellilink.hinemos.util.SelectArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportCalendar {
    private static Log log = LogFactory.getLog(ImportCalendar.class);
    private SimpleDateFormat formatTime1 = new SimpleDateFormat("HH:mm:ss");
    private SimpleDateFormat formatTime2 = new SimpleDateFormat("HH:mm");
    private ArrayList<ArrayList<String>> calendarInfos = null;
    private ArrayList<ArrayList<String>> calendarRuleInfos = null;
    private ArrayList<ArrayList<String>> calendarExceptionInfos = null;
    private ArrayList calendarList = null;

    public void importCalendar() {
        log.info((Object)Messages.getMsg("Calendar.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.calendarInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/CALENDAR.csv");
        this.calendarRuleInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/CALENDAR_RULE.csv");
        this.calendarExceptionInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/CALENDAR_EXCEPTION.csv");
        this.calendarList = this.getCalendarList();
        for (ArrayList<String> arrayList : this.calendarInfos) {
            Object object;
            String string = arrayList.get(0);
            Property property = this.createCalenderInfo(arrayList);
            this.registerCalendarInfo(property);
            this.deleteRuleInfo(string);
            ArrayList<ArrayList<String>> arrayList2 = SelectArrayList.select(this.calendarRuleInfos, 0, string);
            for (ArrayList<String> arrayList3 : arrayList2) {
                object = this.createRuleInfo(arrayList3);
                this.registerRuleInfo(string, (Property)object);
            }
            this.deleteExceptionInfo(string);
            ArrayList<ArrayList<String>> arrayList3 = SelectArrayList.select(this.calendarExceptionInfos, 0, string);
            Iterator object22 = arrayList3.iterator();
            while (object22.hasNext()) {
                object = (ArrayList)object22.next();
                Property property2 = this.createExceptionInfo((ArrayList<String>)object);
                this.registerExceptionInfo(string, property2);
            }
        }
        log.info((Object)Messages.getMsg("Calendar.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    public Property createCalenderInfo(ArrayList<String> arrayList) {
        Object object;
        Object object2;
        Property property = this.getCalendarProperty();
        ArrayList arrayList2 = null;
        String string = CheckString.checkLength(arrayList.get(0), 64);
        if (!string.equals(arrayList.get(0))) {
            object2 = new String[]{com.clustercontrol.util.Messages.getString((String)"calendar.id"), "64"};
            log.error((Object)Messages.getMsg("ImportTool.Common.2", (Object[])object2));
            System.exit(20);
        }
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"id");
        ((Property)arrayList2.get(0)).setValue((Object)string);
        object2 = CheckString.checkLength(arrayList.get(1), 256);
        if (!((String)object2).equals(arrayList.get(1))) {
            object = new String[]{com.clustercontrol.util.Messages.getString((String)"calendar.name"), "256"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", (Object[])object));
        }
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"name");
        ((Property)arrayList2.get(0)).setValue(object2);
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"validTimeFrom");
        try {
            ((Property)arrayList2.get(0)).setValue((Object)DateFormat.getDateTimeInstance().parse(arrayList.get(2)));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"validTimeTo");
        try {
            ((Property)arrayList2.get(0)).setValue((Object)DateFormat.getDateTimeInstance().parse(arrayList.get(3)));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (arrayList.size() >= 5) {
            object = CheckString.checkLength(arrayList.get(4), 256);
            if (!((String)object).equals(arrayList.get(4))) {
                Object[] objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"description"), "256"};
                log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
            }
            arrayList2 = PropertyUtil.getProperty((Property)property, (String)"description");
            ((Property)arrayList2.get(0)).setValue(object);
        }
        return property;
    }

    public Property createRuleInfo(ArrayList<String> arrayList) {
        Property property = this.getRuleProperty();
        ArrayList arrayList2 = null;
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"weekday");
        ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(1));
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"timeFrom");
        try {
            ((Property)arrayList2.get(0)).setValue((Object)this.formatTime1.parse(arrayList.get(2)));
        }
        catch (ParseException parseException) {
            try {
                ((Property)arrayList2.get(0)).setValue((Object)this.formatTime2.parse(arrayList.get(2)));
            }
            catch (ParseException parseException2) {
                // empty catch block
            }
        }
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"timeTo");
        try {
            ((Property)arrayList2.get(0)).setValue((Object)this.formatTime1.parse(arrayList.get(3)));
        }
        catch (ParseException parseException) {
            try {
                ((Property)arrayList2.get(0)).setValue((Object)this.formatTime2.parse(arrayList.get(3)));
            }
            catch (ParseException parseException3) {
                // empty catch block
            }
        }
        if (arrayList.size() >= 5) {
            String string = CheckString.checkLength(arrayList.get(4), 256);
            if (!string.equals(arrayList.get(4))) {
                Object[] objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"description"), "256"};
                log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
            }
            arrayList2 = PropertyUtil.getProperty((Property)property, (String)"description");
            ((Property)arrayList2.get(0)).setValue((Object)string);
        }
        return property;
    }

    public Property createExceptionInfo(ArrayList<String> arrayList) {
        Property property = this.getExceptionProperty();
        ArrayList arrayList2 = null;
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"execute");
        Boolean bl = YesNoConstant.typeToBoolean((int)YesNoConstant.stringToType((String)arrayList.get(1)));
        ((Property)arrayList2.get(0)).setValue((Object)bl);
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"timeFrom");
        try {
            ((Property)arrayList2.get(0)).setValue((Object)DateFormat.getDateTimeInstance().parse(arrayList.get(2)));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"timeTo");
        try {
            ((Property)arrayList2.get(0)).setValue((Object)DateFormat.getDateTimeInstance().parse(arrayList.get(3)));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (arrayList.size() >= 5) {
            String string = CheckString.checkLength(arrayList.get(4), 256);
            if (!string.equals(arrayList.get(4))) {
                Object[] objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"description"), "256"};
                log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
            }
            arrayList2 = PropertyUtil.getProperty((Property)property, (String)"description");
            ((Property)arrayList2.get(0)).setValue((Object)string);
        }
        return property;
    }

    protected ArrayList checkCalendarList(String string) {
        if (this.calendarList instanceof ArrayList) {
            for (ArrayList arrayList : this.calendarList) {
                String string2 = (String)arrayList.get(0);
                if (string2.compareTo(string) != 0) continue;
                return arrayList;
            }
        }
        return null;
    }

    protected void registerExceptionInfo(String string, Property property) {
        CalendarController calendarController = EjbConnectionManager.getConnectionManager().getCalendarController();
        ArrayList arrayList = null;
        arrayList = PropertyUtil.getProperty((Property)property, (String)"timeFrom");
        String string2 = DateFormat.getDateTimeInstance().format((Date)((Property)arrayList.get(0)).getValue());
        arrayList = PropertyUtil.getProperty((Property)property, (String)"timeTo");
        String string3 = DateFormat.getDateTimeInstance().format((Date)((Property)arrayList.get(0)).getValue());
        try {
            Object[] objectArray = new Object[]{string, string2, string3};
            log.info((Object)(Messages.getMsg("ImportTool.CalendarID.Exception", objectArray) + " (" + Messages.getMsg("add") + ")"));
            calendarController.addAddInfo(string, property);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected void registerRuleInfo(String string, Property property) {
        CalendarController calendarController = EjbConnectionManager.getConnectionManager().getCalendarController();
        ArrayList arrayList = null;
        arrayList = PropertyUtil.getProperty((Property)property, (String)"weekday");
        String string2 = (String)((Property)arrayList.get(0)).getValue();
        arrayList = PropertyUtil.getProperty((Property)property, (String)"timeFrom");
        String string3 = this.formatTime1.format((Date)((Property)arrayList.get(0)).getValue());
        arrayList = PropertyUtil.getProperty((Property)property, (String)"timeTo");
        String string4 = this.formatTime1.format((Date)((Property)arrayList.get(0)).getValue());
        try {
            Object[] objectArray = new Object[]{string, string2, string3, string4};
            log.info((Object)(Messages.getMsg("ImportTool.CalendarID.Rule", objectArray) + " (" + Messages.getMsg("add") + ")"));
            calendarController.addWeekday(string, property);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected void registerCalendarInfo(Property property) {
        CalendarController calendarController = EjbConnectionManager.getConnectionManager().getCalendarController();
        ArrayList arrayList = null;
        arrayList = PropertyUtil.getProperty((Property)property, (String)"id");
        String string = (String)((Property)arrayList.get(0)).getValue();
        try {
            ArrayList arrayList2 = this.checkCalendarList(string);
            if (arrayList2 instanceof ArrayList) {
                Date date = (Date)arrayList2.get(6);
                String string2 = (String)arrayList2.get(5);
                arrayList = PropertyUtil.getProperty((Property)property, (String)"createTimestamp");
                ((Property)arrayList.get(0)).setValue((Object)date);
                arrayList = PropertyUtil.getProperty((Property)property, (String)"creatorName");
                ((Property)arrayList.get(0)).setValue((Object)string2);
                Object[] objectArray = new Object[]{string};
                log.info((Object)(Messages.getMsg("CalendarID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                calendarController.modifyCalendar(property);
            } else {
                Object[] objectArray = new Object[]{string};
                log.info((Object)(Messages.getMsg("CalendarID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                calendarController.addCalendar(property);
            }
        }
        catch (DuplicateKeyException duplicateKeyException) {
            Object[] objectArray = new String[]{string};
            log.error((Object)Messages.getMsg("ImportTool.Common.1", objectArray));
            System.exit(20);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected void deleteExceptionInfo(String string) {
        CalendarController calendarController = EjbConnectionManager.getConnectionManager().getCalendarController();
        ArrayList arrayList = this.getExceptionList(string);
        if (arrayList instanceof ArrayList) {
            for (ArrayList arrayList2 : arrayList) {
                Date date = (Date)arrayList2.get(1);
                Date date2 = (Date)arrayList2.get(2);
                Object[] objectArray = new Object[]{string, DateFormat.getDateTimeInstance().format(date), DateFormat.getDateTimeInstance().format(date2)};
                log.info((Object)(Messages.getMsg("ImportTool.CalendarID.Exception", objectArray) + " (" + Messages.getMsg("delete") + ")"));
                try {
                    calendarController.deleteAddInfo(string, date, date2);
                }
                catch (FinderException finderException) {
                }
                catch (Exception exception) {
                    log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
                    System.exit(14);
                }
            }
        }
    }

    protected void deleteRuleInfo(String string) {
        CalendarController calendarController = EjbConnectionManager.getConnectionManager().getCalendarController();
        ArrayList arrayList = this.getRuleList(string);
        if (arrayList instanceof ArrayList) {
            for (ArrayList arrayList2 : arrayList) {
                Integer n = (Integer)arrayList2.get(0);
                Time time = (Time)arrayList2.get(1);
                Time time2 = (Time)arrayList2.get(2);
                Object[] objectArray = new Object[]{string, DayOfWeekConstant.typeToString((int)n), this.formatTime1.format(time), this.formatTime1.format(time2)};
                log.info((Object)(Messages.getMsg("ImportTool.CalendarID.Rule", objectArray) + " (" + Messages.getMsg("delete") + ")"));
                try {
                    calendarController.deleteWeekday(string, n, (Date)time, (Date)time2);
                }
                catch (FinderException finderException) {
                }
                catch (Exception exception) {
                    log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
                    System.exit(14);
                }
            }
        }
    }

    protected Property getExceptionProperty() {
        CalendarController calendarController = EjbConnectionManager.getConnectionManager().getCalendarController();
        Property property = null;
        try {
            property = calendarController.getAddInfoProperty("", null, null, 0, Locale.getDefault());
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return property;
    }

    protected Property getRuleProperty() {
        CalendarController calendarController = EjbConnectionManager.getConnectionManager().getCalendarController();
        Property property = null;
        try {
            property = calendarController.getWeekdayProperty("", null, null, null, 0, Locale.getDefault());
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return property;
    }

    protected Property getCalendarProperty() {
        CalendarController calendarController = EjbConnectionManager.getConnectionManager().getCalendarController();
        Property property = null;
        try {
            property = calendarController.getCalendarProperty("", 0, Locale.getDefault());
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return property;
    }

    protected ArrayList getExceptionList(String string) {
        CalendarController calendarController = EjbConnectionManager.getConnectionManager().getCalendarController();
        ArrayList arrayList = null;
        try {
            arrayList = calendarController.getAddList(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }

    protected ArrayList getRuleList(String string) {
        CalendarController calendarController = EjbConnectionManager.getConnectionManager().getCalendarController();
        ArrayList arrayList = null;
        try {
            arrayList = calendarController.getWeekdayList(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }

    protected ArrayList getCalendarList() {
        CalendarController calendarController = EjbConnectionManager.getConnectionManager().getCalendarController();
        ArrayList arrayList = null;
        try {
            arrayList = calendarController.getCalendarList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

