/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.notify;

import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoData;
import com.clustercontrol.notify.mail.ejb.session.MailTemplateController;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import javax.ejb.DuplicateKeyException;
import jp.co.intellilink.hinemos.importtool.util.Config;
import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;
import jp.co.intellilink.hinemos.importtool.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMailTemplate {
    private static Log log = LogFactory.getLog(ImportMailTemplate.class);
    private ArrayList mailTemplateList = null;
    private ArrayList<ArrayList<String>> mailTemplateInfos = null;

    public void importMailTemplate() {
        log.info((Object)Messages.getMsg("ImportTool.MailTemplate.Start"));
        this.mailTemplateInfos = ReadCsvFile.readCsvFile(Config.getConfig("Input.Dir.Conf") + "/MAILTEMPLATE.csv");
        this.mailTemplateList = this.getMailTemplateList();
        for (ArrayList<String> arrayList : this.mailTemplateInfos) {
            MailTemplateInfoData mailTemplateInfoData = this.createMailTemplateInfo(arrayList);
            this.registerMailTemplateInfo(mailTemplateInfoData);
        }
        log.info((Object)Messages.getMsg("ImportTool.MailTemplate.End"));
    }

    public MailTemplateInfoData createMailTemplateInfo(ArrayList<String> arrayList) {
        MailTemplateInfoData mailTemplateInfoData = new MailTemplateInfoData();
        mailTemplateInfoData.setMailTemplateId(arrayList.get(0));
        mailTemplateInfoData.setDescription(arrayList.get(1));
        mailTemplateInfoData.setSubject(arrayList.get(2));
        mailTemplateInfoData.setBody(arrayList.get(3));
        return mailTemplateInfoData;
    }

    protected ArrayList checkMailTemplateList(String string) {
        if (this.mailTemplateList instanceof ArrayList) {
            for (ArrayList arrayList : this.mailTemplateList) {
                String string2 = (String)arrayList.get(0);
                if (string2.compareTo(string) != 0) continue;
                return arrayList;
            }
        }
        return null;
    }

    protected void registerMailTemplateInfo(MailTemplateInfoData mailTemplateInfoData) {
        MailTemplateController mailTemplateController = EjbConnectionManager.getConnectionManager().getMailTemplateController();
        try {
            ArrayList arrayList = this.checkMailTemplateList(mailTemplateInfoData.getMailTemplateId());
            if (arrayList instanceof ArrayList) {
                Date date = (Date)arrayList.get(3);
                String string = (String)arrayList.get(2);
                mailTemplateInfoData.setRegDate(new Timestamp(date.getTime()));
                mailTemplateInfoData.setRegUser(string);
                Object[] objectArray = new Object[]{mailTemplateInfoData.getMailTemplateId()};
                log.info((Object)(Messages.getMsg("ImportTool.MailTemplateID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                mailTemplateController.modifyMailTemplate(mailTemplateInfoData);
            } else {
                Object[] objectArray = new Object[]{mailTemplateInfoData.getMailTemplateId()};
                log.info((Object)(Messages.getMsg("ImportTool.MailTemplateID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                mailTemplateController.addMailTemplate(mailTemplateInfoData);
            }
        }
        catch (DuplicateKeyException duplicateKeyException) {
            Object[] objectArray = new String[]{mailTemplateInfoData.getMailTemplateId()};
            log.error((Object)Messages.getMsg("ImportTool.Common.1", objectArray));
            System.exit(20);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList getMailTemplateList() {
        MailTemplateController mailTemplateController = EjbConnectionManager.getConnectionManager().getMailTemplateController();
        ArrayList arrayList = null;
        try {
            arrayList = mailTemplateController.getMailTemplateList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

