/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.monitor;

import com.clustercontrol.http.bean.MonitorHttpInfo;
import com.clustercontrol.http.ejb.session.MonitorHttpController;
import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.DuplicateKeyException;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitorNumeric;
import jp.co.intellilink.hinemos.importtool.util.CheckString;
import jp.co.intellilink.hinemos.importtool.util.Config;
import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;
import jp.co.intellilink.hinemos.importtool.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMonitorHttp
extends ImportMonitorNumeric {
    private static Log log = LogFactory.getLog(ImportMonitorHttp.class);
    private ArrayList monitorList = null;
    private ArrayList<ArrayList<String>> monitorInfos = null;

    public void importHttp() {
        log.info((Object)Messages.getMsg("ImportTool.Http.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Input.Dir.Conf") + "/HTTP.csv");
        this.monitorList = this.getMonitorList();
        for (ArrayList<String> arrayList : this.monitorInfos) {
            MonitorInfo monitorInfo = this.createMonitorInfo(arrayList);
            this.registerMonitorInfo(monitorInfo);
        }
        log.info((Object)Messages.getMsg("ImportTool.Http.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    @Override
    protected MonitorInfo createMonitorInfo(ArrayList<String> arrayList) {
        MonitorInfo monitorInfo = new MonitorInfo();
        this.createMonitorBase(arrayList, monitorInfo);
        this.createMonitorRule(arrayList.subList(3, 5), monitorInfo);
        this.createMonitorCheck(arrayList.subList(5, 7), monitorInfo);
        this.createMonitorJudgement(arrayList.subList(7, 12), monitorInfo);
        this.createMonitorNotify(arrayList.subList(12, 17), monitorInfo);
        this.createMonitorApplication(arrayList.subList(17, 18), monitorInfo);
        this.createMonitorVaild(arrayList.subList(18, 19), monitorInfo);
        return monitorInfo;
    }

    @Override
    protected void createMonitorCheck(List<String> list, MonitorInfo monitorInfo) {
        MonitorHttpInfo monitorHttpInfo = new MonitorHttpInfo();
        String string = CheckString.checkLength(list.get(0), 2083);
        if (!string.equals(list.get(0))) {
            Object[] objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"request.url"), "2083"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
        }
        monitorHttpInfo.setRequestUrl(string);
        monitorHttpInfo.setTimeout(Integer.parseInt(list.get(1)));
        monitorInfo.setCheckInfo((MonitorCheckInfo)monitorHttpInfo);
        monitorInfo.setMonitorType(1);
        super.createMonitorCheck(list, monitorInfo);
    }

    protected void registerMonitorInfo(MonitorInfo monitorInfo) {
        MonitorHttpController monitorHttpController = EjbConnectionManager.getConnectionManager().getMonitorHttpController();
        try {
            ArrayList arrayList = this.checkMonitorList(monitorInfo.getMonitorId(), this.monitorList);
            if (arrayList instanceof ArrayList) {
                Date date = (Date)arrayList.get(8);
                String string = (String)arrayList.get(7);
                monitorInfo.setRegDate(new Timestamp(date.getTime()));
                monitorInfo.setRegUser(string);
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("ImportTool.MonitorID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                monitorHttpController.modifyHttp(monitorInfo);
            } else {
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("ImportTool.MonitorID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                monitorHttpController.addHttp(monitorInfo);
            }
        }
        catch (DuplicateKeyException duplicateKeyException) {
            Object[] objectArray = new String[]{monitorInfo.getMonitorId()};
            log.error((Object)Messages.getMsg("ImportTool.Common.1", objectArray));
            System.exit(20);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList getMonitorList() {
        MonitorHttpController monitorHttpController = EjbConnectionManager.getConnectionManager().getMonitorHttpController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorHttpController.getHttpList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

