/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.eclipse.jdt.internal.junit.launcher;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jp.co.dgic.eclipse.jdt.internal.junit.ui.DJUnitMessages;
import jp.co.dgic.eclipse.jdt.internal.junit.ui.DJUnitProjectPropertyPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.SocketUtil;

public class DJUnitLaunchConfiguration
extends JUnitLaunchConfigurationDelegate {
    public static final String ID_JUNIT_APPLICATION = "jp.co.dgic.eclipse.jdt.djunit.launchconfig";
    public static final String ID_DJUNIT_CLIENT_PORT = "jp.co.dgic.eclipse.jdt.djunit.client.port";
    private static final String LIB_DIR = "lib/";
    private int clientPort = -1;
    private static final String DJUNIT_CLASS_LOADER = "jp.co.dgic.testing.common.DJUnitEclipseClassLoader";
    private static final String TEST_RUNNER_CLASS_NAME = "jp.co.dgic.eclipse.jdt.internal.junit.runner.DJUnitRunner";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor pm) throws CoreException {
        this.clientPort = SocketUtil.findFreePort();
        launch.setAttribute(ID_DJUNIT_CLIENT_PORT, String.valueOf(this.clientPort));
        super.launch(configuration, mode, launch, pm);
    }

    public String verifyMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        return TEST_RUNNER_CLASS_NAME;
    }

    protected void collectExecutionArguments(ILaunchConfiguration configuration, List vmArguments, List programArguments) throws CoreException {
        super.collectExecutionArguments(configuration, vmArguments, programArguments);
        programArguments.add("-djunitport");
        programArguments.add(Integer.toString(this.clientPort));
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        String[] cp = super.getClasspath(configuration);
        return this.addDJUnitClassPath(cp);
    }

    private String[] addDJUnitClassPath(String[] classPath) throws CoreException {
        URL url = Platform.getBundle((String)"jp.co.dgic.eclipse.jdt.djunit").getEntry("/");
        String[] newClassPath = null;
        try {
            ArrayList<String> junitEntries = new ArrayList<String>();
            if (Platform.inDevelopmentMode()) {
                try {
                    junitEntries.add(FileLocator.toFileURL((URL)new URL(url, "bin")).getFile());
                }
                catch (IOException e1) {
                    try {
                        junitEntries.add(FileLocator.toFileURL((URL)new URL(url, "djunit.jar")).getFile());
                    }
                    catch (IOException iOException) {}
                }
            } else {
                junitEntries.add(FileLocator.toFileURL((URL)new URL(url, "djunit.jar")).getFile());
            }
            this.addRequiredJars(junitEntries, url);
            newClassPath = new String[classPath.length + junitEntries.size()];
            Object[] jea = junitEntries.toArray();
            System.arraycopy(classPath, 0, newClassPath, 0, classPath.length);
            System.arraycopy(jea, 0, newClassPath, classPath.length, jea.length);
        }
        catch (IOException e) {
            JUnitPlugin.log((Throwable)e);
        }
        return newClassPath;
    }

    private void addRequiredJars(List junitEntries, URL djunitURL) throws IOException {
        junitEntries.add(FileLocator.toFileURL((URL)new URL(djunitURL, "lib/jcoverage-djunit-1.0.5.jar")).getFile());
        junitEntries.add(FileLocator.toFileURL((URL)new URL(djunitURL, "lib/bcel-5.2.jar")).getFile());
        junitEntries.add(FileLocator.toFileURL((URL)new URL(djunitURL, "lib/asm-3.0.jar")).getFile());
        junitEntries.add(FileLocator.toFileURL((URL)new URL(djunitURL, "lib/jakarta-oro-2.0.7.jar")).getFile());
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        IJavaProject javaProject = this.getJavaProject(configuration);
        if (javaProject == null || !javaProject.exists()) {
            this.abort(JUnitMessages.JUnitLaunchConfigurationDelegate_error_invalidproject, null, 107);
        }
        if (!this.existsCoverageWorkingDirectory(javaProject)) {
            String workingDirectoryName = DJUnitProjectPropertyPage.readWorkingDirectory(javaProject.getProject());
            this.abort(DJUnitMessages.getFormattedString("DJUnit.message.error.workdirectory.notexist", workingDirectoryName), null, 108);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.getCoverageWorkingDirectory(javaProject));
        sb.append(" ");
        sb.append(this.getSourceDirectories(javaProject));
        sb.append(" ");
        sb.append(this.getCoverageIncludedPatterns(javaProject));
        sb.append(" ");
        sb.append(this.getCoverageExcludedPatterns(javaProject));
        sb.append(" ");
        sb.append(this.getUseCoverage(javaProject));
        sb.append(" ");
        sb.append(this.getUseVirtualMock(javaProject));
        sb.append(" ");
        sb.append(this.getIgnoreLibrary(javaProject));
        sb.append(" ");
        sb.append(this.getNotIgnorePatterns(javaProject));
        sb.append(" ");
        sb.append(this.getUseNoverify(javaProject));
        sb.append(" ");
        sb.append(this.getBytecodeLibrary(javaProject));
        sb.append(" ");
        sb.append(this.createClassLoaderOption());
        sb.append(" ");
        sb.append(super.getVMArguments(configuration));
        return sb.toString();
    }

    private String getCoverageWorkingDirectory(IJavaProject javaProject) {
        String workingDirectoryName = DJUnitProjectPropertyPage.readWorkingDirectory(javaProject.getProject());
        String value = javaProject.getProject().getLocation() + workingDirectoryName;
        return this.createSystemPropertyOption("com.jcoverage.rawcoverage.dir", value);
    }

    private String getSourceDirectories(IJavaProject javaProject) throws CoreException {
        HashSet dirs = new HashSet();
        HashSet checkedProjects = new HashSet();
        this.findSourceDirs(javaProject, dirs, checkedProjects);
        StringBuffer sb = new StringBuffer();
        Iterator it = dirs.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            sb.append(";");
        }
        return this.createSystemPropertyOption("jp.co.dgic.eclipse.project.source.dir", sb.toString());
    }

    private void findSourceDirs(IJavaProject javaProject, Set sourceDirs, Set checkedProjects) throws CoreException {
        if (checkedProjects.contains(javaProject.getProject().getName())) {
            return;
        }
        checkedProjects.add(javaProject.getProject().getName());
        this.findSourceDirFrom(javaProject, sourceDirs);
        try {
            String[] names = javaProject.getRequiredProjectNames();
            int i = 0;
            while (i < names.length) {
                IJavaProject requiredProject = javaProject.getJavaModel().getJavaProject(names[i]);
                this.findSourceDirs(requiredProject, sourceDirs, checkedProjects);
                ++i;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void findSourceDirFrom(IJavaProject javaProject, Set sourceDirs) throws CoreException {
        try {
            IPackageFragmentRoot[] roots = javaProject.getAllPackageFragmentRoots();
            int idx = 0;
            while (idx < roots.length) {
                int kind = roots[idx].getKind();
                if (kind == 1) {
                    sourceDirs.add(roots[idx].getResource().getLocation());
                }
                ++idx;
            }
        }
        catch (JavaModelException e) {
            throw new CoreException(e.getStatus());
        }
    }

    private String getCoverageExcludedPatterns(IJavaProject javaProject) {
        String excludedPatterns = DJUnitProjectPropertyPage.readCoverageExcludedPatterns(javaProject.getProject());
        if (excludedPatterns == null || "".equals(excludedPatterns)) {
            return "";
        }
        return this.createSystemPropertyOption("jp.co.dgic.eclipse.coverage.excluded.patterns", excludedPatterns);
    }

    private String getCoverageIncludedPatterns(IJavaProject javaProject) {
        String includedPatterns = DJUnitProjectPropertyPage.readCoverageIncludedPatterns(javaProject.getProject());
        if (includedPatterns == null || "".equals(includedPatterns)) {
            return "";
        }
        return this.createSystemPropertyOption("jp.co.dgic.eclipse.coverage.included.patterns", includedPatterns);
    }

    private String getUseCoverage(IJavaProject javaProject) {
        boolean isUseCoverage = DJUnitProjectPropertyPage.readUseCoverage(javaProject.getProject());
        return this.createSystemPropertyOption("jp.co.dgic.eclipse.coverage.usecoverage", isUseCoverage);
    }

    private String getUseVirtualMock(IJavaProject javaProject) {
        boolean isUseVirtualMock = DJUnitProjectPropertyPage.readUseVirtualMock(javaProject.getProject());
        return this.createSystemPropertyOption("jp.co.dgic.eclipse.virtualmock.usevirtualmock", isUseVirtualMock);
    }

    private String getIgnoreLibrary(IJavaProject javaProject) {
        boolean isIgnoreLibrary = DJUnitProjectPropertyPage.readIgnoreLibrary(javaProject.getProject());
        return this.createSystemPropertyOption("jp.co.dgic.eclipse.virtualmock.ignore.library", isIgnoreLibrary);
    }

    private String getNotIgnorePatterns(IJavaProject javaProject) {
        String notIgnorePatterns = DJUnitProjectPropertyPage.readNotIgnorePatterns(javaProject.getProject());
        if (notIgnorePatterns == null || "".equals(notIgnorePatterns)) {
            return "";
        }
        return this.createSystemPropertyOption("jp.co.dgic.eclipse.virtualmock.notignore.patterns", notIgnorePatterns);
    }

    private String getUseNoverify(IJavaProject javaProject) {
        boolean isUseNoverify = DJUnitProjectPropertyPage.readUseNoverify(javaProject.getProject());
        return isUseNoverify ? "-noverify" : "";
    }

    private String getBytecodeLibrary(IJavaProject javaProject) {
        String library = DJUnitProjectPropertyPage.readBytecodeLibrary(javaProject.getProject());
        return this.createSystemPropertyOption("jp.co.dgic.eclipse.classloader.bytecodelibrary", library);
    }

    private String createClassLoaderOption() {
        return this.createSystemPropertyOption("java.system.class.loader", DJUNIT_CLASS_LOADER);
    }

    private String createSystemPropertyOption(String key, String value) {
        return "-D" + key + "=\"" + value + "\"";
    }

    private String createSystemPropertyOption(String key, boolean value) {
        return "-D" + key + "=" + value;
    }

    private boolean existsCoverageWorkingDirectory(IJavaProject javaProject) {
        String workingDirectory = DJUnitProjectPropertyPage.readWorkingDirectory(javaProject.getProject());
        if (workingDirectory == null || "".equals(workingDirectory)) {
            return true;
        }
        String workDirectoryPath = javaProject.getProject().getLocation().append(workingDirectory).toString();
        File dir = new File(workDirectoryPath);
        return dir.exists() && dir.isDirectory();
    }
}

