/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool;

import java.util.Arrays;

import javax.naming.NamingException;

import jp.co.intellilink.hinemos.importtool.conf.monitor.OnOffMonitorAgent;
import jp.co.intellilink.hinemos.importtool.util.LoginManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * StopConf メインクラス<br>
 * 
 * @version 1.1.0
 * @since 1.1.0
 */
public class OnOffConf {
	// main関数に与えられる引数
	private static String mode = "all";
	// main関数に与えられる引数
	private static boolean valid = true;
	
	// ログ出力
	private static Log log = LogFactory.getLog(OnOffConf.class);

	/**
	 * メイン
	 * 
	 * @param args
	 */
	public static void main(String[] args) {

		// 実行ログを記載
		log.info(Messages.getMsg("ImportTool.Exec") + " : " + Arrays.toString(args));

		// 引数の数の確認
		if (args.length > 1) {
			log.error(Messages.getMsg("ImportTool.ArgsInvalid"));
			System.exit(11);
		}

		// 引数の格納
		if(args.length == 0 || args[0].equals(""))
			mode = "all";
		else if(args.length >= 1)
			mode = args[0];
		
		if(args.length == 2){
			if(args[2].equals("on"))
				valid = true;
			else
				valid = false;
		}

//		if(mode.equalsIgnoreCase("access") || mode.equalsIgnoreCase("all")){
//			//アクセス
//			ImportAccess access = new ImportAccess();
//			access.importAccess();
//		}
//		if(mode.equalsIgnoreCase("mail") || mode.equalsIgnoreCase("all")){
//			//メールテンプレート
//			ImportMailTemplate mail = new ImportMailTemplate();
//			mail.importMailTemplate();
//		}
//		if(mode.equalsIgnoreCase("notify") || mode.equalsIgnoreCase("all")){
//			//通知
//			ImportNotify notify = new ImportNotify();
//			notify.importNotify();
//		}
//		if(mode.equalsIgnoreCase("node") || mode.equalsIgnoreCase("all")){
//			//ノード
//			ImportNode node = new ImportNode();
//			node.importNode();
//		}
//		if(mode.equalsIgnoreCase("scope") || mode.equalsIgnoreCase("all")){
//			//スコープ
//			ImportScope scope = new ImportScope();
//			scope.importScope();
//			//スコープへのノード割り当て
//			ImportNodeScope nodeScope = new ImportNodeScope();
//			nodeScope.importNodeScope();
//		}
//		if(mode.equalsIgnoreCase("cal") || mode.equalsIgnoreCase("all")){
//			//カレンダ
//			ImportCalendar cal = new ImportCalendar();
//			cal.importCalendar();
//		}
//		if(mode.equalsIgnoreCase("log") || mode.equalsIgnoreCase("all")){
//			//ログ転送
//			ImportLogTransfer log = new ImportLogTransfer();
//			log.importLogTransfer();
//		}
		if(mode.equalsIgnoreCase("agent") || mode.equalsIgnoreCase("all")){
			//エージェント監視
			OnOffMonitorAgent agent = new OnOffMonitorAgent();
			agent.changeValid(valid);
		}
//		if(mode.equalsIgnoreCase("http") || mode.equalsIgnoreCase("all")){
//			//HTTP監視
//			ImportMonitorHttp http = new ImportMonitorHttp();
//			http.importHttp();
//		}
//		if(mode.equalsIgnoreCase("ping") || mode.equalsIgnoreCase("all")){
//			//Ping監視
//			ImportMonitorPing ping = new ImportMonitorPing();
//			ping.importPing();
//		}
//		if(mode.equalsIgnoreCase("port") || mode.equalsIgnoreCase("all")){
//			//サービス・ポート監視
//			ImportMonitorPort port = new ImportMonitorPort();
//			port.importPort();
//		}
//		if(mode.equalsIgnoreCase("process") || mode.equalsIgnoreCase("all")){
//			//プロセス監視
//			ImportMonitorProcess process = new ImportMonitorProcess();
//			process.importProcess();
//		}
//		if(mode.equalsIgnoreCase("resource") || mode.equalsIgnoreCase("all")){
//			//リソース監視
//			ImportMonitorPerformance perf = new ImportMonitorPerformance();
//			perf.importPerformance();
//		}
//		if(mode.equalsIgnoreCase("sql") || mode.equalsIgnoreCase("all")){
//			//SQL監視
//			ImportMonitorSql sql = new ImportMonitorSql();
//			sql.importSql();
//		}
//		if(mode.equalsIgnoreCase("snmp") || mode.equalsIgnoreCase("all")){
//			//SNMP監視
//			ImportMonitorSnmp snmp = new ImportMonitorSnmp();
//			snmp.importSnmp();
//		}
//		if(mode.equalsIgnoreCase("trap") || mode.equalsIgnoreCase("all")){
//			//SNMPTRAP監視
//			ImportMonitorSnmpTrap trap = new ImportMonitorSnmpTrap();
//			trap.importSnmpTrap();
//		}
//		if(mode.equalsIgnoreCase("syslog") || mode.equalsIgnoreCase("all")){
//			//Syslog-ng監視
//			ImportMonitorSyslogng syslogng = new ImportMonitorSyslogng();
//			syslogng.importSyslogng();
//		}
//		if(mode.equalsIgnoreCase("perf") || mode.equalsIgnoreCase("all")){
//			//性能管理機能の実績収集
//			ImportPerformance perf = new ImportPerformance();
//			perf.importPerformance();
//		}
//		if(mode.equalsIgnoreCase("mainte") || mode.equalsIgnoreCase("all")){
//			//メンテナンス
//			ImportMaintenance maintenance = new ImportMaintenance();
//			maintenance.importMaintenance();
//		}
//		if(mode.equalsIgnoreCase("job") || mode.equalsIgnoreCase("all")){
//			//ジョブ
//			ImportJob job = new ImportJob();
//			job.importJob();
//		}
//		if(mode.equalsIgnoreCase("sche") || mode.equalsIgnoreCase("all")){
//			//ジョブスケジュール
//			ImportSchedule sche = new ImportSchedule();
//			sche.importSchedule();
//		}
//		else{
//		log.error(Messages.getMsg("ImportTool.ModeNotFound"));
//		System.exit(12);
//		}

		// マネージャー接続の切断
		try {
			LoginManager.getContextManager().logout();
		} catch (NamingException e) {
			log.warn(Messages.getMsg("ImportTool.DisconnectManagerFailed"), e);
		}

		// 正常終了
		log.info(Messages.getMsg("ImportTool.Exit"));
		System.exit(0);
	}
}
