/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.notify;

import java.util.ArrayList;
import java.util.Iterator;

import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.notify.bean.NotifyTableDefine;
import com.clustercontrol.notify.ejb.session.NotifyController;

/**
 * 通知情報を削除するクラス<br>
 * 
 * @version 1.1.0
 * @since 1.1.0
 */
public class DeleteNotify {

	// ログ出力
	private static Log log = LogFactory.getLog(DeleteNotify.class);

	/**
	 * 通知情報を削除する。<br>
	 */
	@SuppressWarnings("unchecked")
	public void delete() {
		log.info(Messages.getMsg("ImportTool.Nofity.Start", new String[]{Messages.getMsg("ImportTool.Delete")}));

		//通知リスト取得
		ArrayList idList = getNotifyList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();

				deleteNotifyInfo((String)line.get(NotifyTableDefine.NOTIFY_ID));
			}
		}

		log.info(Messages.getMsg("ImportTool.Nofity.End", new String[]{Messages.getMsg("ImportTool.Delete")}));
	}

	/**
	 * 通知情報を削除する。<br>
	 * 
	 * @param notifyId 通知ID
	 */
	protected void deleteNotifyInfo(String notifyId) {

		NotifyController notify = EjbConnectionManager.getConnectionManager().getNotifyController();

		try {
			Object[] args = {notifyId};
			log.info(Messages.getMsg("ImportTool.NotifyID", args) + 
					" (" + Messages.getMsg("delete") + ")");

			notify.deleteNotify(notifyId);
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * 通知リストを取得する。<br>
	 * 
	 * @return 通知一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getNotifyList() {

		NotifyController notify = EjbConnectionManager.getConnectionManager().getNotifyController();

		ArrayList records = null;
		try {
			records = notify.getNotifyList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}