/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.test.job;

import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.monitor.bean.ReportEventInfo;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import jp.co.intellilink.hinemos.test.util.Config;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import jp.co.intellilink.hinemos.test.util.StringListComparator;
import jp.co.intellilink.hinemos.test.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckResultJob {
    private Date fromDate;
    private Date toDate;
    private static Log log = LogFactory.getLog(CheckResultJob.class);

    public CheckResultJob(Date date, Date date2) {
        this.fromDate = date;
        this.toDate = date2;
    }

    public void checkResult() {
        log.info((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.Job.Start")));
        JobTreeItem jobTreeItem = this.getJobTree();
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        this.getJobData(jobTreeItem, arrayList);
        Collections.sort(arrayList, new StringListComparator(0));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Check.Output.Dir") + "/JOB_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.Job.End")));
    }

    public void getJobData(JobTreeItem jobTreeItem, ArrayList<ArrayList<String>> arrayList) {
        JobTreeItem[] jobTreeItemArray;
        if (jobTreeItem.getData() instanceof JobInfo && (jobTreeItemArray = jobTreeItem.getData()).getId() != null && jobTreeItemArray.getId().compareTo("") != 0) {
            Object[] objectArray = new Object[]{jobTreeItemArray.getId()};
            log.info((Object)Messages.getMsg("TestTool.JobID", objectArray));
            arrayList.add(this.createCsvFormat((JobInfo)jobTreeItemArray));
        }
        jobTreeItemArray = jobTreeItem.getChildren();
        for (JobTreeItem jobTreeItem2 : jobTreeItemArray) {
            this.getJobData(jobTreeItem2, arrayList);
        }
    }

    public ArrayList<String> createCsvFormat(JobInfo jobInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(jobInfo.getId());
        arrayList.add(jobInfo.getName());
        arrayList.add(JobConstant.typeToString((int)jobInfo.getType()));
        arrayList.addAll(this.checkEventByPriority(jobInfo, 3, this.fromDate, this.toDate));
        arrayList.addAll(this.checkEventByPriority(jobInfo, 2, this.fromDate, this.toDate));
        arrayList.addAll(this.checkEventByPriority(jobInfo, 0, this.fromDate, this.toDate));
        return arrayList;
    }

    protected ArrayList<String> checkEventByPriority(JobInfo jobInfo, int n, Date date, Date date2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = JobConstant.typeToString((int)jobInfo.getType());
        Object[] objectArray = new String[]{string, jobInfo.getName(), jobInfo.getId()};
        String string2 = "";
        if (n == 3) {
            string2 = Messages.getMsg("message.job.2", objectArray);
        } else if (n == 2) {
            string2 = Messages.getMsg("message.job.3", objectArray);
        } else if (n == 0) {
            string2 = Messages.getMsg("message.job.4", objectArray);
        }
        ReportEventInfo reportEventInfo = null;
        ReportEventInfo reportEventInfo2 = this.findEvent(string2, date, date2);
        if (reportEventInfo2 instanceof ReportEventInfo && reportEventInfo2.getMessage() instanceof String) {
            String string3 = Messages.getMsg("message.job.1", objectArray) + reportEventInfo2.getMessage().substring(string2.length());
            reportEventInfo = this.findEvent(string3, date, date2);
        }
        if (reportEventInfo instanceof ReportEventInfo) {
            arrayList.add(DateFormat.getDateTimeInstance().format(reportEventInfo.getGenerationDate()));
        } else {
            arrayList.add("");
        }
        if (reportEventInfo2 instanceof ReportEventInfo) {
            arrayList.add(DateFormat.getDateTimeInstance().format(reportEventInfo2.getGenerationDate()));
        } else {
            arrayList.add("");
        }
        return arrayList;
    }

    protected ReportEventInfo findEvent(String string, Date date, Date date2) {
        ArrayList<ReportEventInfo> arrayList = EjbConnectionManager.getConnectionManager().getEvent(null, date, date2);
        ReportEventInfo reportEventInfo = null;
        for (ReportEventInfo reportEventInfo2 : arrayList) {
            if (!(reportEventInfo2.getMessage() instanceof String) || reportEventInfo2.getMessage().indexOf(string) == -1) continue;
            if (reportEventInfo instanceof ReportEventInfo) {
                if (!reportEventInfo.getGenerationDate().before(reportEventInfo2.getGenerationDate())) continue;
                reportEventInfo = reportEventInfo2;
                continue;
            }
            reportEventInfo = reportEventInfo2;
        }
        return reportEventInfo;
    }

    protected JobTreeItem getJobTree() {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        JobTreeItem jobTreeItem = null;
        try {
            jobTreeItem = jobController.getJobTree(true, Locale.getDefault());
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("TestTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return jobTreeItem;
    }
}

