/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.eclipse.jdt.internal.coverage.report.html;

import com.jcoverage.coverage.Instrumentation;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.Map;
import jp.co.dgic.eclipse.jdt.internal.coverage.report.html.HtmlReportDriver;
import jp.co.dgic.eclipse.jdt.internal.coverage.report.html.IDJUnitProgressMonitor;
import jp.co.dgic.testing.common.util.DJUnitUtil;

public class HtmlReportGenerator {
    static File serializationFile;
    static File[] srcDirs;
    static File destDir;
    private static MockProgressMonitor mockMonitor;
    static byte[] buf;
    static /* synthetic */ Class class$0;

    static {
        mockMonitor = new MockProgressMonitor();
        buf = new byte[14];
    }

    public static void main(String[] args) throws Exception {
        HtmlReportGenerator.generate(args, mockMonitor);
    }

    public static void generate(String[] args, IDJUnitProgressMonitor monitor) throws Exception {
        serializationFile = new File(args[1]);
        if (!serializationFile.exists()) {
            throw new Exception("[ERROR] serialization file " + serializationFile + " does not exist");
        }
        if (serializationFile.isDirectory()) {
            throw new Exception("[ERROR] serialization file " + serializationFile + " cannot be a directory");
        }
        srcDirs = HtmlReportGenerator.getSourceDirectories(args[3]);
        if (srcDirs.length == 0) {
            throw new Exception("[ERROR] source directory argument value");
        }
        int i = 0;
        while (i < srcDirs.length) {
            if (!srcDirs[i].exists()) {
                throw new Exception("[ERROR] source directory " + srcDirs[i] + " does not exist");
            }
            if (srcDirs[i].isFile()) {
                throw new Exception("[ERROR] source directory " + srcDirs[i] + " should be a directory, not a file");
            }
            ++i;
        }
        destDir = new File(args[5]);
        if (destDir.exists() && destDir.isFile()) {
            throw new Exception("[ERROR] destination directory " + destDir + " already exists and is a file");
        }
        destDir.mkdirs();
        File imagesDir = new File(destDir, "images");
        imagesDir.mkdirs();
        HtmlReportGenerator.copyResource("red.gif", imagesDir);
        HtmlReportGenerator.copyResource("green.gif", imagesDir);
        HtmlReportDriver driver = new HtmlReportDriver(srcDirs);
        FileInputStream is = new FileInputStream(serializationFile);
        ObjectInputStream objects = new ObjectInputStream(is);
        Map coverageData = (Map)objects.readObject();
        int total = coverageData.size();
        int count = 1;
        monitor.beginTask("(0/" + total + ")", total);
        Iterator it = coverageData.entrySet().iterator();
        while (it.hasNext()) {
            if (monitor.isCanceled()) break;
            Map.Entry entry = it.next();
            monitor.setTaskName("(" + count + "/" + total + ")");
            monitor.subTask(entry.getKey().toString());
            driver.addInstrumentation((String)entry.getKey(), (Instrumentation)entry.getValue());
            ++count;
            monitor.worked(1);
        }
        driver.generate(destDir);
        monitor.done();
    }

    static String toPackage(String clzName) {
        int i = clzName.lastIndexOf(46);
        if (i == -1) {
            return "default";
        }
        return clzName.substring(0, i);
    }

    static void copyResource(String resname, File dir) throws IOException {
        int n;
        FileOutputStream fos = new FileOutputStream(new File(dir, resname));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.jcoverage.coverage.reporting.Main");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BufferedInputStream in = new BufferedInputStream(clazz.getResourceAsStream(resname));
        while ((n = ((InputStream)in).read(buf, 0, buf.length)) != -1) {
            fos.write(buf, 0, n);
        }
        ((InputStream)in).close();
        fos.close();
    }

    private static File[] getSourceDirectories(String sourceDirectories) {
        if (sourceDirectories == null) {
            return new File[0];
        }
        String[] directoryPaths = HtmlReportGenerator.splitPath(sourceDirectories);
        File[] dirs = new File[directoryPaths.length];
        int i = 0;
        while (i < dirs.length) {
            dirs[i] = new File(directoryPaths[i]);
            ++i;
        }
        return dirs;
    }

    private static String[] splitPath(String sourceDirectories) {
        return DJUnitUtil.splitValue(sourceDirectories);
    }

    private static class MockProgressMonitor
    implements IDJUnitProgressMonitor {
        private MockProgressMonitor() {
        }

        public void beginTask(String name, int totalWork) {
        }

        public void done() {
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean value) {
        }

        public void setTaskName(String name) {
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
        }
    }
}

