/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.testing.common.virtualmock.asm;

import java.io.IOException;
import jp.co.dgic.testing.common.AbstractAsmModifier;
import jp.co.dgic.testing.common.virtualmock.InternalMockObjectManager;
import jp.co.dgic.testing.common.virtualmock.VirtualMockUtil;
import jp.co.dgic.testing.common.virtualmock.asm.AsmClassChecker;
import jp.co.dgic.testing.common.virtualmock.asm.AsmClassVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class AsmAdviceImplementer
extends AbstractAsmModifier {
    protected static final String CONSTRUCTOR_METHOD_NAME = "<init>";
    protected static final String MANAGER_PACKAGE_NAME = "jp.co.dgic.testing.common.virtualmock.";
    protected static final String MANAGER_CLASS_NAME = "jp.co.dgic.testing.common.virtualmock.InternalMockObjectManager";

    public AsmAdviceImplementer() {
        super("VirtualMockObjects");
    }

    protected byte[] modify(String className, ClassReader cr) throws IOException {
        if (!VirtualMockUtil.isUseVirtualMock()) {
            return null;
        }
        if (!VirtualMockUtil.isInclude(className)) {
            return null;
        }
        AsmClassChecker acc = new AsmClassChecker();
        cr.accept((ClassVisitor)acc, 4);
        if (acc.isInterface() || acc.isAnnotation() || acc.isEnum()) {
            return null;
        }
        if (acc.isTestCase()) {
            InternalMockObjectManager.printConsole("class [" + className + "] is TestCase");
            return null;
        }
        AsmClassVisitor asv = new AsmClassVisitor(acc);
        cr.accept((ClassVisitor)asv, 4);
        return asv.toByteArray();
    }
}

