/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.test.monitor;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfo;
import com.clustercontrol.notify.ejb.session.NotifyController;
import com.clustercontrol.notify.monitor.ejb.entity.EventLog;
import com.clustercontrol.notify.monitor.ejb.entity.StatusInfo;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckResultMonitor {
    private Date fromDate;
    private static Log log = LogFactory.getLog(CheckResultMonitor.class);

    public CheckResultMonitor(Date date) {
        this.fromDate = date;
    }

    public ArrayList<ArrayList<String>> createCheckResult(MonitorInfo monitorInfo) {
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.addAll(this.getFacilityIdList(monitorInfo));
        for (String string : arrayList2) {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            arrayList3.add(monitorInfo.getMonitorId());
            arrayList3.add(string);
            arrayList3.addAll(this.checkStatus(monitorInfo, string));
            arrayList3.addAll(this.checkEvent(monitorInfo, string));
            arrayList3.addAll(this.checkNotify(monitorInfo, string));
            arrayList.add(arrayList3);
        }
        return arrayList;
    }

    protected ArrayList<String> getFacilityIdList(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (monitorInfo.getMonitorBlock() == 0) {
            arrayList.addAll(this.getNodeList(monitorInfo.getFacilityId()));
        } else {
            arrayList.add(monitorInfo.getFacilityId());
        }
        return arrayList;
    }

    protected ArrayList<String> checkStatus(MonitorInfo monitorInfo, String string) {
        Collection collection;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "-";
        if (monitorInfo.getValid() == 0) {
            arrayList.add(string2);
            return arrayList;
        }
        String string3 = null;
        if (monitorInfo.getNotifyId() != null) {
            collection = monitorInfo.getNotifyId();
            for (int i = 0; i < collection.size(); ++i) {
                NotifyRelationInfo notifyRelationInfo = (NotifyRelationInfo)((ArrayList)collection).get(i);
                if (notifyRelationInfo.getNotifyType() != 0) continue;
                string3 = notifyRelationInfo.getNotifyId();
                break;
            }
        }
        if (string3 != null) {
            string2 = "NG";
            collection = EjbConnectionManager.getConnectionManager().getStatus(string);
            for (StatusInfo statusInfo : collection) {
                try {
                    if (statusInfo.getMonitorId().compareTo(monitorInfo.getMonitorId()) != 0) continue;
                    string2 = DateFormat.getDateTimeInstance().format(statusInfo.getGenerationDate());
                    if (statusInfo.getExpirationFlg() != 10) {
                        string2 = DateFormat.getDateTimeInstance().format(statusInfo.getGenerationDate());
                    }
                    break;
                }
                catch (RemoteException remoteException) {
                    log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)remoteException);
                    System.exit(14);
                }
            }
        } else {
            string2 = "-";
        }
        arrayList.add(string2);
        return arrayList;
    }

    protected ArrayList<String> checkEvent(MonitorInfo monitorInfo, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "-";
        String string3 = "-";
        String string4 = "-";
        String string5 = "-";
        if (monitorInfo.getValid() == 0) {
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(string4);
            arrayList.add(string5);
            return arrayList;
        }
        String string6 = null;
        if (monitorInfo.getNotifyId() != null) {
            Collection collection = monitorInfo.getNotifyId();
            for (int i = 0; i < collection.size(); ++i) {
                NotifyRelationInfo notifyRelationInfo = (NotifyRelationInfo)((ArrayList)collection).get(i);
                if (notifyRelationInfo.getNotifyType() != 1) continue;
                string6 = notifyRelationInfo.getNotifyId();
                break;
            }
        }
        if (string6 != null) {
            string2 = this.checkEventByPriority(monitorInfo, string, 3, this.fromDate);
            string3 = this.checkEventByPriority(monitorInfo, string, 2, this.fromDate);
            string4 = this.checkEventByPriority(monitorInfo, string, 0, this.fromDate);
            string5 = this.checkEventByPriority(monitorInfo, string, 1, this.fromDate);
        }
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.add(string4);
        arrayList.add(string5);
        return arrayList;
    }

    protected String checkEventByPriority(MonitorInfo monitorInfo, String string, int n, Date date) {
        String string2 = "";
        Collection collection = EjbConnectionManager.getConnectionManager().getEventByPriority(string, n, date);
        for (EventLog eventLog : collection) {
            try {
                String string3 = eventLog.getMonitorId();
                if (string3.compareTo(monitorInfo.getMonitorId()) != 0) continue;
                string2 = DateFormat.getDateTimeInstance().format(eventLog.getGenerationDate());
                break;
            }
            catch (RemoteException remoteException) {
                log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)remoteException);
                System.exit(14);
            }
        }
        return string2;
    }

    protected ArrayList<String> checkNotify(MonitorInfo monitorInfo, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "-";
        String string3 = "-";
        String string4 = "-";
        String string5 = "-";
        String string6 = "-";
        if (monitorInfo.getValid() == 0) {
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(string4);
            arrayList.add(string5);
            arrayList.add(string6);
            return arrayList;
        }
        if (monitorInfo.getNotifyId() != null) {
            Collection collection = monitorInfo.getNotifyId();
            for (int i = 0; i < collection.size(); ++i) {
                NotifyRelationInfo notifyRelationInfo = (NotifyRelationInfo)((ArrayList)collection).get(i);
                if (notifyRelationInfo.getNotifyType() == 0) {
                    string2 = this.checkNotifyInhibit(monitorInfo, notifyRelationInfo.getNotifyId(), string);
                    continue;
                }
                if (notifyRelationInfo.getNotifyType() == 1) {
                    string3 = this.checkNotifyInhibit(monitorInfo, notifyRelationInfo.getNotifyId(), string);
                    continue;
                }
                if (notifyRelationInfo.getNotifyType() == 2) {
                    string4 = this.checkNotifyInhibit(monitorInfo, notifyRelationInfo.getNotifyId(), string);
                    continue;
                }
                if (notifyRelationInfo.getNotifyType() == 3) {
                    string5 = this.checkNotifyInhibit(monitorInfo, notifyRelationInfo.getNotifyId(), string);
                    continue;
                }
                if (notifyRelationInfo.getNotifyType() != 4) continue;
                string6 = this.checkNotifyInhibit(monitorInfo, notifyRelationInfo.getNotifyId(), string);
            }
        }
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.add(string4);
        arrayList.add(string5);
        arrayList.add(string6);
        return arrayList;
    }

    protected String checkNotifyInhibit(MonitorInfo monitorInfo, String string, String string2) {
        String string3 = "NG";
        NotifyInfo notifyInfo = this.getNotify(string);
        if (notifyInfo.getInhibitionFlg() != 0) {
            NotifyActionInhibitionInfo notifyActionInhibitionInfo = EjbConnectionManager.getConnectionManager().getNotifyActionInhibition(monitorInfo.getNotifyGroupId(), string, string2);
            try {
                if (notifyActionInhibitionInfo instanceof NotifyActionInhibitionInfo && notifyActionInhibitionInfo.getTotalCount() > 0L) {
                    string3 = "OK";
                }
            }
            catch (RemoteException remoteException) {
                log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)remoteException);
                System.exit(14);
            }
        } else {
            string3 = "OK";
        }
        return string3;
    }

    protected NotifyInfo getNotify(String string) {
        NotifyController notifyController = EjbConnectionManager.getConnectionManager().getNotifyController();
        NotifyInfo notifyInfo = null;
        try {
            notifyInfo = notifyController.getNotify(string);
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return notifyInfo;
    }

    protected ArrayList<String> getNodeList(String string) {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (repositoryController.isNode(string)) {
                arrayList.add(string);
            } else {
                arrayList.addAll(repositoryController.getExecTargetFacilityIdList(string));
            }
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

